/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.view;

import ciss.phase_viewer.acviewer.ACVAction;
import ciss.phase_viewer.acviewer.BaseJ3DPanel;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class DrawInvertedAtom
extends ACVAction {
    private Logger logger = Logger.getLogger((String)DrawInvertedAtom.class.getName());

    public DrawInvertedAtom(BaseJ3DPanel panel) {
        super(panel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(this.parent instanceof MainPanel)) {
            return;
        }
        MainPanel acv = (MainPanel)this.parent;
        AtomCoords coords = acv.getCD().getAtomCoords();
        acv.getCD().isRenderingManual(true);
        acv.doUnitCell(new Boolean(true), new Boolean(true), null, null, null);
        acv.prepareRedraw();
        coords.saveState();
        coords.removeBoundaryAtoms();
        AtomList atoms = coords.getAtomList();
        int numat = atoms.getNumAt();
        double[] origin = acv.getCD().getCellOriginVector();
        boolean hasinv = false;
        int i = 0;
        while (i < numat) {
            if (atoms.getAtomAt(i).isInvSymAtom()) {
                hasinv = true;
                break;
            }
            ++i;
        }
        if (hasinv) {
            i = atoms.getNumAt() - 1;
            while (i >= 0) {
                if (atoms.getAtomAt(i).isInvSymAtom()) {
                    atoms.removeAtomAt(i);
                }
                --i;
            }
        } else {
            i = 0;
            while (i < numat) {
                Atom atom = atoms.getAtomAt(i);
                String wei = atom.getProperty("weight");
                this.logger.debug((Object)("origi: " + origin[0] + " " + origin[1] + " " + origin[2]));
                if (wei != null && wei.trim().equals("2") && !atom.isInvSymAtom()) {
                    double[] pos = atom.getDouble();
                    Atom newAtom = atom.getCopy();
                    this.logger.debug((Object)("pos: " + pos[0] + " " + pos[1] + " " + pos[2]));
                    newAtom.setPos(new double[]{-pos[0], -pos[1], -pos[2]});
                    newAtom.isInvSymAtom(true);
                    atoms.addAtom(newAtom);
                }
                ++i;
            }
        }
        acv.getCD().setCoords(coords);
        coords.finalizeState();
        acv.doUnitCell(new Boolean(true), new Boolean(true), null, null, null);
        acv.postRedraw();
        acv.getCD().isRenderingManual(false);
        Cell cell = coords.getCell(0);
        if (cell == null) {
            return;
        }
        double[][] cellve = cell.getDouble();
    }
}

