/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.view;

import ciss.phase_viewer.acviewer.scenegraphelements.Contour;
import ciss.phase_viewer.acviewer.scenegraphelements.Isosurface;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.primitiveguis.ValueSlider;
import ciss.phase_viewer.primitiveguis.ValueSliderListener;
import javax.media.j3d.Node;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class AtomCoordsTrans
extends JPanel
implements ValueSliderListener,
ChangeListener {
    private Logger logger = Logger.getLogger(AtomCoordsTrans.class);
    private TGAtom tgatom;
    private VolumetricData[] vdata;
    private JSpinner spinnera;
    private JSpinner spinnerb;
    private JSpinner spinnerc;
    private SpinnerNumberModel modela;
    private SpinnerNumberModel modelb;
    private SpinnerNumberModel modelc;
    private ValueSlider slider_a;
    private ValueSlider slider_b;
    private ValueSlider slider_c;
    private float prev_a = 0.0f;
    private float prev_b = 0.0f;
    private float prev_c = 0.0f;

    public AtomCoordsTrans(TGAtom tgatom) {
        this.tgatom = tgatom;
        this.vdata = this.tgatom.getParentFrame().getAssociatedVolumetricData();
        this.init();
    }

    private void init() {
        double[][] cellvec;
        this.setLayout(new BoxLayout(this, 1));
        float increa = 0.01f;
        float increb = 0.01f;
        float increc = 0.01f;
        if (this.vdata != null) {
            int[] div = this.vdata[0].getNumDiv();
            increa = 1.0f / (float)(div[0] - 1);
            increb = 1.0f / (float)(div[1] - 1);
            increc = 1.0f / (float)(div[2] - 1);
            this.logger.debug((Object)("increment: " + increa + ", " + increb + ", " + increc));
        }
        if ((cellvec = this.tgatom.getConfigData().getCell()) == null) {
            this.logger.error((Object)"invalid cell data");
            return;
        }
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        Vector3d vec = this.tgatom.getOffset();
        if (vec != null) {
            d0 = vec.x;
            d1 = vec.y;
            d2 = vec.z;
        }
        this.modela = new SpinnerNumberModel(0.0, -0.5, 0.5, increa);
        this.modelb = new SpinnerNumberModel(0.0, -0.5, 0.5, increa);
        this.modelc = new SpinnerNumberModel(0.0, -0.5, 0.5, increa);
        this.spinnera = new JSpinner(this.modela);
        this.spinnerb = new JSpinner(this.modelb);
        this.spinnerc = new JSpinner(this.modelc);
        this.spinnera.setValue(new Double(d0));
        this.spinnerb.setValue(new Double(d1));
        this.spinnerc.setValue(new Double(d2));
        this.spinnera.addChangeListener(this);
        this.spinnerb.addChangeListener(this);
        this.spinnerc.addChangeListener(this);
        this.logger.debug((Object)("init val : " + d0 + ", " + d1 + ", " + d2));
        this.slider_a = new ValueSlider(-0.5f, 0.5f, increa);
        this.slider_a.setOrientation(ValueSlider.VERTICAL);
        this.slider_a.setTitleForBorder("a-axis");
        this.slider_b = new ValueSlider(-0.5f, 0.5f, increb);
        this.slider_b.setOrientation(ValueSlider.VERTICAL);
        this.slider_b.setTitleForBorder("b-axis");
        this.slider_c = new ValueSlider(-0.5f, 0.5f, increc);
        this.slider_c.setOrientation(ValueSlider.VERTICAL);
        this.slider_c.setTitleForBorder("c-axis");
        this.slider_a.setValue((float)d0);
        this.slider_b.setValue((float)d1);
        this.slider_c.setValue((float)d2);
        this.slider_a.addValueSliderListener(this);
        this.slider_b.addValueSliderListener(this);
        this.slider_c.addValueSliderListener(this);
        JPanel pa = new JPanel();
        pa.add(this.slider_a);
        JPanel pb = new JPanel();
        pb.add(this.slider_b);
        JPanel pc = new JPanel();
        pc.add(this.slider_c);
        this.add(pa);
        this.add(pb);
        this.add(pc);
        this.prev_a = this.slider_a.getValue();
        this.prev_b = this.slider_b.getValue();
        this.prev_c = this.slider_c.getValue();
    }

    public void dispose() {
        this.slider_a.removeValueSliderListener(this);
        this.slider_b.removeValueSliderListener(this);
        this.slider_c.removeValueSliderListener(this);
    }

    @Override
    public void valueSliderValueChanged() {
        int i;
        Node[] conts;
        double a = this.slider_a.getValue() - this.prev_a;
        double b = this.slider_b.getValue() - this.prev_b;
        double c = this.slider_c.getValue() - this.prev_c;
        if (a == 0.0 && b == 0.0 && c == 0.0) {
            return;
        }
        Node[] isosurfs = this.tgatom.getChildren(Isosurface.class);
        if (isosurfs != null) {
            this.logger.debug((Object)"found isosurface");
            int i2 = 0;
            while (i2 < isosurfs.length) {
                ((Isosurface)isosurfs[i2]).forceCreation(true);
                ++i2;
            }
        }
        if ((conts = this.tgatom.getChildren(Contour.class)) != null) {
            i = 0;
            while (i < conts.length) {
                ((Contour)conts[i]).forceCreation(true);
                ++i;
            }
        }
        this.tgatom.setAtomOffset(new Vector3d(a, b, c));
        this.tgatom.setOffset(new Vector3d((double)this.slider_a.getValue(), (double)this.slider_b.getValue(), (double)this.slider_c.getValue()));
        this.tgatom.getConfigData().update();
        this.prev_a = this.slider_a.getValue();
        this.prev_b = this.slider_b.getValue();
        this.prev_c = this.slider_c.getValue();
        if (this.vdata != null) {
            i = 0;
            while (i < this.vdata.length) {
                this.vdata[i].setShift(this.slider_a.getValue(), this.slider_b.getValue(), this.slider_c.getValue());
                ++i;
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int i;
        Node[] conts;
        double anow = 0.0;
        double bnow = 0.0;
        double cnow = 0.0;
        try {
            anow = Double.parseDouble(this.spinnera.getValue().toString()) - (double)this.prev_a;
            bnow = Double.parseDouble(this.spinnerb.getValue().toString()) - (double)this.prev_b;
            cnow = Double.parseDouble(this.spinnerc.getValue().toString()) - (double)this.prev_c;
        }
        catch (NumberFormatException e1) {
            this.logger.error((Object)"enter value between -0.5 to 0.5");
            return;
        }
        double a = anow - (double)this.prev_a;
        double b = bnow - (double)this.prev_b;
        double c = cnow - (double)this.prev_c;
        if (a == 0.0 && b == 0.0 && c == 0.0) {
            return;
        }
        Node[] isosurfs = this.tgatom.getChildren(Isosurface.class);
        if (isosurfs != null) {
            this.logger.debug((Object)"found isosurface");
            int i2 = 0;
            while (i2 < isosurfs.length) {
                ((Isosurface)isosurfs[i2]).forceCreation(true);
                ++i2;
            }
        }
        if ((conts = this.tgatom.getChildren(Contour.class)) != null) {
            i = 0;
            while (i < conts.length) {
                ((Contour)conts[i]).forceCreation(true);
                ++i;
            }
        }
        this.tgatom.setAtomOffset(new Vector3d(a, b, c));
        this.tgatom.setOffset(new Vector3d(anow, bnow, cnow));
        this.tgatom.getConfigData().update();
        this.prev_a = (float)anow;
        this.prev_b = (float)bnow;
        this.prev_c = (float)cnow;
        if (this.vdata != null) {
            i = 0;
            while (i < this.vdata.length) {
                this.vdata[i].setShift(anow, bnow, cnow);
                ++i;
            }
        }
    }
}

