/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.prefs.prefseditor;

import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.common.ChoicePanel;
import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.plugins.viewer.prefs.prefseditor.ACVEditors;
import ciss.phase_viewer.primitiveguis.ColorButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import say.swing.JFontChooser;

class PrefsEditor
extends ACVEditors {
    private static Logger logger = Logger.getLogger((String)PrefsEditor.class.getName());
    private InputPanel bondfactor_ip;
    private InputPanel bondwidth_ip;
    private JCheckBox checklightbond;
    private JCheckBox drawcell_cb;
    private JCheckBox cell_is_wire;
    private InputPanel cellwidth_ip;
    private InputPanel scale_ip;
    private InputPanel scaleatom_ip;
    private InputPanel numnodesatom_ip;
    private InputPanel numnodesbond_ip;
    private InputPanel numnodescell_ip;
    private JCheckBox axis_cb;
    private JCheckBox label_cb;
    private InputPanel labeloffset_ip;
    private JCheckBox legend_cb;
    private JCheckBox mobile_cb;
    private ChoicePanel mobile_cp;
    private JButton btnFont;
    private ColorButton btnFontColor;
    private JComboBox atomRender;
    private ColorButton cbbgcolor;
    private ColorButton cbbondcolor;
    private ColorButton cbcellcolor;

    protected PrefsEditor(MainPanel mp) {
        super(mp);
    }

    @Override
    protected void createGUI() {
        PrefsEditor p = this;
        p.setLayout(new BoxLayout(p, 1));
        JPanel pfont = new JPanel();
        pfont.setBorder(new TitledBorder("font"));
        this.btnFont = new JButton("choose...");
        this.btnFont.setFont(this.mACVD.getFont());
        pfont.add(this.btnFont);
        this.btnFontColor = new ColorButton("color");
        this.btnFontColor.setColor3f(this.mACVD.getFontColor());
        pfont.add(this.btnFontColor);
        JPanel pbgcolor = new JPanel();
        pbgcolor.setBorder(new TitledBorder("background color"));
        this.cbbgcolor = new ColorButton("choose...");
        pbgcolor.add(this.cbbgcolor);
        JPanel prender = new JPanel();
        prender.setBorder(new TitledBorder("render atoms by..."));
        this.atomRender = new JComboBox<String>(J3DDataManager.ATOM_RENDERING_METHODS);
        prender.add(this.atomRender);
        JPanel pfirst = new JPanel();
        pfirst.setLayout(new BoxLayout(pfirst, 0));
        pfirst.add(pfont);
        pfirst.add(pbgcolor);
        pfirst.add(prender);
        p.add(pfirst);
        this.cbbondcolor = new ColorButton("choose...");
        JPanel pbondcolor = new JPanel();
        pbondcolor.setBorder(new TitledBorder("bond color"));
        pbondcolor.add(this.cbbondcolor);
        this.checklightbond = new JCheckBox("");
        JPanel plightbond = new JPanel();
        plightbond.setBorder(new TitledBorder("use wire"));
        plightbond.add(this.checklightbond);
        JPanel pbond = new JPanel();
        JPanel pbondother = new JPanel();
        pbondother.setLayout(new GridLayout(1, 4));
        pbondother.setBorder(new TitledBorder("bond properties"));
        this.bondfactor_ip = new InputPanel("bond factor", 0, 7, true);
        this.bondwidth_ip = new InputPanel("bond width", 0, 7, true);
        pbondother.add(this.bondfactor_ip);
        pbondother.add(this.bondwidth_ip);
        pbondother.add(pbondcolor);
        pbondother.add(plightbond);
        p.add(pbondother);
        JPanel pcellandscale = new JPanel();
        pcellandscale.setLayout(new BoxLayout(pcellandscale, 0));
        JPanel pcellother = new JPanel();
        pcellother.setLayout(new BoxLayout(pcellother, 0));
        pcellother.setBorder(new TitledBorder("cell properties"));
        this.drawcell_cb = new JCheckBox("draw cell");
        this.cell_is_wire = new JCheckBox("use wire");
        this.cellwidth_ip = new InputPanel("cell width", 0, 5, true);
        this.cbcellcolor = new ColorButton("choose...");
        JPanel pcellcolor = new JPanel();
        pcellcolor.setBorder(new TitledBorder("cell color"));
        pcellcolor.add(this.cbcellcolor);
        pcellother.add(this.drawcell_cb);
        pcellother.add(this.cell_is_wire);
        pcellother.add(this.cellwidth_ip);
        pcellother.add(pcellcolor);
        pcellandscale.add(pcellother);
        JPanel pscale = new JPanel();
        pscale.setLayout(new GridLayout(1, 2));
        pscale.setBorder(new TitledBorder("scale"));
        this.scale_ip = new InputPanel("scale (system)", 0, 5, true);
        this.scaleatom_ip = new InputPanel("scale (atoms)", 0, 5, true);
        pscale.add(this.scale_ip);
        pscale.add(this.scaleatom_ip);
        pcellandscale.add(pscale);
        p.add(pcellandscale);
        JPanel pres = new JPanel();
        pres.setLayout(new GridLayout(1, 3));
        pres.setBorder(new TitledBorder("resolution"));
        this.numnodesatom_ip = new InputPanel("resolution (atom)", 0, 7, true);
        this.numnodesbond_ip = new InputPanel("resolution (bond)", 0, 7, true);
        this.numnodescell_ip = new InputPanel("resolution (cell)", 0, 7, true);
        pres.add(this.numnodesatom_ip);
        pres.add(this.numnodesbond_ip);
        pres.add(this.numnodescell_ip);
        p.add(pres);
        JPanel plabel = new JPanel();
        plabel.setLayout(new GridLayout(2, 2));
        plabel.setBorder(new TitledBorder("auxiliary info"));
        this.axis_cb = new JCheckBox("draw axis");
        plabel.add(this.axis_cb);
        this.label_cb = new JCheckBox("draw label");
        JPanel plabel_label = new JPanel();
        plabel_label.setLayout(new BoxLayout(plabel_label, 0));
        plabel_label.add(this.label_cb);
        this.labeloffset_ip = new InputPanel("label offset", 0, 7, true);
        plabel_label.add(this.labeloffset_ip);
        plabel.add(plabel_label);
        this.legend_cb = new JCheckBox("draw legend");
        plabel.add(this.legend_cb);
        this.mobile_cb = new JCheckBox("mobility");
        String[] mobile_choice = new String[]{"darker", "brighter"};
        this.mobile_cp = new ChoicePanel("show mobile atoms", mobile_choice);
        JPanel pmobile = new JPanel();
        pmobile.setLayout(new BoxLayout(pmobile, 0));
        pmobile.add(this.mobile_cb);
        pmobile.add(this.mobile_cp);
        plabel.add(pmobile);
        p.add(plabel);
        this.btnFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsEditor.this.mACVD.setFont(PrefsEditor.this.chooseFont());
                PrefsEditor.this.btnFont.setFont(PrefsEditor.this.mACVD.getFont());
            }
        });
        this.label_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PrefsEditor)PrefsEditor.this).labeloffset_ip.m_value.setEnabled(PrefsEditor.this.label_cb.isSelected());
            }
        });
        this.drawcell_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsEditor.this.cell_is_wire.setEnabled(PrefsEditor.this.drawcell_cb.isSelected());
                ((PrefsEditor)PrefsEditor.this).cellwidth_ip.m_value.setEnabled(PrefsEditor.this.drawcell_cb.isSelected());
                PrefsEditor.this.cbcellcolor.setEnabled(PrefsEditor.this.drawcell_cb.isSelected());
            }
        });
        this.mobile_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PrefsEditor)PrefsEditor.this).mobile_cp.m_choice.setEnabled(PrefsEditor.this.mobile_cb.isSelected());
            }
        });
    }

    private Font chooseFont() {
        JFontChooser fontChooser = new JFontChooser();
        fontChooser.setSelectedFont(this.mACVD.getFont());
        int result = fontChooser.showDialog((Component)this);
        if (result == 0) {
            Font choosedFont = fontChooser.getSelectedFont();
            return choosedFont;
        }
        return this.mACVD.getFont();
    }

    @Override
    protected String getTitle() {
        return "Appearance";
    }

    @Override
    protected void setDataToPanel() {
        this.cbbgcolor.setColorf(this.mACVD.getBgColor()[0], this.mACVD.getBgColor()[1], this.mACVD.getBgColor()[2]);
        this.cbbondcolor.setColorf(this.mACVD.getBondColor()[0], this.mACVD.getBondColor()[1], this.mACVD.getBondColor()[2]);
        this.bondfactor_ip.setValue(Double.toString(this.mACVD.getBondFactor()));
        this.bondwidth_ip.setValue(Double.toString(this.mACVD.getBondWidth()));
        this.checklightbond.setSelected(this.mACVD.getUseWireForBond());
        this.scale_ip.setValue(Float.toString(this.mACVD.getScale()));
        this.scaleatom_ip.setValue(Float.toString(this.mACVD.getScaleAtom()));
        this.numnodesatom_ip.setValue(Integer.toString(this.mACVD.getNumNodesAtom()));
        this.numnodesbond_ip.setValue(Integer.toString(this.mACVD.getNumNodesBond()));
        this.numnodescell_ip.setValue(Integer.toString(this.mACVD.getNumNodesCell()));
        this.drawcell_cb.setSelected(this.mACVD.getDrawCell());
        this.cell_is_wire.setSelected(this.mACVD.getUseWireForCell());
        this.cellwidth_ip.setValue(Float.toString(this.mACVD.getCellWidth()));
        this.cellwidth_ip.m_value.setEnabled(this.drawcell_cb.isSelected());
        this.cbcellcolor.setEnabled(this.drawcell_cb.isSelected());
        this.cbcellcolor.setColorf(this.mACVD.getCellColor()[0], this.mACVD.getCellColor()[1], this.mACVD.getCellColor()[2]);
        this.axis_cb.setSelected(this.mACVD.getAxis());
        this.label_cb.setSelected(this.mACVD.getText());
        this.labeloffset_ip.setValue(Integer.toString(this.mACVD.getLabelOffset()));
        this.labeloffset_ip.m_value.setEnabled(this.label_cb.isSelected());
        this.legend_cb.setSelected(this.mACVD.getLegend());
        this.mobile_cb.setSelected(this.mACVD.getMobile());
        if (this.mACVD.getMobilityDisplayMode() <= 1) {
            this.mobile_cp.m_choice.setSelectedIndex(this.mACVD.getMobilityDisplayMode());
        } else {
            this.mobile_cp.m_choice.setSelectedIndex(0);
        }
        this.mobile_cp.m_choice.setEnabled(this.mobile_cb.isSelected());
        this.atomRender.setSelectedItem(this.mACVD.getAtomRenderingMethod());
    }

    @Override
    protected void setDataToRepository() {
        Color bgcolor = this.cbbgcolor.getColor();
        this.mACVD.setBgColor((float)bgcolor.getRed() / 255.0f, (float)bgcolor.getGreen() / 255.0f, (float)bgcolor.getBlue() / 255.0f);
        Color bondcolor = this.cbbondcolor.getColor();
        this.mACVD.setBondColor((float)bondcolor.getRed() / 255.0f, (float)bondcolor.getGreen() / 255.0f, (float)bondcolor.getBlue() / 255.0f);
        this.mACVD.setBondFactor(Double.parseDouble(this.bondfactor_ip.getValue()));
        this.mACVD.setBondWidth(Double.parseDouble(this.bondwidth_ip.getValue()));
        this.mACVD.setUseWireForBond(this.checklightbond.isSelected());
        this.mACVD.setScale(Float.parseFloat(this.scale_ip.getValue()));
        this.mACVD.setScaleAtom(Float.parseFloat(this.scaleatom_ip.getValue()));
        this.mACVD.setNumNodesAtom(Integer.parseInt(this.numnodesatom_ip.getValue()));
        this.mACVD.setNumNodesBond(Integer.parseInt(this.numnodesbond_ip.getValue()));
        this.mACVD.setNumNodesCell(Integer.parseInt(this.numnodescell_ip.getValue()));
        this.mACVD.setDrawCell(this.drawcell_cb.isSelected());
        this.mACVD.setCellWidth(Float.parseFloat(this.cellwidth_ip.getValue()));
        Color cellcolor = this.cbcellcolor.getColor();
        this.mACVD.setCellColor((float)cellcolor.getRed() / 255.0f, (float)cellcolor.getGreen() / 255.0f, (float)cellcolor.getBlue() / 255.0f);
        this.mACVD.setAxis(this.axis_cb.isSelected());
        this.mACVD.setText(this.label_cb.isSelected());
        this.mACVD.setLabelOffset(Integer.parseInt(this.labeloffset_ip.getValue()));
        this.mACVD.setLegend(this.legend_cb.isSelected());
        this.mACVD.setMobile(this.mobile_cb.isSelected());
        this.mACVD.setMobilityDisplayMode(this.mobile_cp.m_choice.getSelectedIndex());
        this.mACVD.setAtomRenderingMethod(this.atomRender.getSelectedItem().toString());
        this.mACVD.setUseWireForCell(this.cell_is_wire.isSelected());
        this.mACVD.setFontColor(this.btnFontColor.getColor3f());
    }
}

