/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.prefs.prefseditor;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.viewer.prefs.prefseditor.ACVEditors;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class PreferenceEditor
extends InternalFrameChase {
    private static Logger logger = Logger.getLogger((String)PreferenceEditor.class.getName());
    protected CoordsViewerInterface mp;
    protected J3DDataManager mACVD;
    protected ConfigDataManager mCD;
    protected ACVEditors editors;
    private Vector panels = new Vector();

    public PreferenceEditor(MainPanel mp, String title, Dimension size) {
        super(title, size);
        this.mp = mp;
        this.mACVD = mp.getJ3DDataManager();
        this.mCD = mp.getCD();
        mp.addDisposeOnExit(this);
    }

    protected JPanel createButtons() {
        JPanel pclose = new JPanel();
        pclose.setLayout(new BoxLayout(pclose, 0));
        JButton btnredraw = new JButton("redraw");
        JButton btnsave = new JButton("save");
        JButton btnclose = new JButton("close");
        JButton btnsaveclose = new JButton("save & close");
        pclose.add(btnredraw);
        pclose.add(btnsave);
        pclose.add(btnclose);
        pclose.add(btnsaveclose);
        btnredraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceEditor.this.redraw();
            }
        });
        btnsave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceEditor.this.save();
            }
        });
        btnsaveclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceEditor.this.save();
                PreferenceEditor.this.dispose();
            }
        });
        btnclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceEditor.this.dispose();
            }
        });
        return pclose;
    }

    private void redraw() {
        if (this.editors == null) {
            return;
        }
        this.editors.setDataToRepository();
        this.mp.getCD().forceUpdate(true);
        this.mp.getCD().update();
    }

    private void save() {
        if (this.editors == null) {
            return;
        }
        this.editors.setDataToRepository();
        this.mACVD.writeACVData();
    }
}

