/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.prefs.arrow;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

public class ArrowEditPanel
extends JPanel {
    private Logger logger = Logger.getLogger((String)ArrowEditPanel.class.getName());
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private JInternalFrame parent;
    private CoordsViewerInterface parentParent;
    private final String arrow_draw = "arrow_draw";
    private final String arrow_draw_value = "arrow_draw_value";
    private final String arrow_head_radius = "arrow_head_radius";
    private final String arrow_head_height = "arrow_head_height";
    private final String arrow_scale = "arrow_scale";
    private final String arrow_radius = "arrow_radius";
    private final String arrow_color_r = "arrow_color_r";
    private final String arrow_color_g = "arrow_color_g";
    private final String arrow_color_b = "arrow_color_b";
    private JCheckBox drawValueCheckBox;
    public JButton arrowColor;
    public JTextField arrowRadius;
    public JTextField arrowScale;
    public JCheckBox drawCheckBox;
    public JTextField headHeight;
    public JTextField headRadius;
    public JButton jButton2;
    public JButton jButton3;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JPanel jPanel3;
    public JPanel jPanel4;
    public JPanel jPanel5;

    public ArrowEditPanel(JInternalFrame parent, CoordsViewerInterface parentParent) {
        this.parent = parent;
        this.parentParent = parentParent;
        this.initComponents();
        this.setInitValues();
    }

    private Color getForegroundColor(Color color) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float redscale = 0.5f;
        float greenscale = 0.5f;
        float bluescale = 0.5f;
        if (red < 0.5f) {
            redscale = 2.0f;
        }
        if (green < 0.5f) {
            greenscale = 2.0f;
        }
        if (blue < 0.5f) {
            bluescale = 2.0f;
        }
        return new Color(red * redscale, green * greenscale, blue * bluescale);
    }

    private void setInitValues() {
        boolean draw = new Boolean(this.gp.getProperty("arrow_draw"));
        boolean drawval = new Boolean(this.gp.getProperty("arrow_draw_value"));
        String radius = this.gp.getProperty("arrow_head_radius");
        String height = this.gp.getProperty("arrow_head_height");
        String scale = this.gp.getProperty("arrow_scale");
        String radi = this.gp.getProperty("arrow_radius");
        String color_r = this.gp.getProperty("arrow_color_r");
        String color_g = this.gp.getProperty("arrow_color_g");
        String color_b = this.gp.getProperty("arrow_color_b");
        float red = 1.0f;
        float blue = 1.0f;
        float green = 1.0f;
        try {
            red = Float.parseFloat(color_r);
            green = Float.parseFloat(color_g);
            blue = Float.parseFloat(color_b);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Color color = new Color(red, green, blue);
        this.drawCheckBox.setSelected(draw);
        this.drawValueCheckBox.setSelected(drawval);
        this.headRadius.setText(radius);
        this.headHeight.setText(height);
        this.arrowScale.setText(scale);
        this.arrowRadius.setText(radi);
        this.arrowColor.setBackground(color);
        this.arrowColor.setForeground(this.getForegroundColor(color));
    }

    private void initComponents() {
        this.drawCheckBox = new JCheckBox();
        this.drawValueCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.headRadius = new JTextField();
        this.jPanel3 = new JPanel();
        this.headHeight = new JTextField();
        this.arrowColor = new JButton();
        this.jPanel4 = new JPanel();
        this.arrowScale = new JTextField();
        this.jPanel5 = new JPanel();
        this.arrowRadius = new JTextField();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        JPanel pcheckbox = new JPanel();
        pcheckbox.setLayout(new BoxLayout(pcheckbox, 0));
        this.drawCheckBox.setText("draw arrows to represent force");
        this.drawCheckBox.setActionCommand("draw arrows to represent force");
        this.drawCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.drawCheckBox.setMargin(new Insets(0, 0, 0, 0));
        pcheckbox.add(this.drawCheckBox);
        this.drawValueCheckBox.setText("draw value");
        pcheckbox.add(this.drawValueCheckBox);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "appearance", 0, 0, new Font("MS UI Gothic", 0, 12), new Color(0, 51, 153)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("arrowhead radius"));
        this.headRadius.setBorder(null);
        this.headRadius.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ArrowEditPanel.this.headRadiusCaretUpdate(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.headRadius, -1, 92, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.headRadius, -2, 19, -2));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("arrowhead height"));
        this.headHeight.setBorder(null);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.headHeight, -1, 98, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.headHeight, -2, 19, -2));
        this.arrowColor.setForeground(new Color(0, 153, 153));
        this.arrowColor.setText("arrow color");
        this.arrowColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArrowEditPanel.this.arrowColorActionPerformed(evt);
            }
        });
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("scale"));
        this.arrowScale.setBorder(null);
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.arrowScale, -1, 86, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.arrowScale, -2, 19, -2));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("arrow radius"));
        this.arrowRadius.setBorder(null);
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((Component)this.arrowRadius, -1, 86, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.arrowRadius, -2, 19, -2));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(1, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jPanel4, -2, -1, -2).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jPanel5, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(1, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2)).add(1, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(38, 38, 38).add((Component)this.arrowColor))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(1, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0, 18, Short.MAX_VALUE).add((Component)this.arrowColor).addContainerGap()).add(1, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jPanel5, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2).add(32, 32, 32)).add(1, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jPanel3, -2, -1, -2).addContainerGap(82, Short.MAX_VALUE)));
        this.jButton2.setText("apply");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArrowEditPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("close");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArrowEditPanel.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(24, 24, 24).add((Component)pcheckbox).addContainerGap(151, Short.MAX_VALUE)).add((Component)this.jPanel1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(149, 149, 149).add((Component)this.jButton2).addPreferredGap(0).add((Component)this.jButton3).addContainerGap(156, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)pcheckbox).addPreferredGap(0).add((Component)this.jPanel1, -2, 120, -2).addPreferredGap(0, 13, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButton2).add((Component)this.jButton3)).addContainerGap()));
    }

    private void arrowColorActionPerformed(ActionEvent evt) {
        JColorChooser colorchooser = new JColorChooser();
        Color color = JColorChooser.showDialog(this.parent, "Choose", this.arrowColor.getBackground());
        if (color != null) {
            this.arrowColor.setBackground(color);
            this.arrowColor.setForeground(this.getForegroundColor(color));
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        String headrad = this.headRadius.getText();
        String headhei = this.headHeight.getText();
        String scale = this.arrowScale.getText();
        String radi = this.arrowRadius.getText();
        boolean draw = this.drawCheckBox.isSelected();
        boolean drawval = this.drawValueCheckBox.isSelected();
        Color color = this.arrowColor.getBackground();
        try {
            Float.parseFloat(headrad);
            Float.parseFloat(headhei);
            Float.parseFloat(scale);
            Float.parseFloat(radi);
        }
        catch (Exception exc) {
            this.logger.warn((Object)"enter a valid number.");
            return;
        }
        String red = String.valueOf((float)color.getRed() / 255.0f);
        String green = String.valueOf((float)color.getGreen() / 255.0f);
        String blue = String.valueOf((float)color.getBlue() / 255.0f);
        this.gp.setProperty("arrow_draw", String.valueOf(draw));
        this.gp.setProperty("arrow_draw_value", String.valueOf(drawval));
        this.gp.setProperty("arrow_head_radius", headrad);
        this.gp.setProperty("arrow_head_height", headhei);
        this.gp.setProperty("arrow_scale", scale);
        this.gp.setProperty("arrow_radius", radi);
        this.gp.setProperty("arrow_color_r", red);
        this.gp.setProperty("arrow_color_g", green);
        this.gp.setProperty("arrow_color_b", blue);
        this.gp.storeProperty();
        this.parentParent.getCD().update();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.parent.dispose();
    }

    private void headRadiusCaretUpdate(CaretEvent evt) {
    }
}

