/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.prefs;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class UnitCellOperationsPanel
extends JPanel {
    private String defaultEps = "0.00001";
    private CoordsViewerInterface parent;
    private JCheckBox abplane;
    private JCheckBox acplane;
    private JButton apply;
    private JCheckBox bcplane;
    private JButton cancel;
    private JTextField eps;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JCheckBox packatom;
    private JComboBox shiftPolicyCombo;

    public UnitCellOperationsPanel(CoordsViewerInterface parent) {
        this.parent = parent;
        this.initComponents();
        this.setInitialValues();
        this.setVisible(true);
    }

    private void setInitialValues() {
        GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
        boolean ab = new Boolean(gp.getProperty("add_boundary_atoms_ab"));
        boolean ac = new Boolean(gp.getProperty("add_boundary_atoms_ac"));
        boolean bc = new Boolean(gp.getProperty("add_boundary_atoms_bc"));
        boolean pack = new Boolean(gp.getProperty("pack_atoms_into_unit_cell"));
        this.abplane.setSelected(ab);
        this.acplane.setSelected(ac);
        this.bcplane.setSelected(bc);
        this.packatom.setSelected(pack);
        String seps = gp.getProperty("pack_atoms_into_unit_cell_eps");
        if (seps != null) {
            this.eps.setText(seps);
        } else {
            this.eps.setText(this.defaultEps);
        }
        this.eps.setEnabled(this.packatom.isSelected());
        String sshift = gp.getProperty("atom_shift_policy");
        int shift = 0;
        if (sshift != null && sshift.length() != 0) {
            try {
                shift = Integer.parseInt(sshift);
            }
            catch (Exception ex) {
                shift = 0;
            }
            if (shift > 1) {
                shift = 0;
            }
        }
        this.shiftPolicyCombo.setSelectedIndex(shift);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.abplane = new JCheckBox();
        this.acplane = new JCheckBox();
        this.bcplane = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.apply = new JButton();
        this.cancel = new JButton();
        this.jPanel3 = new JPanel();
        this.packatom = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.eps = new JTextField();
        this.jLabel1 = new JLabel();
        this.jPanel5 = new JPanel();
        this.shiftPolicyCombo = new JComboBox();
        this.setLayout(new AbsoluteLayout());
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "add boundary atoms", 0, 0, new Font("MS UI Gothic", 0, 12), new Color(0, 51, 153)));
        this.jPanel1.setForeground(new Color(0, 51, 153));
        this.abplane.setText("a-b plane");
        this.abplane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnitCellOperationsPanel.this.abplaneActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.abplane, new AbsoluteConstraints(20, 20, 80, -1));
        this.acplane.setText("a-c plane");
        this.acplane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnitCellOperationsPanel.this.acplaneActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.acplane, new AbsoluteConstraints(20, 40, -1, -1));
        this.bcplane.setText("b-c plane");
        this.bcplane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnitCellOperationsPanel.this.bcplaneActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.bcplane, new AbsoluteConstraints(20, 60, -1, -1));
        this.add((Component)this.jPanel1, new AbsoluteConstraints(10, 30, 170, 100));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 0));
        this.apply.setText("apply");
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnitCellOperationsPanel.this.applyActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.apply);
        this.cancel.setText("cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnitCellOperationsPanel.this.cancelActionPerformed(evt);
            }
        });
        this.add((Component)this.jPanel2, new AbsoluteConstraints(130, 220, 170, 40));
        this.jPanel3.setLayout(new AbsoluteLayout());
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "pack atoms", 0, 0, new Font("MS UI Gothic", 0, 12), new Color(0, 51, 153)));
        this.packatom.setText("pack atoms into unit cell");
        this.packatom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnitCellOperationsPanel.this.packatomActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.packatom, new AbsoluteConstraints(10, 20, -1, -1));
        this.jPanel4.setLayout(new AbsoluteLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("eps"));
        this.eps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnitCellOperationsPanel.this.epsActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.eps, new AbsoluteConstraints(20, 20, 120, 20));
        this.jPanel3.add((Component)this.jPanel4, new AbsoluteConstraints(10, 40, 160, 50));
        this.add((Component)this.jPanel3, new AbsoluteConstraints(180, 30, 190, 100));
        this.jLabel1.setText("*note: some changes will take effect only after reboot of the viewer");
        this.add((Component)this.jLabel1, new AbsoluteConstraints(20, 10, -1, -1));
        this.shiftPolicyCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"shift atoms to edge of cell", "shift atoms to center of cell"}));
        this.revalidate();
    }

    private void packatomActionPerformed(ActionEvent evt) {
        this.eps.setEnabled(this.packatom.isSelected());
    }

    private void epsActionPerformed(ActionEvent evt) {
    }

    private void cancelActionPerformed(ActionEvent evt) {
    }

    private void applyActionPerformed(ActionEvent evt) {
        GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
        gp.setProperty("add_boundary_atoms_ab", String.valueOf(this.abplane.isSelected()));
        gp.setProperty("add_boundary_atoms_ac", String.valueOf(this.acplane.isSelected()));
        gp.setProperty("add_boundary_atoms_bc", String.valueOf(this.bcplane.isSelected()));
        gp.setProperty("pack_atoms_into_unit_cell", String.valueOf(this.packatom.isSelected()));
        String seps = this.eps.getText();
        if (seps != null) {
            try {
                Double.parseDouble(seps);
                gp.setProperty("pack_atoms_into_unit_cell_eps", seps);
            }
            catch (NumberFormatException nfe) {
                gp.setProperty("pack_atoms_into_unit_cell_eps", this.defaultEps);
            }
        } else {
            gp.setProperty("pack_atoms_into_unit_cell_eps", this.defaultEps);
        }
        gp.setProperty("atom_shift_policy", new Integer(this.shiftPolicyCombo.getSelectedIndex()).toString());
        gp.storeProperty();
        this.parent.doUnitCell(true);
    }

    private void bcplaneActionPerformed(ActionEvent evt) {
    }

    private void acplaneActionPerformed(ActionEvent evt) {
    }

    private void abplaneActionPerformed(ActionEvent evt) {
    }
}

