/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.measure;

import ciss.phase_viewer.acviewer.measure.Measurable;
import ciss.phase_viewer.acviewer.measure.Measure;
import ciss.phase_viewer.acviewer.scenegraphelements.MeasureObject;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementCreator;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.VectorOperations;
import javax.media.j3d.BranchGroup;
import org.apache.log4j.Logger;

public class DihedralMeasure
extends Measure {
    private static Logger logger = Logger.getLogger((String)DihedralMeasure.class.getName());
    private final int numAt = 4;

    public DihedralMeasure(Measurable measurable) {
        super(measurable);
    }

    @Override
    public int getNumberOfNecessaryAtoms() {
        return 4;
    }

    private BranchGroup getElem() {
        SceneGraphElementCreator creator = this.measurable.getCreator();
        return creator.getSceneGraphElement(this.xyz[0], this.xyz[1], this.xyz[2], this.xyz[3], this.result, this.id);
    }

    @Override
    public void draw() {
        if (!this.validData) {
            return;
        }
        MeasureObject elem = (MeasureObject)this.getElem();
        elem.setAtomVector(this.atomVectorNow);
        this.bg.addMeasureObject(elem);
    }

    @Override
    public void calculate() {
        double theta;
        double[] r21 = new double[3];
        double[] r23 = new double[3];
        double[] r32 = new double[3];
        double[] r34 = new double[3];
        int i = 0;
        while (i < 3) {
            r21[i] = this.pos_moto[1][i] - this.pos_moto[0][i];
            r23[i] = this.pos_moto[1][i] - this.pos_moto[2][i];
            r32[i] = this.pos_moto[2][i] - this.pos_moto[1][i];
            r34[i] = this.pos_moto[2][i] - this.pos_moto[3][i];
            ++i;
        }
        double[] n1 = VectorOperations.getNormalVector(r21, r23);
        double[] n2 = VectorOperations.getNormalVector(r32, r34);
        double costheta = 0.0;
        int i2 = 0;
        while (i2 < 3) {
            costheta += n1[i2] * n2[i2];
            ++i2;
        }
        this.result = theta = Math.toDegrees(Math.acos(costheta));
        if (!this.updating) {
            logger.info((Object)("dihedral angle calculated from atoms " + this.id[3] + ", " + this.id[2] + ", " + this.id[1] + " and  " + this.id[0] + " : " + ConstParameters.formater.format(theta) + "\u00b0"));
        }
    }

    @Override
    public void redraw(int measureIndex, boolean valid) {
        if (!this.validData) {
            return;
        }
        MeasureObject mobj = (MeasureObject)this.bg.getChild(measureIndex);
        if (!valid) {
            mobj.detach();
            return;
        }
        mobj.setAtoms(new double[][]{this.xyz[0], this.xyz[1], this.xyz[2], this.xyz[3]});
        mobj.setResult(this.result);
        mobj.recreate();
    }

    @Override
    protected void initUpdate() {
        this.updating = true;
    }

    @Override
    protected void finalizeUpdate() {
        this.updating = false;
    }

    public String toString() {
        return "dihedral angle";
    }
}

