/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.frame;

import ciss.phase_viewer.acviewer.Animater;
import ciss.phase_viewer.common.ChooserButton;
import ciss.phase_viewer.common.SimpleHeavyGUI;
import ciss.phase_viewer.movie.MovieViewer;
import ciss.phase_viewer.plugins.viewer.frame.MovieMaker;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

class MovieMakerPanel
extends SimpleHeavyGUI {
    private static Logger logger = Logger.getLogger((String)MovieMakerPanel.class.getName());
    private Animater animater;
    private MovieMaker movieMaker;
    private JCheckBox cbjpegs;
    private JCheckBox cbmov;
    private String baseDir = System.getProperty("user.home");
    private JTextField basetext;
    private JTextField prefix;
    private JTextField filename;
    private JTextField filenamevrml;
    private JTextField framerate;
    private JComboBox combotype;
    private JPanel jpegPanel;
    private JPanel vrmlPanel;
    private JPanel optPanel;

    protected MovieMakerPanel(MovieMaker movieMaker) {
        super("movie maker", "create movie", "close", new Dimension(500, 330));
        this.addViewerButton();
        this.movieMaker = movieMaker;
        this.animater = movieMaker.getAssociatedAnimater();
        this.basetext.setText(this.baseDir);
    }

    protected MovieMakerPanel(MovieMaker movieMaker, String baseDir) {
        super("movie maker", "create movie", "close", new Dimension(500, 330));
        this.addViewerButton();
        this.movieMaker = movieMaker;
        this.animater = movieMaker.getAssociatedAnimater();
        this.baseDir = baseDir;
        this.basetext.setText(this.baseDir);
    }

    private void addViewerButton() {
        JButton view = new JButton("view created movie");
        super.addButtons(view, 1);
        view.requestFocus();
        view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieMakerPanel.this.bootMovieViewer();
            }
        });
        this.basetext.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                MovieMakerPanel.this.animater.setBaseDir(MovieMakerPanel.this.basetext.getText());
                MovieMakerPanel.this.movieMaker.setBaseDir(MovieMakerPanel.this.basetext.getText());
            }
        });
        this.filename.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                MovieMakerPanel.this.movieMaker.setMovieFileName(MovieMakerPanel.this.filename.getText());
            }
        });
    }

    private void bootMovieViewer() {
        logger.info((Object)"booting movie viewer ...");
        String mf = this.movieMaker.getMovieFileName();
        if (mf == null || !new File(mf).exists()) {
            logger.warn((Object)("couldn't find file: " + mf));
            return;
        }
        MovieViewer viewer = new MovieViewer("file:" + mf);
        viewer.setVisible(true);
    }

    @Override
    public JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel basedirpanel = new JPanel();
        basedirpanel.setBorder(new TitledBorder("base directory"));
        this.basetext = new JTextField(System.getProperty("user.home"), 30);
        ChooserButton choose = new ChooserButton(0, this.basetext);
        basedirpanel.add(this.basetext);
        basedirpanel.add(choose);
        this.combotype = new JComboBox<String>(new String[]{"jpeg", "VRML"});
        JPanel typepanel = new JPanel();
        typepanel.setBorder(new TitledBorder("select movie file type"));
        typepanel.add(this.combotype);
        panel.add(basedirpanel);
        panel.add(typepanel);
        this.optPanel = new JPanel();
        panel.add(this.optPanel);
        JPanel prefixpanel = new JPanel();
        prefixpanel.setLayout(new BoxLayout(prefixpanel, 0));
        prefixpanel.setBorder(new TitledBorder("prefix for numbered jpeg files"));
        this.prefix = new JTextField("frame", 20);
        prefixpanel.add(this.prefix);
        JPanel pmov = new JPanel();
        pmov.setLayout(new GridLayout(1, 2));
        pmov.setBorder(new TitledBorder("QuickTime movie"));
        JPanel cbpanel = new JPanel();
        cbpanel.setLayout(new BoxLayout(cbpanel, 1));
        this.cbmov = new JCheckBox("create QuickTime movie");
        this.cbmov.setSelected(true);
        JPanel pfiles = new JPanel();
        pfiles.setLayout(new BoxLayout(pfiles, 0));
        this.cbjpegs = new JCheckBox("delete jpeg files");
        cbpanel.add(this.cbmov);
        cbpanel.add(this.cbjpegs);
        JPanel textpanel = new JPanel();
        textpanel.setLayout(new BoxLayout(textpanel, 1));
        JPanel frameratepanel = new JPanel();
        frameratepanel.setLayout(new BoxLayout(frameratepanel, 0));
        frameratepanel.setBorder(new TitledBorder("frame rate (frames/sec)"));
        this.framerate = new JTextField("10", 20);
        frameratepanel.add(this.framerate);
        JPanel filenamepanel = new JPanel();
        filenamepanel.setLayout(new BoxLayout(filenamepanel, 0));
        filenamepanel.setBorder(new TitledBorder("file name (.mov extention)"));
        this.filename = new JTextField("frame.mov", 20);
        filenamepanel.add(this.filename);
        JPanel filenamepanelvrml = new JPanel();
        filenamepanelvrml.setLayout(new BoxLayout(filenamepanelvrml, 0));
        filenamepanelvrml.setBorder(new TitledBorder("file name (.wrl extention)"));
        this.filenamevrml = new JTextField("frame.wrl", 20);
        filenamepanelvrml.add(this.filenamevrml);
        textpanel.add(frameratepanel);
        textpanel.add(filenamepanel);
        pmov.add(cbpanel);
        pmov.add(textpanel);
        this.jpegPanel = new JPanel();
        this.jpegPanel.setLayout(new BoxLayout(this.jpegPanel, 1));
        this.jpegPanel.add(prefixpanel);
        this.jpegPanel.add(pmov);
        this.vrmlPanel = new JPanel();
        this.vrmlPanel.setLayout(new BoxLayout(this.vrmlPanel, 1));
        this.vrmlPanel.add(filenamepanelvrml);
        this.vrmlPanel.add(frameratepanel);
        this.cbjpegs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MovieMakerPanel)MovieMakerPanel.this).movieMaker.jpegs = MovieMakerPanel.this.cbjpegs.isSelected();
            }
        });
        this.cbmov.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bmov;
                ((MovieMakerPanel)MovieMakerPanel.this).movieMaker.movs = bmov = MovieMakerPanel.this.cbmov.isSelected();
                MovieMakerPanel.this.cbjpegs.setEnabled(bmov);
                MovieMakerPanel.this.framerate.setEnabled(bmov);
                MovieMakerPanel.this.filename.setEnabled(bmov);
            }
        });
        this.combotype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MovieMakerPanel.this.combotype.getSelectedIndex() == 0) {
                    MovieMakerPanel.this.optPanel.removeAll();
                    MovieMakerPanel.this.optPanel.add(MovieMakerPanel.this.jpegPanel);
                    if (MovieMakerPanel.this.movieMaker != null) {
                        MovieMakerPanel.this.movieMaker.setAnimMode(2);
                    }
                } else if (MovieMakerPanel.this.combotype.getSelectedIndex() == 1) {
                    MovieMakerPanel.this.optPanel.removeAll();
                    MovieMakerPanel.this.optPanel.add(MovieMakerPanel.this.vrmlPanel);
                    if (MovieMakerPanel.this.movieMaker != null) {
                        MovieMakerPanel.this.movieMaker.setAnimMode(3);
                    }
                }
                MovieMakerPanel.this.optPanel.revalidate();
                MovieMakerPanel.this.repaint();
            }
        });
        this.combotype.setSelectedIndex(0);
        return panel;
    }

    private String getMovieFileName() {
        String filenameString = "";
        if (this.combotype.getSelectedIndex() == 0) {
            filenameString = this.filename.getText().trim();
            if (!filenameString.endsWith(".mov") && !filenameString.endsWith(".MOV")) {
                filenameString = String.valueOf(filenameString) + ".mov";
            }
        } else if (this.combotype.getSelectedIndex() == 1 && !(filenameString = this.filenamevrml.getText().trim()).toLowerCase().endsWith(".wrl")) {
            filenameString = String.valueOf(filenameString) + ".wrl";
        }
        return filenameString;
    }

    @Override
    protected boolean action() {
        String dir;
        File dirdir;
        if (this.cbmov.isSelected() || this.combotype.getSelectedIndex() == 1) {
            int fr = 10;
            try {
                fr = Integer.parseInt(this.framerate.getText());
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)"set integer value for frame rate ... using the default value");
                fr = 10;
            }
            this.movieMaker.setFrameRate(fr);
            this.movieMaker.setImagePrefix(this.prefix.getText());
            String filenameString = this.getMovieFileName();
            this.movieMaker.setMovieFileName(filenameString);
        }
        if ((dirdir = new File(dir = this.basetext.getText())).mkdirs()) {
            logger.info((Object)("created directory: " + dir));
        }
        if (!dirdir.exists()) {
            logger.error((Object)("directory " + dir + " does not exsist."));
            return false;
        }
        this.movieMaker.setBaseDir(dir);
        this.movieMaker.createMovie();
        return true;
    }
}

