/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.edit;

import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.viewer.edit.AtomicConfiguration;
import ciss.phase_viewer.plugins.viewer.edit.GuidePlane;
import ciss.phase_viewer.primitiveguis.ValueSlider;
import ciss.phase_viewer.primitiveguis.ValueSliderListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.vecmath.Point3f;
import org.apache.log4j.Logger;

class SurfacePanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)SurfacePanel.class.getName());
    private MainPanel parent;
    private JTextField tfh;
    private JTextField tfk;
    private JTextField tfl;
    private JTextField tfsx;
    private JTextField tfsy;
    private JTextField tfsz;
    private JTextField tfvac;
    private ValueSlider vslider;
    private JCheckBox cbperp;
    private float[][] bounds;
    private GuidePlane guidePlane;
    private double lenmax;
    private double[] jusin;

    public SurfacePanel(MainPanel panel) {
        super("generate surface", new Dimension(420, 420));
        this.parent = panel;
        this.parent.addDisposeOnExit(this);
        if (this.parent.getCD() == null) {
            this.dispose();
            JOptionPane.showInternalMessageDialog(Desk.getDesktop().getSelectedFrame(), "Atomic coordinates not allocated");
            this.logger.error((Object)"Atomic coordinates not allocated");
            return;
        }
        this.init();
    }

    @Override
    public void dispose() {
        if (this.guidePlane != null) {
            this.guidePlane.removeGuidePlane();
        }
        super.dispose();
    }

    private void init() {
        JPanel millerp = new JPanel();
        millerp.setBorder(new TitledBorder("miller index"));
        millerp.setLayout(new BoxLayout(millerp, 0));
        this.tfh = new JTextField(8);
        this.tfh.setHorizontalAlignment(0);
        this.tfk = new JTextField(8);
        this.tfk.setHorizontalAlignment(0);
        this.tfl = new JTextField(8);
        this.tfl.setHorizontalAlignment(0);
        this.tfh.setText("0");
        this.tfk.setText("0");
        this.tfl.setText("1");
        JPanel ph = new JPanel();
        ph.setBorder(new TitledBorder("h"));
        ph.add(this.tfh);
        JPanel pk = new JPanel();
        pk.setBorder(new TitledBorder("k"));
        pk.add(this.tfk);
        JPanel pl = new JPanel();
        pl.setBorder(new TitledBorder("l"));
        pl.add(this.tfl);
        millerp.add(ph);
        millerp.add(pk);
        millerp.add(pl);
        JPanel supp = new JPanel();
        supp.setBorder(new TitledBorder("super cell"));
        supp.setLayout(new BoxLayout(supp, 0));
        this.tfsx = new JTextField(8);
        this.tfsx.setHorizontalAlignment(0);
        this.tfsy = new JTextField(8);
        this.tfsy.setHorizontalAlignment(0);
        this.tfsz = new JTextField(8);
        this.tfsz.setHorizontalAlignment(0);
        this.tfsx.setText("1");
        this.tfsy.setText("1");
        this.tfsz.setText("1");
        JPanel psx = new JPanel();
        psx.setBorder(new TitledBorder("a"));
        psx.add(this.tfsx);
        JPanel psy = new JPanel();
        psy.setBorder(new TitledBorder("b"));
        psy.add(this.tfsy);
        JPanel psz = new JPanel();
        psz.setBorder(new TitledBorder("c"));
        psz.add(this.tfsz);
        supp.add(psx);
        supp.add(psy);
        supp.add(psz);
        AtomicConfiguration conf = this.getCurrAtomicConfiguration();
        double[] lconst = conf.getLatConst();
        float max = 0.0f;
        int i = 0;
        while (i < 3) {
            if ((double)max < lconst[i]) {
                max = (float)lconst[i];
            }
            ++i;
        }
        this.vslider = new ValueSlider((float)(-Math.ceil(2.0f * max)), (float)Math.ceil(2.0f * max));
        this.vslider.setTitleForBorder("shift");
        this.tfvac = new JTextField(8);
        this.tfvac.setHorizontalAlignment(0);
        this.tfvac.setText("0.0");
        JPanel pvac = new JPanel();
        pvac.setBorder(new TitledBorder("vacuum"));
        pvac.add(this.tfvac);
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 0));
        pp.add(this.vslider);
        this.cbperp = new JCheckBox("set c-axis perpendicular to the ab plane");
        this.cbperp.setSelected(true);
        JPanel pperp = new JPanel();
        pperp.add(this.cbperp);
        pperp.add(pvac);
        JButton apply = new JButton("apply");
        JButton close = new JButton("close");
        JPanel pbtm = new JPanel();
        pbtm.setLayout(new BoxLayout(pbtm, 0));
        pbtm.add(apply);
        pbtm.add(close);
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SurfacePanel.this.generateSurface();
                SurfacePanel.this.guidePlane.removeGuidePlane();
            }
        });
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SurfacePanel.this.dispose();
            }
        });
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BoxLayout(jpanel, 1));
        jpanel.add(millerp);
        jpanel.add(supp);
        jpanel.add(pp);
        jpanel.add(pperp);
        jpanel.add(pbtm);
        this.getContentPane().add(jpanel);
        this.initGuidePlane();
        this.tfh.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SurfacePanel.this.updateGuidePlane();
            }
        });
        this.tfk.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SurfacePanel.this.updateGuidePlane();
            }
        });
        this.tfl.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SurfacePanel.this.updateGuidePlane();
            }
        });
        this.vslider.addValueSliderListener(new ValueSliderListener(){

            @Override
            public void valueSliderValueChanged() {
                SurfacePanel.this.updateGuidePlane();
            }
        });
        this.updateGuidePlane();
    }

    private void initGuidePlane() {
        this.bounds = ((ChaseTransformGroup)this.parent.getRootTransform()).getEffectiveBounds();
        float sizex = (float)Math.sqrt(Math.pow(this.bounds[0][0], 2.0) + Math.pow(this.bounds[1][0], 2.0) + Math.pow(this.bounds[2][0], 2.0));
        float sizey = (float)Math.sqrt(Math.pow(this.bounds[0][1], 2.0) + Math.pow(this.bounds[1][1], 2.0) + Math.pow(this.bounds[2][1], 2.0));
        float sizez = (float)Math.sqrt(Math.pow(this.bounds[0][2], 2.0) + Math.pow(this.bounds[1][2], 2.0) + Math.pow(this.bounds[2][2], 2.0));
        this.logger.debug((Object)("effective bounds: " + sizex + ", " + sizey));
        if (this.guidePlane == null) {
            this.guidePlane = new GuidePlane(this.parent.getRootTransform(), sizex, sizey);
            this.guidePlane.zoffset = sizez * 0.5f;
        }
    }

    private void updateGuidePlane() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int[] minds = SurfacePanel.this.getMillerIndex();
                if (minds != null) {
                    Point3f p3f = AtomicConfiguration.getNormalVector(SurfacePanel.this.getCurrAtomicConfiguration(), minds);
                    if (p3f != null) {
                        SurfacePanel.this.guidePlane.setNormalVector(p3f);
                    }
                    SurfacePanel.this.guidePlane.updateGuidePlane();
                    SurfacePanel.this.setCOMAndLenMax();
                    Point3f pos = SurfacePanel.this.getPos();
                    if (pos != null) {
                        SurfacePanel.this.guidePlane.setOrigin(pos);
                    }
                    SurfacePanel.this.guidePlane.updateGuidePlane();
                }
            }
        });
    }

    private int[] getMillerIndex() {
        int[] ret = new int[3];
        try {
            ret[0] = Integer.parseInt(this.tfh.getText());
            ret[1] = Integer.parseInt(this.tfk.getText());
            ret[2] = Integer.parseInt(this.tfl.getText());
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)("invalid miller index : (" + this.tfh.getText() + " " + this.tfk.getText() + " " + this.tfl.getText() + ")"));
            return null;
        }
        this.logger.debug((Object)("miller index : (" + this.tfh.getText() + " " + this.tfk.getText() + " " + this.tfl.getText() + ")"));
        return ret;
    }

    private void generateSurface() {
        int h = 0;
        int k = 0;
        int l = 0;
        int sx = 0;
        int sy = 0;
        int sz = 0;
        double vac = 0.0;
        double shift = 0.0;
        boolean perp = this.cbperp.isSelected();
        try {
            h = Integer.parseInt(this.tfh.getText());
            k = Integer.parseInt(this.tfk.getText());
            l = Integer.parseInt(this.tfl.getText());
            sx = Integer.parseInt(this.tfsx.getText());
            sy = Integer.parseInt(this.tfsy.getText());
            sz = Integer.parseInt(this.tfsz.getText());
            vac = Double.parseDouble(this.tfvac.getText());
            shift = this.vslider.getValue();
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            this.logger.error((Object)"miller index, supercell size, or the vacuum layer is invalid");
            return;
        }
        AtomCoords coor = this.parent.getCD().getAtomCoords();
        coor.saveState();
        boolean wasFract = coor.isInternal();
        int nat = coor.getAtomList().getNumAt();
        AtomicConfiguration conf = this.getCurrAtomicConfiguration();
        double sizez = Math.sqrt(Math.pow(this.bounds[0][2], 2.0) + Math.pow(this.bounds[1][2], 2.0) + Math.pow(this.bounds[2][2], 2.0));
        conf.generateSurface(h, k, l, sx, sy, sz, vac, -shift, 0.0, perp);
        Atom atmt = coor.getAtomList().getAtomAt(0);
        double[][] latvec = conf.getLatVec();
        coor.setCell(new Cell(latvec[0], latvec[1], latvec[2]));
        coor.convertCell(1);
        int i = 0;
        while (i < conf.getNumAt()) {
            Atom atm = atmt.getCopy();
            atm.setElementName(conf.getElementName()[i]);
            atm.setPos(conf.getCartPos()[i]);
            if (i < nat) {
                coor.getAtomList().replaceAtomAt(i, atm);
            } else {
                coor.getAtomList().addAtom(atm);
            }
            ++i;
        }
        int undo = conf.getNumAt() + 1;
        if (wasFract) {
            coor.convert(7, 8);
            undo += conf.getNumAt();
        }
        coor.getAtomList().setUndoCount(undo);
        this.parent.getCD().setCoords(coor);
        coor.finalizeState();
    }

    private AtomicConfiguration getCurrAtomicConfiguration() {
        AtomCoords coor = this.parent.getCD().getAtomCoords();
        return AtomicConfiguration.getAtomicConfiguration(coor);
    }

    private void setCOMAndLenMax() {
        this.setCOMAndLenMax(true);
    }

    private void setCOMAndLenMax(boolean check) {
        this.lenmax = 1.0;
        if (this.jusin == null) {
            this.jusin = new double[3];
            int i = 0;
            while (i < 3) {
                this.jusin[i] = 0.0;
                ++i;
            }
        }
        TGAtom tgatom = (TGAtom)this.parent.getRootTransform();
        double[] jusin_buff = tgatom.getCOM();
        this.lenmax = tgatom.getLenMax();
        this.logger.debug((Object)("jusin1 " + jusin_buff[0] + " " + jusin_buff[1] + " " + jusin_buff[2]));
        jusin_buff = tgatom.getJusin();
        this.logger.debug((Object)("jusin2 " + jusin_buff[0] + " " + jusin_buff[1] + " " + jusin_buff[2]));
        boolean comChanged = false;
        int i = 0;
        while (i < 3) {
            if (jusin_buff[i] != this.jusin[i]) {
                comChanged = true;
            }
            ++i;
        }
        if (!check) {
            this.jusin = jusin_buff;
            return;
        }
        this.logger.debug((Object)("jusin : " + this.jusin[0] + ", " + this.jusin[1] + ", " + this.jusin[2]));
        this.logger.debug((Object)("jusin_buff : " + jusin_buff[0] + ", " + jusin_buff[1] + ", " + jusin_buff[2]));
        if (comChanged) {
            double[] diff = new double[3];
            int i2 = 0;
            while (i2 < 3) {
                diff[i2] = this.jusin[i2] - jusin_buff[i2];
                this.jusin[i2] = jusin_buff[i2];
                ++i2;
            }
            if (this.guidePlane != null) {
                Point3f orig = this.guidePlane.getOrigin();
                orig.x += (float)(diff[0] / this.lenmax);
                orig.y += (float)(diff[1] / this.lenmax);
                orig.z += (float)(diff[2] / this.lenmax);
            }
        }
        this.logger.debug((Object)("lenmax: " + this.lenmax));
        this.logger.debug((Object)("jusin: " + this.jusin[0] + " " + this.jusin[1] + " " + this.jusin[2]));
    }

    private Point3f getPos() {
        Point3f center = new Point3f(0.0f, 0.0f, 0.0f);
        int[] mill = this.getMillerIndex();
        if (mill == null) {
            return null;
        }
        Point3f norm = AtomicConfiguration.getNormalVector(this.getCurrAtomicConfiguration(), mill);
        float dx = this.vslider.getValue();
        this.logger.debug((Object)("jusin " + this.jusin[0] + " " + this.jusin[1] + " " + this.jusin[2]));
        double[] ajusin = this.getCurrAtomicConfiguration().getCartJusin(mill);
        center.x = (dx * norm.x - (float)this.jusin[0] + (float)ajusin[0]) / (float)this.lenmax;
        center.y = (dx * norm.y - (float)this.jusin[1] + (float)ajusin[1]) / (float)this.lenmax;
        center.z = (dx * norm.z - (float)this.jusin[2] + (float)ajusin[2]) / (float)this.lenmax;
        this.logger.debug((Object)("center : " + String.valueOf(center)));
        return center;
    }
}

