/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.edit;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.plugins.viewer.edit.FileSelector;
import ciss.phase_viewer.plugins.viewer.edit.Interface;
import ciss.phase_viewer.plugins.viewer.edit.InterfaceBuilder;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

class InterfaceInitializer
extends InternalFrameChase
implements ACVCaller {
    private MainPanel parent;
    private Logger logger = Logger.getLogger((String)InterfaceInitializer.class.getName());
    private FileSelector pscif1;
    private FileSelector pscif2;
    private FileSelector pspvm;
    private JPanel pps;
    private JRadioButton jrcif;
    private JRadioButton jrpvm;
    private JButton btnok;
    private JComboBox<String> comboAB;
    private JComboBox<String> comboCoord1;

    InterfaceInitializer(MainPanel parent) {
        super("initialize interface", new Dimension(420, 380));
        this.parent = parent;
        this.parent.addDisposeOnExit(this);
        this.init();
    }

    private void init() {
        ButtonGroup bg = new ButtonGroup();
        this.jrcif = new JRadioButton("CIF");
        this.jrpvm = new JRadioButton("PHASE-Viewer model file");
        bg.add(this.jrcif);
        bg.add(this.jrpvm);
        JPanel pbg = new JPanel();
        pbg.setBorder(new TitledBorder("select File type"));
        pbg.add(this.jrcif);
        pbg.add(this.jrpvm);
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 1));
        this.pps = new JPanel();
        this.pscif1 = new FileSelector("CIF for crystal1");
        this.pscif2 = new FileSelector("CIF for crystal2");
        this.pspvm = new FileSelector("PHASE-Viewer model file", false);
        pp.add(pbg);
        pp.add(this.pps);
        this.comboAB = new JComboBox<String>(new String[]{"average", "crystal1", "crystal2"});
        this.comboCoord1 = new JComboBox<String>(new String[]{"internal", "cartesian"});
        JPanel pab = new JPanel();
        pab.setBorder(new TitledBorder("a-axis & b-axis"));
        JPanel pc1 = new JPanel();
        pc1.setBorder(new TitledBorder("coordinates"));
        pab.add(this.comboAB);
        pc1.add(this.comboCoord1);
        JPanel popts = new JPanel();
        popts.setBorder(new TitledBorder("options"));
        popts.setLayout(new BoxLayout(popts, 0));
        popts.add(pab);
        popts.add(pc1);
        pp.add(popts);
        JPanel pbtn = new JPanel();
        this.btnok = new JButton("ok");
        this.btnok.setEnabled(false);
        JButton btncan = new JButton("cancel");
        pbtn.setLayout(new BoxLayout(pbtn, 0));
        pbtn.add(this.btnok);
        pbtn.add(btncan);
        pp.add(pbtn);
        this.getContentPane().add(pp);
        this.pscif1.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                InterfaceInitializer.this.okBtn();
            }
        });
        this.pscif2.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                InterfaceInitializer.this.okBtn();
            }
        });
        this.pspvm.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                InterfaceInitializer.this.okBtn();
            }
        });
        this.jrcif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceInitializer.this.swapUI();
                InterfaceInitializer.this.okBtn();
            }
        });
        this.jrpvm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceInitializer.this.swapUI();
                InterfaceInitializer.this.okBtn();
            }
        });
        this.btnok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceInitializer.this.genInterface();
            }
        });
        btncan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceInitializer.this.dispose();
            }
        });
        this.jrcif.setSelected(true);
        this.pps.add(this.pscif1);
        this.pps.add(this.pscif2);
        this.revalidate();
    }

    private void okBtn() {
        if (this.jrcif.isSelected()) {
            boolean b1 = this.pscif1.pathExists();
            boolean b2 = this.pscif2.pathExists();
            this.btnok.setEnabled(b1 && b2);
        } else {
            boolean b1 = this.pspvm.pathExists();
            this.btnok.setEnabled(b1);
        }
    }

    private void genInterface() {
        File f1;
        this.dispose();
        Interface inter = null;
        if (this.jrcif.isSelected()) {
            this.logger.info((Object)"building interface model from two CIF");
            f1 = new File(this.pscif1.getPath());
            File f2 = new File(this.pscif2.getPath());
            Interface.INITIAL_AB initialAB = Interface.INITIAL_AB.AVERAGE;
            if (this.comboAB.getSelectedIndex() == 1) {
                initialAB = Interface.INITIAL_AB.CRYSTAL1;
            }
            if (this.comboAB.getSelectedIndex() == 2) {
                initialAB = Interface.INITIAL_AB.CRYSTAL2;
            }
            Interface.INITIAL_COORD initialCoord = Interface.INITIAL_COORD.FRACTIONAL;
            if (this.comboCoord1.getSelectedIndex() == 1) {
                initialCoord = Interface.INITIAL_COORD.CARTESIAN;
            }
            try {
                inter = new Interface(f1, f2, initialAB, initialCoord);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.logger.info((Object)"building interface model from the PVM file");
            f1 = new File(this.pspvm.getPath());
            try {
                inter = new Interface(f1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (inter != null) {
            try {
                AtomCoords coords = inter.getAtomCoordsObj();
                Vector<AtomCoords> vec = new Vector<AtomCoords>();
                vec.addElement(coords);
                DataManager dm = new DataManager("foo", PhaseConstants.TABLESPEC, false);
                dm.parse();
                ACVData data = new ACVData((ACVCaller)this, vec, "", dm.getInputInterface(), StringConstants.phase_atom_tag);
                this.parent.setData(data);
                this.parent.display3D();
                this.parent.setSelected(true);
                new InterfaceBuilder(this.parent, inter);
            }
            catch (Exception e) {
                this.dispose();
                e.printStackTrace();
                this.logger.error((Object)"failed to initialize interface model");
                return;
            }
        } else {
            JOptionPane.showInternalMessageDialog(Desk.getDesktop().getSelectedFrame(), "failed to create initial interface structure");
            this.logger.error((Object)"failed to create initial interface structure");
        }
    }

    private void swapUI() {
        if (this.jrcif.isSelected()) {
            this.pps.remove(this.pspvm);
            this.pps.revalidate();
            this.pps.add(this.pscif1);
            this.pps.add(this.pscif2);
        }
        if (this.jrpvm.isSelected()) {
            this.pps.remove(this.pscif1);
            this.pps.remove(this.pscif2);
            this.pps.revalidate();
            this.pps.add(this.pspvm);
        }
        this.comboAB.setEnabled(this.jrcif.isSelected());
        this.comboCoord1.setEnabled(this.jrcif.isSelected());
        this.repaint();
    }

    @Override
    public void save(AtomCoords coords) {
    }
}

