/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.edit;

import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.CIFExporter;
import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceUnits;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.plugins.viewer.edit.Interface;
import ciss.phase_viewer.primitiveguis.ValueSlider;
import ciss.phase_viewer.primitiveguis.ValueSliderListener;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

class InterfaceBuilder
extends InternalFrameChase
implements ConfigData {
    private Logger logger = Logger.getLogger((String)InterfaceBuilder.class.getName());
    private MainPanel parent;
    private Interface inter;
    private JTextField[][] tflatvec;
    private JCheckBox cbnonperiodic;
    private JCheckBox cbnonperiodic_trans0;
    private JCheckBox cbnonperiodic_trans1;
    private ValueSlider vstransa1;
    private ValueSlider vstransb1;
    private ValueSlider vstransc1;
    private ValueSlider vsnonpc1;
    private ValueSlider vstransa2;
    private ValueSlider vstransb2;
    private ValueSlider vstransc2;
    private ValueSlider vsnonpc2;
    private ValueSlider vstransa0;
    private ValueSlider vstransb0;
    private ValueSlider vstransc0;
    private JToggleButton btninv1;
    private JToggleButton btninv2;
    private DecimalFormat df = new DecimalFormat("0.########");
    private int tfsizex = 20;
    private int tfsizey = 10;
    private JPanel pTransPanel1;
    private JPanel pTransPanel2;

    InterfaceBuilder(MainPanel parent, Interface inter) {
        super("interface builder", new Dimension(800, 640));
        this.parent = parent;
        this.parent.addDisposeOnExit(this);
        this.inter = inter;
        this.parent.getCD().register(this);
        this.init();
    }

    private void init() {
        try {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(this.latticePanel());
            p.add(this.periodicTranslationPanel(1));
            p.add(this.periodicTranslationPanel(0));
            p.add(this.periodicTranslationPanel(-1));
            p.add(this.invertPanel());
            p.add(this.btnPanel());
            this.getContentPane().add(p);
            this.updateInterfaceUI();
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JPanel latticePanel() {
        JPanel ret = new JPanel();
        ret.setBorder(new TitledBorder("lattice vector"));
        ret.setLayout(new BoxLayout(ret, 1));
        this.cbnonperiodic = new JCheckBox("c-axis non-periodic");
        ret.add(this.cbnonperiodic);
        JPanel lat = new JPanel();
        lat.setLayout(new GridLayout(3, 4));
        double[][] latvec = this.inter.getLatVec();
        this.tflatvec = new JTextField[3][3];
        String[] vecname = new String[]{"a-axis", "b-axis", "c-axis"};
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceBuilder.this.updateConfiguration();
            }
        };
        int i = 0;
        while (i < 3) {
            int ii = 2 - i;
            lat.add(new JLabel(vecname[ii]), ii, 0);
            int j = 0;
            while (j < 3) {
                this.tflatvec[ii][j] = new JTextField(10);
                this.tflatvec[ii][j].setPreferredSize(new Dimension(this.tfsizex, this.tfsizey));
                this.tflatvec[ii][j].setText(this.df.format(latvec[ii][j]));
                this.tflatvec[ii][j].addActionListener(al);
                lat.add(this.tflatvec[ii][j], ii, j + 1);
                ++j;
            }
            ++i;
        }
        ret.add(lat);
        return ret;
    }

    private void setPeriodicTranslationPanel(int cid) {
        JPanel p = null;
        ValueSlider va = null;
        ValueSlider vb = null;
        ValueSlider vc = null;
        if (cid == 0) {
            p = this.pTransPanel1;
            va = this.vstransa1;
            vb = this.vstransb1;
            vc = this.vstransc1;
            if (this.cbnonperiodic_trans0.isSelected()) {
                vc = this.vsnonpc1;
            }
        } else if (cid == 1) {
            p = this.pTransPanel2;
            va = this.vstransa2;
            vb = this.vstransb2;
            vc = this.vstransc2;
            if (this.cbnonperiodic_trans1.isSelected()) {
                vc = this.vsnonpc2;
            }
        }
        p.removeAll();
        p.setLayout(new GridLayout(1, 3));
        p.add(va);
        p.add(vb);
        p.add(vc);
        p.revalidate();
        p.repaint();
    }

    private JPanel periodicTranslationPanel(final int cid) {
        JPanel ret = new JPanel();
        if (cid == 0) {
            this.pTransPanel1 = ret;
        } else if (cid == 1) {
            this.pTransPanel2 = ret;
        }
        double[] latconst = this.inter.getLatConst();
        ValueSlider vsa = new ValueSlider(0.0f, (float)latconst[0]);
        vsa.setTitleForBorder("a-axis");
        vsa.setValue(0.0f);
        ValueSlider vsb = new ValueSlider(0.0f, (float)latconst[1]);
        vsb.setTitleForBorder("b-axis");
        vsb.setValue(0.0f);
        float z = (float)this.inter.getCrystal1().getLatConst()[2];
        if (cid == 1) {
            z = (float)this.inter.getCrystal2().getLatConst()[2];
        }
        if (cid == -1) {
            z = (float)this.inter.getLatConst()[2];
        }
        ValueSlider vsc = new ValueSlider(0.0f, z);
        vsc.setTitleForBorder("c-axis");
        vsc.setValue(0.0f);
        float zz = (float)this.inter.getLatConst()[2];
        ValueSlider vscc = new ValueSlider(0.0f, zz);
        vscc.setTitleForBorder("c-axis");
        vscc.setValue(0.0f);
        ret.setLayout(new GridLayout(1, 3));
        ret.add(vsa);
        ret.add(vsb);
        ret.add(vsc);
        ValueSliderListener vsl = new ValueSliderListener(){

            @Override
            public void valueSliderValueChanged() {
                InterfaceBuilder.this.updateConfiguration();
            }
        };
        vsa.addValueSliderListener(vsl);
        vsb.addValueSliderListener(vsl);
        vsc.addValueSliderListener(vsl);
        vscc.addValueSliderListener(vsl);
        if (cid == 0) {
            this.vstransa1 = vsa;
            this.vstransb1 = vsb;
            this.vstransc1 = vsc;
            this.vsnonpc1 = vscc;
        }
        if (cid == 1) {
            this.vstransa2 = vsa;
            this.vstransb2 = vsb;
            this.vstransc2 = vsc;
            this.vsnonpc2 = vscc;
        }
        if (cid == -1) {
            this.vstransa0 = vsa;
            this.vstransb0 = vsb;
            this.vstransc0 = vsc;
        }
        JCheckBox cb = null;
        if (cid >= 0) {
            this.cbnonperiodic_trans0 = cb = new JCheckBox("c-axis non-periodic");
            if (cid == 1) {
                this.cbnonperiodic_trans1 = cb;
            }
        }
        JPanel rret = new JPanel();
        if (cid == 0) {
            rret.setBorder(new TitledBorder("periodic translation for crystal 1"));
        } else if (cid == 1) {
            rret.setBorder(new TitledBorder("periodic translation for crystal 2"));
        } else if (cid == -1) {
            rret.setBorder(new TitledBorder("periodic translation for the whole system"));
        }
        rret.setLayout(new BoxLayout(rret, 1));
        if (cid >= 0) {
            rret.add(cb);
        }
        rret.add(ret);
        if (cid >= 0) {
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceBuilder.this.setPeriodicTranslationPanel(cid);
                }
            });
        }
        return rret;
    }

    private JPanel invertPanel() {
        JPanel ret = new JPanel();
        ret.setBorder(new TitledBorder("invert"));
        ret.setLayout(new GridLayout(1, 2));
        this.btninv1 = new JToggleButton("crystal 1");
        this.btninv2 = new JToggleButton("crystal 2");
        ret.add(this.btninv1);
        ret.add(this.btninv2);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceBuilder.this.updateConfiguration();
            }
        };
        this.btninv1.addActionListener(al);
        this.btninv2.addActionListener(al);
        return ret;
    }

    private JPanel btnPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 0));
        JButton expor = new JButton("export");
        JButton cls = new JButton("close");
        expor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceBuilder.this.doExport();
            }
        });
        cls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceBuilder.this.dispose();
            }
        });
        ret.add(expor);
        ret.add(cls);
        return ret;
    }

    private void doExport() {
        FileFilter[] filters;
        ChaseFileChooser cfc = new ChaseFileChooser("atom", true);
        cfc.setFileSelectionMode(0);
        FileFilter ciff = new FileFilter(){

            @Override
            public String getDescription() {
                return "CIF";
            }

            @Override
            public boolean accept(File f) {
                return true;
            }
        };
        FileFilter finp = new FileFilter(){

            @Override
            public String getDescription() {
                return "F_INP";
            }

            @Override
            public boolean accept(File f) {
                return true;
            }
        };
        FileFilter[] fileFilterArray = filters = cfc.getChoosableFileFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter filter = fileFilterArray[n2];
            cfc.removeChoosableFileFilter(filter);
            ++n2;
        }
        cfc.addChoosableFileFilter(ciff);
        cfc.addChoosableFileFilter(finp);
        if (cfc.showDialog(this, "Select") != 0) {
            JOptionPane.showInternalMessageDialog(Desk.getDesktop().getSelectedFrame(), "export canceled");
            this.logger.info((Object)"operation canceled");
            return;
        }
        AtomCoords coor = this.inter.getAtomCoordsObj(true);
        if (cfc.getFileFilter() == ciff) {
            this.cifExport(coor, cfc.getSelectedFile());
        } else if (cfc.getFileFilter() == finp) {
            this.F_INPExport(coor, cfc.getSelectedFile());
        }
        this.PVMExport(cfc.getSelectedFile());
    }

    private void cifExport(AtomCoords coor, File file) {
        CIFExporter ce = new CIFExporter();
        ce.writeAtomCoordsTo(new AtomCoords[]{coor}, file.getAbsolutePath());
        this.logger.info((Object)("output interface coordinates to " + file.getAbsolutePath()));
    }

    private void F_INPExport(AtomCoords coor, File file) {
        try {
            coor.convert(7, 9);
            DataManager manager = new DataManager(file.getAbsolutePath(), PhaseConstants.TABLESPEC, false);
            manager.parse();
            InputInterface inp = manager.getInputInterface();
            InputInterfaceUnits uni = inp.getInputInterfaceUnits("structure.atom_list.atoms.units");
            uni.setUnits(new String[]{"bohr"});
            uni = inp.getInputInterfaceUnits("structure.unit_cell.units");
            uni.setUnits(new String[]{"bohr"});
            InputInterfacePrimitiveEntry coorsys = inp.getInputInterfacePrimitiveEntry("structure.atom_list.coordinate_system");
            coorsys.setValue("");
            coor.atomCoords2InputInterface(inp, StringConstants.phase_atom_tag);
            coor.cell2InputInterface(inp);
            manager.getInputInterface().saveTo(file);
            this.logger.info((Object)("output interface coordinates to " + file.getAbsolutePath()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void PVMExport(File file) {
        Document doc = new Document();
        Element theRoot = new Element("PhaseViewerModel");
        doc.setRootElement(theRoot);
        Element crystal1 = this.inter.getCrystal1().getElement();
        Element crystal2 = this.inter.getCrystal2().getElement();
        Element interelem = this.inter.getElement();
        theRoot.addContent((Content)crystal1);
        theRoot.addContent((Content)crystal2);
        theRoot.addContent((Content)interelem);
        String fname = file.getName();
        String pvmFile = "";
        String[] aa = fname.split("\\.");
        if (aa.length == 1) {
            pvmFile = aa + ".pvm";
        }
        int i = 0;
        while (i < aa.length - 1) {
            pvmFile = String.valueOf(pvmFile) + aa[i] + ".";
            ++i;
        }
        pvmFile = String.valueOf(pvmFile.substring(0, pvmFile.length() - 1)) + ".pvm";
        File f = new File(String.valueOf(file.getParent()) + System.getProperty("file.separator") + pvmFile);
        this.saveXML(doc, f);
        this.logger.info((Object)("output aux interface info to    " + f.getAbsolutePath()));
    }

    public boolean saveXML(Document doc, File file) {
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                xmlOutput.output(doc.getDocument(), (Writer)osw);
            }
            catch (IOException e1) {
                this.logger.error((Object)("failed to write information to " + file));
                try {
                    fos.close();
                    osw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                fos.close();
                osw.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private void updateConfiguration() {
        double[][] latvec = this.inter.getLatVec();
        boolean latchanged = false;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                try {
                    double val = Double.parseDouble(this.tflatvec[i][j].getText().trim());
                    if (Math.abs(latvec[i][j] - val) > 1.0E-5) {
                        latvec[i][j] = val;
                        latchanged = true;
                    }
                }
                catch (NumberFormatException val) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        if (latchanged) {
            this.inter.setLatticeVector(latvec);
            this.inter.updateLatticeConstant();
            this.inter.updateCart(0);
            this.inter.updateCart(1);
            if (this.cbnonperiodic.isSelected()) {
                this.inter.updateFract();
            } else {
                this.inter.updateCart(2);
            }
        }
        double vala = this.vstransa1.getValue();
        double valb = this.vstransb1.getValue();
        double valc = this.vstransc1.getValue();
        if (this.cbnonperiodic_trans0.isSelected()) {
            valc = this.vsnonpc1.getValue();
        }
        boolean trans = this.inter.doPeriodicTranslation(0, vala, valb, valc, this.cbnonperiodic_trans0.isSelected());
        vala = this.vstransa2.getValue();
        valb = this.vstransb2.getValue();
        valc = this.vstransc2.getValue();
        if (this.cbnonperiodic_trans1.isSelected()) {
            valc = this.vsnonpc2.getValue();
        }
        trans = this.inter.doPeriodicTranslation(1, vala, valb, valc, this.cbnonperiodic_trans1.isSelected()) || trans;
        vala = this.vstransa0.getValue();
        valb = this.vstransb0.getValue();
        valc = this.vstransc0.getValue();
        trans = this.inter.doPeriodicTranslationInterface(vala, valb, valc) || trans;
        boolean inver = this.inter.invert(0, this.btninv1.isSelected());
        boolean bl = inver = this.inter.invert(1, this.btninv2.isSelected()) || inver;
        if (trans || latchanged || inver) {
            AtomCoords coor = this.parent.getCD().getAtomCoords();
            coor.saveState();
            boolean wasFract = coor.isInternal();
            int nat = coor.getAtomList().getNumAt();
            Atom atmt = coor.getAtomList().getAtomAt(0);
            coor.setCell(new Cell(latvec[0], latvec[1], latvec[2]));
            coor.convertCell(1);
            int i2 = 0;
            while (i2 < this.inter.getNumAt()) {
                Atom atm = atmt.getCopy();
                atm.setElementName(this.inter.getElementName()[i2]);
                atm.setPos(this.inter.getCartPos()[i2]);
                if (i2 < nat) {
                    coor.getAtomList().replaceAtomAt(i2, atm);
                } else {
                    coor.getAtomList().addAtom(atm);
                }
                ++i2;
            }
            int undo = this.inter.getNumAt() + 1;
            if (wasFract) {
                coor.convert(7, 8);
                undo += this.inter.getNumAt();
            }
            coor.getAtomList().setUndoCount(undo);
            this.parent.getCD().setCoords(coor);
            coor.finalizeState();
        }
    }

    @Override
    public void configDataUpdate() {
    }

    @Override
    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        AtomCoords coor = this.parent.getCD().getAtomCoords();
        this.inter.mergeAtomCoords(coor);
        this.updateInterfaceUI();
    }

    private void updateInterfaceUI() {
        double[][] latv = this.inter.getLatVec();
        boolean b1 = this.inter.isInverted(0);
        boolean b2 = this.inter.isInverted(1);
        double[] off0 = this.inter.getOffset(-1);
        double[] off1 = this.inter.getOffset(0);
        double[] off2 = this.inter.getOffset(1);
        double[] noff1 = this.inter.getNonPeriodicOffset(0);
        double[] noff2 = this.inter.getNonPeriodicOffset(1);
        double[] lconst = this.inter.getLatConst();
        double a = lconst[0];
        double b = lconst[1];
        double c = lconst[2];
        double cc1 = this.inter.getCrystal1().getLatConst()[2];
        double cc2 = this.inter.getCrystal2().getLatConst()[2];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.tflatvec[i][j].setText(String.valueOf(latv[i][j]));
                ++j;
            }
            ++i;
        }
        this.setSelectedQuietly(this.btninv1, b1);
        this.setSelectedQuietly(this.btninv2, b2);
        this.setMinMaxValQuietly(this.vsnonpc1, 0.0f, (float)c, (float)noff1[2]);
        this.setMinMaxValQuietly(this.vsnonpc2, 0.0f, (float)c, (float)noff2[2]);
        this.setMinMaxValQuietly(this.vstransa1, 0.0f, (float)a, (float)off1[0]);
        this.setMinMaxValQuietly(this.vstransb1, 0.0f, (float)b, (float)off1[1]);
        this.setMinMaxValQuietly(this.vstransc1, 0.0f, (float)cc1, (float)off1[2]);
        this.setMinMaxValQuietly(this.vstransa2, 0.0f, (float)a, (float)off2[0]);
        this.setMinMaxValQuietly(this.vstransb2, 0.0f, (float)b, (float)off2[1]);
        this.setMinMaxValQuietly(this.vstransc2, 0.0f, (float)cc2, (float)off2[2]);
        this.setMinMaxValQuietly(this.vstransa0, 0.0f, (float)a, (float)off0[0]);
        this.setMinMaxValQuietly(this.vstransb0, 0.0f, (float)b, (float)off0[1]);
        this.setMinMaxValQuietly(this.vstransc0, 0.0f, (float)c, (float)off0[2]);
    }

    private void setSelectedQuietly(JToggleButton btn, boolean val) {
        ActionListener l;
        ActionListener[] ls;
        ActionListener[] actionListenerArray = ls = btn.getActionListeners();
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            l = actionListenerArray[n2];
            btn.removeActionListener(l);
            ++n2;
        }
        btn.setSelected(val);
        actionListenerArray = ls;
        n = ls.length;
        n2 = 0;
        while (n2 < n) {
            l = actionListenerArray[n2];
            btn.addActionListener(l);
            ++n2;
        }
    }

    private void setMinMaxValQuietly(ValueSlider vs, float min, float max, float val) {
        ValueSliderListener listener;
        int n;
        int n2;
        ValueSliderListener[] valueSliderListenerArray;
        float[] minmax = vs.getMinMax();
        ValueSliderListener[] listeners = vs.getValueSliderListener();
        if (listeners != null) {
            valueSliderListenerArray = listeners;
            n2 = listeners.length;
            n = 0;
            while (n < n2) {
                listener = valueSliderListenerArray[n];
                vs.removeValueSliderListener(listener);
                ++n;
            }
        }
        if ((double)Math.abs(minmax[0] - min) > 1.0E-5 || (double)Math.abs(minmax[1] - max) > 1.0E-5) {
            vs.setMinMax(min, max);
        }
        vs.setValue(val);
        if (listeners != null) {
            valueSliderListenerArray = listeners;
            n2 = listeners.length;
            n = 0;
            while (n < n2) {
                listener = valueSliderListenerArray[n];
                vs.addValueSliderListener(listener);
                ++n;
            }
        }
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }
}

