/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.edit;

import ciss.phase_viewer.acviewer.geom.Plane;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

class GuidePlane
extends Plane {
    private TransformGroup transformGroup;
    private TransformGroup tg;
    private BranchGroup guidePlane;
    private float trans = 0.7f;
    private TransparencyAttributes tattr;
    private boolean visible = false;
    private Logger logger = Logger.getLogger((String)GuidePlane.class.getName());
    private Point3f axis1 = new Point3f(1.0f, 0.0f, 0.0f);
    private Point3f axis2 = new Point3f(0.0f, 1.0f, 0.0f);
    private Point3f[] initpoints = new Point3f[]{new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, -1.0f, 0.0f), new Point3f(-1.0f, -1.0f, 0.0f), new Point3f(-1.0f, 1.0f, 0.0f)};
    private Color3f color = new Color3f(0.9f, 0.9f, 0.9f);
    private float sizex;
    private float sizey;
    private Point3f jusin = new Point3f();
    float zoffset = 0.0f;

    GuidePlane(TransformGroup transformGroup) {
        this.transformGroup = transformGroup;
        this.guidePlane = new BranchGroup();
        this.guidePlane.setCapability(17);
        this.init();
    }

    GuidePlane(TransformGroup transformGroup, float sizex, float sizey) {
        float xx0 = -0.5f * sizex;
        float yy0 = -0.5f * sizey;
        float xx1 = 1.5f * sizex;
        float yy1 = 1.5f * sizey;
        this.initpoints = new Point3f[]{new Point3f(xx1, yy1, 0.0f), new Point3f(xx1, yy0, 0.0f), new Point3f(xx0, yy0, 0.0f), new Point3f(xx0, yy1, 0.0f)};
        this.transformGroup = transformGroup;
        this.sizex = sizex;
        this.sizey = sizey;
        this.guidePlane = new BranchGroup();
        this.guidePlane.setCapability(17);
        this.init();
    }

    void setJusin(Point3f jusin) {
        this.jusin = jusin;
    }

    private void init() {
        int i = 0;
        while (i < this.initpoints.length) {
            this.logger.debug((Object)("initpoints: " + this.initpoints[i]));
            ++i;
        }
        QuadArray qarray = new QuadArray(this.initpoints.length, 5);
        qarray.setCoordinates(0, this.initpoints);
        qarray.setColors(0, new Color3f[]{this.color, this.color, this.color, this.color});
        Shape3D s3d = new Shape3D();
        try {
            qarray.setCapability(18);
        }
        catch (RestrictedAccessException restrictedAccessException) {
            // empty catch block
        }
        s3d.setGeometry((Geometry)qarray);
        Appearance app = new Appearance();
        this.tattr = new TransparencyAttributes();
        this.tattr.setCapability(3);
        this.tattr.setTransparency(this.trans);
        this.tattr.setTransparencyMode(2);
        app.setTransparencyAttributes(this.tattr);
        PolygonAttributes pattr = new PolygonAttributes();
        pattr.setCullFace(0);
        pattr.setPolygonMode(2);
        pattr.setBackFaceNormalFlip(true);
        app.setPolygonAttributes(pattr);
        s3d.setAppearance(app);
        this.tg = new TransformGroup();
        this.tg.setCapability(18);
        this.tg.setCapability(17);
        this.tg.addChild((Node)s3d);
        Transform3D t3d = new Transform3D();
        t3d.setTranslation(new Vector3d(0.5 * (double)this.sizex, 0.5 * (double)this.sizey, 0.0));
        this.tg.setTransform(t3d);
        this.guidePlane.addChild((Node)this.tg);
    }

    void setTransparency(float tran) {
        this.tattr.setTransparency(tran);
    }

    void resetTransparency() {
        this.tattr.setTransparency(this.trans);
    }

    @Override
    public Point3f getNormalVector() {
        Transform3D currtrans = new Transform3D();
        this.tg.getTransform(currtrans);
        Vector3f vnormal = new Vector3f(0.0f, 0.0f, 1.0f);
        currtrans.transform(vnormal);
        this.normal = new Point3f((Tuple3f)vnormal);
        return this.normal;
    }

    void updateGuidePlane() {
        if (!this.visible) {
            this.transformGroup.addChild((Node)this.guidePlane);
            this.visible = true;
        }
        this.logger.debug((Object)("axis1 & 2 before transformation: " + this.axis1 + " " + this.axis2));
        Vector3f unit = new Vector3f((Tuple3f)this.normal);
        Vector3f uX = new Vector3f();
        Vector3f uY = new Vector3f();
        Vector3f uZ = new Vector3f();
        Transform3D rotateFix = new Transform3D();
        uZ = new Vector3f(unit);
        uX.cross(new Vector3f(0.0f, 1.0f, 0.0f), unit);
        float magX = uX.length();
        Transform3D rotateMatrix = null;
        if (magX != 0.0f) {
            uX.z /= magX;
            uX.x /= magX;
            uX.y /= magX;
            uY.cross(uZ, uX);
            rotateMatrix = new Transform3D(new Matrix4d((double)uX.x, (double)uX.y, (double)uX.z, 0.0, (double)uY.x, (double)uY.y, (double)uY.z, 0.0, (double)uZ.x, (double)uZ.y, (double)uZ.z, 0.0, 0.0, 0.0, 0.0, 1.0));
            try {
                rotateMatrix.invert();
            }
            catch (Exception exc) {
                this.logger.error((Object)("invalid rotation matrix : " + String.valueOf(rotateMatrix)));
                exc.printStackTrace();
            }
        } else {
            rotateMatrix = new Transform3D();
            rotateMatrix.rotX(1.5707963267948966);
        }
        rotateMatrix.transform(this.axis1);
        rotateMatrix.transform(this.axis2);
        Point3f off = new Point3f(this.origin.x, this.origin.y, this.origin.z);
        rotateMatrix.setTranslation(new Vector3f((Tuple3f)off));
        this.tg.setTransform(rotateMatrix);
        this.logger.debug((Object)("axis1 & 2 after transformation: " + this.axis1 + " " + this.axis2));
    }

    Point3f getAxis1() {
        return this.axis1;
    }

    Point3f getAxis2() {
        return this.axis2;
    }

    TransformGroup getTransform() {
        return this.tg;
    }

    void setTransform(Transform3D t3d) {
        this.tg.setTransform(t3d);
    }

    void setTransformRot(Transform3D t3d) {
        if (!this.visible) {
            this.transformGroup.addChild((Node)this.guidePlane);
            this.visible = true;
        }
        Transform3D currtrans = new Transform3D();
        this.tg.getTransform(currtrans);
        Matrix4d mat = new Matrix4d();
        currtrans.get(mat);
        currtrans.setTranslation(new Vector3d(0.0, 0.0, 0.0));
        currtrans.mul(currtrans, t3d);
        Point3f point = new Point3f(this.jusin);
        point.add((Tuple3f)this.origin);
        currtrans.setTranslation(new Vector3d((Tuple3f)point));
        this.tg.setTransform(currtrans);
        currtrans.transform(this.normal);
    }

    void removeGuidePlane() {
        this.guidePlane.detach();
        this.visible = false;
    }

    boolean isVisible() {
        return this.visible;
    }
}

