/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.edit;

import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.CellObject;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class CrystalSystemEditor
extends JPanel
implements ConfigData {
    private Logger logger = Logger.getLogger((String)CrystalSystemEditor.class.getName());
    private JToggleButton drawPrimitiveButton;
    private JToggleButton drawSubLatAtomButton;
    private MainPanel parent;
    private BravaisLattice bravaisLattice;
    private String[] latticeSystemChoice;
    private JComboBox latticeSystemCombo;
    private JButton stripButton;
    private JCheckBox cbsave;
    private JButton toggleUCtype;
    private boolean unitCellTypeIsBravais = true;
    private JComboBox comboUnitCellType;
    private String[] unitCellTypes = new String[]{"primitive", "Bravais"};
    private JLabel labelCrytalSystem;
    private boolean updating = false;

    public CrystalSystemEditor(MainPanel parent) {
        this.parent = parent;
        this.bravaisLattice = parent.getData().getBravaisLattice();
        this.parent.getCD().register(this);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel pcell = new JPanel();
        pcell.setLayout(new BoxLayout(pcell, 0));
        JPanel punitcombo = new JPanel();
        punitcombo.setBorder(new TitledBorder("unitcell type"));
        this.comboUnitCellType = new JComboBox<String>(this.unitCellTypes);
        punitcombo.add(this.comboUnitCellType);
        JPanel pprim = new JPanel();
        pprim.setBorder(new TitledBorder("primitive cell"));
        this.drawPrimitiveButton = new JToggleButton("draw");
        pprim.add(this.drawPrimitiveButton);
        pcell.add(punitcombo);
        pcell.add(pprim);
        p.add(pcell);
        JPanel pcryst = new JPanel();
        pcryst.setLayout(new GridLayout(1, 2));
        JPanel plabel = new JPanel();
        plabel.setBorder(new TitledBorder("crystal system"));
        this.labelCrytalSystem = new JLabel();
        plabel.add(this.labelCrytalSystem);
        this.latticeSystemCombo = new JComboBox();
        JPanel psystem = new JPanel();
        psystem.setBorder(new TitledBorder("lattice system"));
        psystem.add(this.latticeSystemCombo);
        pcryst.add(plabel);
        pcryst.add(psystem);
        p.add(pcryst);
        JPanel psub = new JPanel();
        psub.setLayout(new BoxLayout(psub, 0));
        psub.setBorder(new TitledBorder("sublattice atoms"));
        this.stripButton = new JButton("strip");
        JPanel pstrip = new JPanel();
        pstrip.add(this.stripButton);
        psub.add(pstrip);
        JPanel psublat = new JPanel();
        psublat.setLayout(new BoxLayout(psublat, 0));
        this.cbsave = new JCheckBox("save");
        this.cbsave.setEnabled(false);
        this.drawSubLatAtomButton = new JToggleButton("draw");
        psublat.add(this.drawSubLatAtomButton);
        psublat.add(this.cbsave);
        psub.add(psublat);
        p.add(psub);
        this.toggleUCtype = new JButton("toggle unit cell type");
        JPanel ptoggle = new JPanel();
        ptoggle.add(this.toggleUCtype);
        if (this.bravaisLattice != null) {
            String strcryst = this.bravaisLattice.getCrystalSystem();
            this.labelCrytalSystem.setText(strcryst);
            this.latticeSystemChoice = this.bravaisLattice.getLatticeSystemCandidate();
            this.bravaisLattice.estimateLatticeSystem(parent.getCD().getAtomCoords());
            if (this.bravaisLattice.isBravais()) {
                this.comboUnitCellType.setSelectedIndex(1);
            } else {
                this.comboUnitCellType.setSelectedIndex(0);
            }
            int i = 0;
            while (i < this.latticeSystemChoice.length) {
                this.latticeSystemCombo.addItem(this.latticeSystemChoice[i]);
                ++i;
            }
            this.latticeSystemCombo.setSelectedItem(this.bravaisLattice.getLatticeSystem());
            this.drawPrimitiveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CrystalSystemEditor.this.bravaisLattice != null) {
                        CrystalSystemEditor.this.drawPrimitive(CrystalSystemEditor.this.drawPrimitiveButton.isSelected());
                    }
                }
            });
            this.drawSubLatAtomButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CrystalSystemEditor.this.drawSubLatAtomButton.isSelected()) {
                        CrystalSystemEditor.this.addSubLatticeAtoms();
                        CrystalSystemEditor.this.cbsave.setEnabled(true);
                    } else {
                        CrystalSystemEditor.this.cbsave.setSelected(false);
                        CrystalSystemEditor.this.removeSubLatticeAtoms();
                        CrystalSystemEditor.this.cbsave.setEnabled(false);
                    }
                }
            });
            this.latticeSystemCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CrystalSystemEditor.this.bravaisLattice.setLatticeSystem(CrystalSystemEditor.this.latticeSystemCombo.getSelectedItem().toString());
                }
            });
            this.stripButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CrystalSystemEditor.this.doSubLatticeAtomStrip();
                    CrystalSystemEditor.this.latticeSystemCombo.setSelectedItem(CrystalSystemEditor.this.bravaisLattice.getLatticeSystem());
                }
            });
            this.cbsave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CrystalSystemEditor.this.setSaveSublatAtoms(CrystalSystemEditor.this.cbsave.isSelected());
                }
            });
            this.comboUnitCellType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean boo = CrystalSystemEditor.this.comboUnitCellType.getSelectedIndex() == 0;
                    CrystalSystemEditor.this.toggleUnitCellType(boo);
                }
            });
            this.bravaisLattice.setLatticeSystem(this.latticeSystemCombo.getSelectedItem().toString());
        }
        this.add(p);
        this.updateGUI();
        this.revalidate();
        this.setVisible(true);
    }

    private void toggleUnitCellType(boolean toprimitive) {
        if (this.bravaisLattice == null) {
            return;
        }
        this.updating = true;
        if (toprimitive) {
            double[][] primvec = this.bravaisLattice.getPrimitiveLatticeVector();
            Cell cel = new Cell(primvec[0], primvec[1], primvec[2]);
            AtomCoords coords = this.parent.getCD().getAtomCoords();
            coords.saveState();
            coords.removeBoundaryAtoms();
            this.bravaisLattice.stripSubLatticeAtoms(coords);
            coords.removeSubLatticeAtoms();
            coords.setCell(cel);
            int updateType = ConfigDataUpdateEvent.GENERIC;
            VolumetricData[] vdata = this.parent.getAssociatedVolumetricData();
            if (vdata != null && vdata.length != 0) {
                updateType = ConfigDataUpdateEvent.CELL_CHANGED;
                int i = 0;
                while (i < vdata.length) {
                    vdata[i].restore();
                    ++i;
                }
            }
            this.parent.getCD().setCoords(coords, updateType);
            coords.finalizeState();
            this.parent.postRedraw();
            this.parent.getCD().isRenderingManual(false);
            this.parent.doUnitCell(true);
            this.bravaisLattice.isBravais(false);
        } else {
            AtomCoords coords = this.parent.getCD().getAtomCoords();
            Cell cell = coords.getCell(0);
            double[][] dce = cell.getDouble();
            if (this.bravaisLattice != null) {
                coords.saveState();
                coords.removeBoundaryAtoms();
                this.logger.debug((Object)("bravais lattice : " + this.bravaisLattice));
                double[][] cellvec = this.bravaisLattice.getGenericPrimitiveVector();
                this.logger.debug((Object)("cellvec0 " + cellvec[0][0] + " " + cellvec[0][1] + " " + cellvec[0][2]));
                this.logger.debug((Object)("cellvec1 " + cellvec[1][0] + " " + cellvec[1][1] + " " + cellvec[1][2]));
                this.logger.debug((Object)("cellvec2 " + cellvec[2][0] + " " + cellvec[2][1] + " " + cellvec[2][2]));
                Cell newcell = new Cell(cellvec[0], cellvec[1], cellvec[2]);
                coords.setCell(newcell);
                VolumetricData[] vdata = this.parent.getAssociatedVolumetricData();
                int updateType = ConfigDataUpdateEvent.GENERIC;
                if (vdata != null && vdata.length != 0) {
                    int i = 0;
                    while (i < vdata.length) {
                        vdata[i].save();
                        this.bravaisLattice.bravaisVolumetricData2Primitive(vdata[i]);
                        ++i;
                    }
                    updateType = ConfigDataUpdateEvent.CELL_CHANGED;
                }
                this.bravaisLattice.isBravais(true);
                this.parent.getCD().isRenderingManual(true);
                this.parent.prepareRedraw();
                this.parent.doUnitCell(false);
                this.parent.getCD().setCoords(coords, updateType);
                this.parent.postRedraw();
                this.parent.getCD().isRenderingManual(false);
                coords.finalizeState();
            }
        }
        this.updateGUI();
        this.updating = false;
    }

    private void updateGUI() {
        if (this.bravaisLattice == null) {
            return;
        }
        boolean enable = this.comboUnitCellType.getSelectedIndex() == 1;
        this.drawPrimitiveButton.setEnabled(enable);
        this.drawPrimitive(enable && this.drawPrimitiveButton.isSelected());
        this.stripButton.setEnabled(enable);
        this.latticeSystemCombo.setEnabled(enable);
        this.drawSubLatAtomButton.setEnabled(enable);
        if (this.drawSubLatAtomButton.isSelected() && enable) {
            this.addSubLatticeAtoms();
        }
        this.cbsave.setEnabled(this.drawSubLatAtomButton.isSelected() && enable);
        this.bravaisLattice.isBravais(enable);
        this.revalidate();
    }

    private void drawPrimitive(boolean draw) {
        CellObject cell = ((TGAtom)this.parent.getRootTransform()).getCellObject();
        if (draw) {
            cell.addPrimitiveCell();
        } else {
            cell.removePrimitiveCell();
        }
    }

    private void setSaveSublatAtoms(boolean save) {
        AtomCoords coords = this.parent.getCD().getAtomCoords();
        AtomList list = coords.getAtomList();
        int i = 0;
        while (i < list.size()) {
            list.getAtomAt(i).saveSubLatticeAtom(save);
            ++i;
        }
        if (save) {
            this.bravaisLattice.setLatticeSystem("primitive");
        } else {
            this.bravaisLattice.setLatticeSystem(this.latticeSystemCombo.getSelectedItem().toString());
        }
    }

    private void addSubLatticeAtoms() {
        AtomCoords coords = this.parent.getCD().getAtomCoords();
        AtomList list = coords.getAtomList();
        this.logger.debug((Object)"atom list before addition of sublattice atoms:");
        this.logger.debug((Object)list);
        this.parent.getCD().isRenderingManual(true);
        coords.saveState();
        coords.removeBoundaryAtoms();
        this.bravaisLattice.addSubLatticeAtoms(coords);
        this.logger.debug((Object)"atom list after addition of sublattice atoms: ");
        this.logger.debug((Object)list);
        this.parent.prepareRedraw();
        this.parent.getCD().setCoords(coords);
        coords.finalizeState();
        this.parent.doUnitCell();
        this.parent.postRedraw();
        this.parent.getCD().isRenderingManual(false);
    }

    private void removeSubLatticeAtoms() {
        AtomCoords coords = this.parent.getCD().getAtomCoords();
        this.parent.getCD().isRenderingManual(true);
        this.parent.prepareRedraw();
        coords.saveState();
        this.removeSubLatticeAtomsSub(coords);
        this.parent.postRedraw();
        this.parent.getCD().isRenderingManual(false);
        coords.finalizeState();
    }

    private void removeSubLatticeAtomsSub(AtomCoords coords) {
        coords.removeBoundaryAtoms();
        coords.removeSubLatticeAtoms();
        this.parent.getCD().setCoords(coords);
        this.parent.doUnitCell();
    }

    private void doSubLatticeAtomStrip() {
        AtomCoords coords = this.parent.getCD().getAtomCoords();
        coords.saveState();
        this.parent.getCD().isRenderingManual(true);
        this.parent.prepareRedraw();
        this.doSubLatticeAtomStripSub(coords);
        this.parent.postRedraw();
        this.parent.getCD().isRenderingManual(false);
        coords.finalizeState();
    }

    private void doSubLatticeAtomStripSub(AtomCoords coords) {
        this.bravaisLattice.stripSubLatticeAtoms(coords);
        this.parent.getCD().setCoords(coords);
        this.parent.doUnitCell();
    }

    @Override
    public void configDataUpdate() {
    }

    @Override
    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }
}

