/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.tools;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.ChoicePanel;
import ciss.phase_viewer.common.ExternalProgramPanel;
import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class BandPlPanel
extends ExternalProgramPanel {
    private Logger logger = Logger.getLogger((String)BandPlPanel.class.getName());
    private String projdir;
    private String energData = "nfenergy.data";
    private String kpointIn = "bandkpt.in";
    private String kpointInDir;
    private InputPanel iperangemin;
    private InputPanel iperangemax;
    private InputPanel ipeinc;
    private ChoicePanel cpPlotType;
    private JCheckBox cbwithfermi;
    private JCheckBox cbcolor;
    private InputPanel ipwidth;
    private boolean kpointInExists = true;
    private String FS = System.getProperty("file.separator");
    private MyMessageBox mbox = new MyMessageBox();

    public BandPlPanel(String title, String dir, String energData) {
        super(title, new Dimension(500, 200));
        this.kpointInDir = dir;
        this.projdir = dir;
        this.setCurrDir(this.projdir);
        this.energData = energData;
        if (!new File(String.valueOf(this.kpointInDir) + System.getProperty("file.separator") + this.kpointIn).exists()) {
            Object[] init = new Object[]{"specify input file", "quit"};
            int ret = JOptionPane.showInternalOptionDialog(Desk.getDesktop(), "couldn't find input file for band_kpoint.pl!", "warning", 0, 2, null, init, init[0]);
            if (ret == 0) {
                ChaseFileChooser fdlg = new ChaseFileChooser("base", true);
                fdlg.setDialogType(2);
                fdlg.setDialogTitle("Open");
                fdlg.setCurrentDirectory(new File(dir));
                fdlg.setFileSelectionMode(0);
                if (fdlg.showDialog(this, "open") != 0) {
                    System.out.println("no specification for bandkpoint.in ...");
                    return;
                }
                String kpointInPath = fdlg.getSelectedFile().getAbsolutePath();
                this.kpointIn = new File(kpointInPath).getName();
                this.kpointInDir = new File(kpointInPath).getParent();
            } else {
                this.logger.error((Object)"no specification for bandkpoint.in ...");
                this.kpointInExists = false;
                this.dispose();
            }
        }
    }

    @Override
    public boolean createExeString() {
        if (!this.kpointInExists) {
            return false;
        }
        GlobalProperties pm = PropertiesManager.getGlobalProperties(0);
        String curDir = System.getProperty("user.dir");
        if (!new File(curDir).canWrite()) {
            this.mbox.setText("can't create tmp file ... check permission.");
            return false;
        }
        String bandpl = String.valueOf(System.getProperty("pviewer.home")) + this.FS + pm.getProperty("phasetoolsdir") + this.FS + "band.pl";
        this.logger.debug((Object)("bandpl: " + bandpl));
        if (!new File(bandpl).exists()) {
            this.exeString = "band.pl";
            this.mbox.setText("could not find band.pl");
            return false;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            bandpl = "perl.exe " + Utils.getPathDQ(bandpl);
        }
        this.exeString = String.valueOf(bandpl) + " " + Utils.getPathDQ(String.valueOf(this.projdir) + System.getProperty("file.separator") + this.energData) + " " + Utils.getPathDQ(String.valueOf(this.kpointInDir) + System.getProperty("file.separator") + this.kpointIn) + " ";
        String erangemin = this.iperangemin.getValue();
        String erangemax = this.iperangemax.getValue();
        String einc = this.ipeinc.getValue();
        String plotType = this.cpPlotType.getChoice();
        boolean fermi = this.cbwithfermi.isSelected();
        boolean color = this.cbcolor.isSelected();
        String width = this.ipwidth.getValue();
        if (erangemin.trim().length() != 0 && erangemax.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -erange=" + erangemin + "," + erangemax;
        }
        if (einc.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -einc=" + einc;
        }
        if (plotType.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -ptype=" + plotType;
        }
        if (fermi) {
            this.exeString = String.valueOf(this.exeString) + " -with_fermi";
        }
        if (width.trim().length() != 0) {
            this.exeString = String.valueOf(this.exeString) + " -width=" + width;
        }
        if (color) {
            this.exeString = String.valueOf(this.exeString) + " -color";
        }
        this.logger.debug((Object)this.exeString);
        return true;
    }

    @Override
    public void bootPostProcess() {
    }

    @Override
    public JPanel createMainPanel() {
        String[] strPlotType = new String[]{"lines", "solid_circles"};
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(2, 4));
        p.setBorder(new TitledBorder("options"));
        this.iperangemin = new InputPanel("erange(min)", 0, 7);
        this.iperangemax = new InputPanel("erange(max)", 0, 7);
        this.ipeinc = new InputPanel("einc", 0, 7);
        this.cpPlotType = new ChoicePanel("ptype", strPlotType);
        this.cbwithfermi = new JCheckBox("with_fermi");
        this.cbcolor = new JCheckBox("color");
        this.ipwidth = new InputPanel("width", 0, 7);
        p.add(this.iperangemin);
        p.add(this.iperangemax);
        p.add(this.ipeinc);
        p.add(this.cpPlotType);
        p.add(this.ipwidth);
        p.add(this.cbwithfermi);
        p.add(this.cbcolor);
        return p;
    }
}

