/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout;

import ciss.phase_viewer.graph.DataPanel;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.projectbrowser.tools.StdoutBasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class StdoutPostPanel
extends StdoutBasePanel {
    private Logger logger = Logger.getLogger((String)StdoutPostPanel.class.getName());
    private JComboBox kpointSelector;
    private JLabel kpoints;
    private TitledBorder kpointTitle;
    private JPanel peigen;
    private JPanel pkpoint;
    private JPanel pfermi;
    private JPanel pstress;
    private JTabbedPane tabbedPane;
    private String[] kinds;
    private DataPanel dpanel;
    private DataPanel dpanelStress;

    public StdoutPostPanel() {
        this.setLayout(new BoxLayout(this, 1));
    }

    @Override
    public void create() {
        if (this.outputParser == null) {
            return;
        }
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.add(this.tabbedPane);
        }
        this.tabbedPane.removeAll();
        int num_kpoints = 0;
        try {
            num_kpoints = Integer.parseInt(this.outputParser.getGenericData("num_kpoints")[0]);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return;
        }
        if (num_kpoints == 0) {
            this.logger.debug((Object)"num_kpoints is 0");
            return;
        }
        this.kinds = new String[num_kpoints];
        int i = 0;
        while (i < num_kpoints) {
            String kk = "kpoint_" + String.valueOf(i);
            String[] kps = this.outputParser.getGenericData(kk);
            if (kps != null && kps.length != 0) {
                String updown = "";
                if (kps[0] != null) {
                    if (kps[0].trim().length() != 0) {
                        updown = " spin: " + kps[0];
                    }
                    String klabel = String.valueOf(updown) + "  kx:  " + kps[1] + "  ky:  " + kps[2] + "  kx:  " + kps[3];
                    this.kinds[i] = " index: " + String.valueOf(i + 1) + " " + klabel;
                    this.logger.debug((Object)this.kinds[i]);
                }
            }
            ++i;
        }
        String title = "select kpoint (number of kpoints: " + String.valueOf(num_kpoints) + ")";
        this.kpointTitle = new TitledBorder(title);
        this.peigen = new JPanel();
        this.peigen.setLayout(new BoxLayout(this.peigen, 1));
        this.pkpoint = new JPanel();
        this.pkpoint.setLayout(new BoxLayout(this.pkpoint, 0));
        this.pkpoint.setBorder(this.kpointTitle);
        this.pfermi = new JPanel();
        this.pfermi.setBorder(new TitledBorder("fermi energy"));
        String ef = "(not available)";
        String[] fermi = this.outputParser.getGenericData("fermi");
        if (fermi != null && fermi.length >= 1) {
            ef = fermi[0];
        }
        JLabel lef = new JLabel(String.valueOf(ef) + " Hartree");
        this.pfermi.add(lef);
        JPanel selectPanel = new JPanel();
        selectPanel.setBorder(new TitledBorder("kpoint index"));
        this.kpointSelector = new JComboBox<String>(this.kinds);
        selectPanel.add(this.kpointSelector);
        this.kpoints = new JLabel();
        this.pkpoint.add(selectPanel);
        this.pkpoint.add(this.kpoints);
        this.kpointSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StdoutPostPanel.this.kpointSelection();
            }
        });
        this.kpointSelector.setSelectedIndex(0);
        if (this.pstress == null) {
            this.pstress = new JPanel();
            this.pstress.setLayout(new BoxLayout(this.pstress, 0));
        }
        String[][] stress_tensor = this.outputParser.getGenericData2D("stress");
        String[] stress_ident = new String[]{"xx,xy,xz", "yx,yy,yz", "zx,zy,zz"};
        OutputData outStress = new OutputData("stress tensor", "elements of stress tensor", stress_ident, stress_tensor, "");
        outStress.setFileName(this.outputParser.getFileName());
        if (this.dpanelStress == null) {
            this.dpanelStress = new DataPanel(outStress);
        } else {
            this.dpanelStress.setOutputData(outStress);
        }
        this.dpanelStress.setPreferredSize(new Dimension(50, 200));
        this.pstress.removeAll();
        this.pstress.add(this.dpanelStress);
        JPanel ppeigen = new JPanel();
        ppeigen.setLayout(new BorderLayout());
        ppeigen.add((Component)this.peigen, "North");
        this.tabbedPane.addTab("eigenvalue", ppeigen);
        this.tabbedPane.addTab("stress tensor", this.pstress);
        this.revalidate();
    }

    private void kpointSelection() {
        if (this.kpointSelector.getSelectedIndex() < 0) {
            return;
        }
        String ee = "eigen_" + String.valueOf(this.kpointSelector.getSelectedIndex());
        String oo = "occup_" + String.valueOf(this.kpointSelector.getSelectedIndex());
        String[] eigen = this.outputParser.getGenericData(ee);
        String[] occup = this.outputParser.getGenericData(oo);
        String[][] data2d = new String[eigen.length][3];
        if (eigen.length != occup.length) {
            return;
        }
        int i = 0;
        while (i < eigen.length) {
            data2d[i][0] = String.valueOf(i + 1);
            data2d[i][1] = eigen[i];
            data2d[i][2] = occup[i];
            ++i;
        }
        String[] idents = new String[]{" band index ", "eigenvalue (a.u.) ", " occupation "};
        OutputData outData = new OutputData("eigenvalue", "eigenvalue at a particular k-point", idents, data2d, "");
        outData.setFileName(this.outputParser.getFileName());
        if (this.dpanel == null) {
            this.dpanel = new DataPanel(outData);
        } else {
            this.dpanel.setOutputData(outData);
        }
        this.dpanel.setPreferredSize(new Dimension(50, 200));
        this.peigen.removeAll();
        this.peigen.setLayout(new BoxLayout(this.peigen, 1));
        this.peigen.add(this.pfermi);
        this.peigen.add(this.pkpoint);
        this.peigen.add(this.dpanel);
    }

    @Override
    public String getDescription() {
        return "post";
    }
}

