/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class NfDynmParser
extends OutputParser {
    private Logger logger = Logger.getLogger((String)NfDynmParser.class.getName());
    private String SHARP = "#";
    private String iter_ion_str = new String();
    private String iter_total_str = new String();
    private String[] ident = new String[]{"iter_ion", "iter_total", "atom_label", "pos(x)", "pos(y)", "pos(z)", "forc(x)", "forc(y)", "forc(z)"};
    private String header = "";
    private String LS = System.getProperty("line.separator");
    private Vector dataVector = new Vector();
    private boolean readHeader = false;

    public NfDynmParser(String fileName) {
        super(fileName);
    }

    @Override
    protected boolean parse() {
        String line;
        if (this.readers != null) {
            int i = 0;
            while (i < this.readers.length) {
                block31: {
                    this.readHeader = false;
                    this.header = "";
                    this.dataVector = new Vector();
                    try {
                        try {
                            while ((line = this.readers[i].readLine()) != null) {
                                this.parseLine(line.trim());
                            }
                        }
                        catch (IOException iOException) {
                            try {
                                this.readers[i].close();
                            }
                            catch (IOException iOException2) {}
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            this.readers[i].close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        this.readers[i].close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                String[][] data2d = null;
                if (this.dataVector.size() != 0) {
                    data2d = new String[this.dataVector.size()][this.ident.length];
                    this.dataVector.copyInto((Object[])data2d);
                }
                String[] id = this.fileNames.get(i).toString().split("\\.");
                OutputData outputData = new OutputData(id[id.length - 1], "ionic position & force", this.ident, data2d, this.header);
                outputData.setFileName(this.fileName);
                super.addOutputData(outputData);
                ++i;
            }
            if (this.readers.length != 0) {
                this.isDone = true;
            }
        }
        if (this.reader == null) {
            return false;
        }
        this.dataVector = new Vector();
        this.header = "";
        try {
            try {
                while ((line = this.reader.readLine()) != null) {
                    this.parseLine(line.trim());
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.isDone = true;
                try {
                    this.reader.close();
                }
                catch (IOException ioe2) {
                    this.logger.error((Object)("failed to close " + this.fileName));
                }
                return false;
            }
        }
        finally {
            this.isDone = true;
            try {
                this.reader.close();
            }
            catch (IOException ioe) {
                this.logger.error((Object)("failed to close " + this.fileName));
            }
        }
        String[][] data2d = null;
        if (this.dataVector.size() != 0) {
            data2d = new String[this.dataVector.size()][this.ident.length];
            this.dataVector.copyInto((Object[])data2d);
        }
        if (this.dataVector.size() == 0) {
            return false;
        }
        OutputData outputData = new OutputData("F_DYNM", "ionic position & force", this.ident, data2d, this.header);
        outputData.setFileName(this.fileName);
        super.addOutputData(outputData);
        return true;
    }

    private void parseLine(String line) {
        if (line.startsWith(this.SHARP) && this.readHeader) {
            return;
        }
        if (line.startsWith(this.SHARP) && !this.readHeader) {
            this.header = String.valueOf(this.header) + line + this.LS;
        } else if (line.startsWith("cps")) {
            String[] arcps = line.split("\\s+");
            if (arcps != null && arcps.length >= 9) {
                this.iter_ion_str = arcps[7];
                this.iter_total_str = arcps[8];
            } else {
                this.iter_ion_str = "N/A";
                this.iter_total_str = "N/A";
            }
        } else {
            this.readHeader = true;
            String[] data = line.split("\\s+");
            if (data == null) {
                return;
            }
            String[] row = new String[data.length + 2];
            row[0] = this.iter_ion_str;
            row[1] = this.iter_total_str;
            int i = 0;
            while (i < data.length) {
                row[i + 2] = data[i];
                ++i;
            }
            this.dataVector.addElement(row);
        }
    }

    @Override
    public String getCurrentMessage() {
        return null;
    }
}

