/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.graph.DataPanel;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.tools.AnimDynmPlPanel;
import ciss.phase_viewer.primitiveguis.ComboButton;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.ChoosableOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.ONOFFOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlExecPanel;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScript;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScriptExecListener;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScriptOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.RangeOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.TextOption;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class PhononPanel
extends ProjectManipulator {
    private Logger logger = Logger.getLogger((String)PhononPanel.class.getName());
    private String trj2file = "mode_\\d+.tr2";
    private String gridmol2 = "grid.mol2";
    private String epsfile = "freq\\d*.eps";
    private String phband_file = "phonon_band.eps";
    private String phdos_file = "phonon_dos.eps";
    private String phfree_file = "phonon_free.eps";
    private String phspecific_heat_file = "phonon_specific_heat.eps";
    private boolean isGamma = true;
    private JComboBox tr2combo;
    private JComboBox epscombo;
    private String phfree_data_file = "phfree.data";
    private String phheat_data_file = "phheat.data";
    private PHFreePanel phfreePanel;
    private PHHeatPanel phheatPanel;
    private String modeData;

    public PhononPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    /*
     * Exception decompiling
     */
    private void determineType(String fmodeFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createPanelForDispersion() {
        JTabbedPane pane = new JTabbedPane();
        PHDOSandPHBandPanel dosband = new PHDOSandPHBandPanel();
        pane.addTab("dos and band", dosband);
        PHFreeAndHeatPanel freeheat = new PHFreeAndHeatPanel();
        pane.addTab("free energy and specific heat", freeheat);
        this.setLayout(new BoxLayout(this, 1));
        this.add(pane);
        this.revalidate();
    }

    private void runphdos() {
        PerlScript script = new PerlScript("phdos.pl", new File(this.projectInfo.getProjectDirectory()));
        script.setCommand(new String[]{"phdos.data", PerlScriptOption.OPTION});
        ChoosableOption unit = new ChoosableOption("unit", new String[]{"mHa", "meV", "cm-1", "THz"});
        RangeOption erange = new RangeOption("erange");
        TextOption einc = new TextOption("einc");
        RangeOption dosrange = new RangeOption("dosrange");
        TextOption dosinc = new TextOption("dosinc");
        ONOFFOption color = new ONOFFOption("color");
        TextOption title = new TextOption("title");
        TextOption width = new TextOption("width");
        TextOption font = new TextOption("font");
        script.addOptions(unit);
        script.addOptions(erange);
        script.addOptions(einc);
        script.addOptions(dosrange);
        script.addOptions(dosinc);
        script.addOptions(color);
        script.addOptions(title);
        script.addOptions(width);
        script.addOptions(font);
        PerlExecPanel panel = new PerlExecPanel("run phdos.pl", new Dimension(400, 250), script);
    }

    private void runphband() {
        PerlScript script = new PerlScript("phband.pl", new File(this.projectInfo.getProjectDirectory()));
        script.setCommand(new String[]{this.modeData, "phbandcontrol", PerlScriptOption.OPTION});
        ChoosableOption unit = new ChoosableOption("unit", new String[]{"mHa", "meV", "cm-1", "THz"});
        RangeOption erange = new RangeOption("erange");
        TextOption einc = new TextOption("einc");
        ChoosableOption ptype = new ChoosableOption("ptype", new String[]{"lines", "solid_circles"});
        ONOFFOption color = new ONOFFOption("color");
        TextOption width = new TextOption("width");
        script.addOptions(unit);
        script.addOptions(erange);
        script.addOptions(einc);
        script.addOptions(ptype);
        script.addOptions(color);
        script.addOptions(width);
        PerlExecPanel pan = new PerlExecPanel("run phband.pl", new Dimension(440, 200), script);
    }

    private void runphfree() {
        PerlScript script = new PerlScript("phfree.pl", new File(this.projectInfo.getProjectDirectory()));
        script.setCommand(new String[]{this.modeData, PerlScriptOption.OPTION});
        ChoosableOption unit = new ChoosableOption("unit", new String[]{"mHa", "meV", "cm-1", "THz"});
        RangeOption erange = new RangeOption("erange");
        TextOption einc = new TextOption("einc");
        RangeOption trange = new RangeOption("trange");
        TextOption tinc = new TextOption("tinc");
        TextOption ntemp = new TextOption("ntemp");
        ChoosableOption ptype = new ChoosableOption("ptype", new String[]{"lines", "solid_circles"});
        ONOFFOption color = new ONOFFOption("color");
        TextOption width = new TextOption("width");
        script.addOptions(unit);
        script.addOptions(erange);
        script.addOptions(einc);
        script.addOptions(trange);
        script.addOptions(tinc);
        script.addOptions(ntemp);
        script.addOptions(ptype);
        script.addOptions(color);
        script.addOptions(width);
        PerlExecPanel panel = new PerlExecPanel("run phfree.pl", new Dimension(440, 250), script);
        panel.setStdoutFile(new File(String.valueOf(this.projectInfo.getProjectDirectory()) + this.phfree_data_file));
        panel.addListener(this.phfreePanel);
    }

    private void runphheat() {
        PerlScript script = new PerlScript("phheat.pl", new File(this.projectInfo.getProjectDirectory()));
        script.setCommand(new String[]{this.modeData, PerlScriptOption.OPTION});
        TextOption cinc = new TextOption("cinc");
        RangeOption trange = new RangeOption("trange");
        TextOption tinc = new TextOption("tinc");
        TextOption ntemp = new TextOption("ntemp");
        ChoosableOption ptype = new ChoosableOption("ptype", new String[]{"lines", "solid_circles"});
        ONOFFOption color = new ONOFFOption("color");
        TextOption width = new TextOption("width");
        script.addOptions(trange);
        script.addOptions(tinc);
        script.addOptions(ntemp);
        script.addOptions(ptype);
        script.addOptions(color);
        script.addOptions(width);
        PerlExecPanel panel = new PerlExecPanel("run phheat.pl", new Dimension(440, 200), script);
        panel.setStdoutFile(new File(String.valueOf(this.projectInfo.getProjectDirectory()) + this.phheat_data_file));
        panel.addListener(this.phheatPanel);
    }

    private void createPanelForGamma() {
        JPanel pmodepl = new JPanel();
        pmodepl.setBorder(new TitledBorder("freq.pl"));
        JButton btnmodepl = new JButton("run freq.pl");
        pmodepl.add(btnmodepl);
        JPanel panimpl = new JPanel();
        panimpl.setBorder(new TitledBorder("animate.pl"));
        JButton btnanimpl = new JButton("run animate.pl");
        panimpl.add(btnanimpl);
        JPanel pbtns = new JPanel();
        pbtns.setLayout(new BoxLayout(pbtns, 0));
        pbtns.add(pmodepl);
        pbtns.add(panimpl);
        this.add(pbtns);
        ComboButton cbanim = new ComboButton(this.projectInfo.getProjectDirectory(), new String[]{this.trj2file});
        ComboButton cbfreq = new ComboButton(this.projectInfo.getProjectDirectory(), this.epsfile);
        pmodepl.add(cbfreq);
        panimpl.add(cbanim);
        btnmodepl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PhononPanel.this.bootFreqPl();
            }
        });
        btnanimpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimDynmPlPanel panel = new AnimDynmPlPanel(PhononPanel.this.projectInfo.getProjectDirectory(), PhononPanel.this.projectInfo.getChaseFileManager().getFile("F_MODE").getFileName());
            }
        });
    }

    private void bootFreqPl() {
        PerlScript script = new PerlScript("freq.pl", new File(this.projectInfo.getProjectDirectory()));
        TextOption width = new TextOption("width");
        TextOption height = new TextOption("height");
        TextOption nrep = new TextOption("nrep");
        ONOFFOption solid = new ONOFFOption("solid");
        ONOFFOption mol = new ONOFFOption("mol");
        TextOption ig = new TextOption("ignored_modes");
        script.setCommand(new String[]{PerlScriptOption.OPTION, this.modeData});
        script.addOptions(width);
        script.addOptions(height);
        script.addOptions(nrep);
        script.addOptions(solid);
        script.addOptions(mol);
        script.addOptions(ig);
        PerlExecPanel panel = new PerlExecPanel("run freq.pl", new Dimension(400, 200), script);
    }

    @Override
    public void init() {
        StringBuffer text;
        block13: {
            String name;
            this.setLayout(new BoxLayout(this, 1));
            this.modeData = name = this.projectInfo.getChaseFileManager().getFile("F_MODE").getFileName();
            this.logger.debug((Object)("name: " + name));
            String fname = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + name;
            if (!new File(fname).exists() || new File(fname).isDirectory()) {
                this.add(new NoFilePanel("F_MODE"));
                return;
            }
            this.createPanelForGamma();
            BufferedReader reader = null;
            text = new StringBuffer("");
            try {
                try {
                    reader = new BufferedReader(new FileReader(fname));
                    String str = "";
                    while ((str = reader.readLine()) != null) {
                        text.append(String.valueOf(str) + System.getProperty("line.separator"));
                    }
                }
                catch (Exception exc) {
                    this.logger.error((Object)("error in reading " + fname));
                    exc.printStackTrace();
                    try {
                        reader.close();
                    }
                    catch (Exception exc2) {
                        exc2.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        JPanel pmode = new JPanel();
        pmode.setLayout(new BoxLayout(pmode, 1));
        JTextPane pane = new JTextPane();
        pane.setPreferredSize(new Dimension(500, 300));
        pane.setEditable(false);
        pane.setBackground(Color.WHITE);
        pane.setText(text.toString());
        pane.setCaretPosition(0);
        JScrollPane scrpane = new JScrollPane(pane);
        pmode.add(scrpane);
        this.add(pmode);
    }

    @Override
    public void initializeProject() {
    }

    static /* synthetic */ Logger access$2(PhononPanel phononPanel) {
        return phononPanel.logger;
    }

    class PHDOSPanel
    extends JPanel
    implements OutputParserListener {
        private OutputParser parser;

        PHDOSPanel() {
            this.init();
        }

        private void init() {
            this.removeAll();
            String fname = String.valueOf(PhononPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + PhononPanel.this.projectInfo.getChaseFileManager().getFile("F_PHDOS").getFileName();
            if (!new File(fname).exists()) {
                this.add(new NoFilePanel("F_PHDOS"));
                return;
            }
            this.add(new LoadingFilePanel("F_PHDOS"));
            if (this.parser == null) {
                this.parser = PhononPanel.this.projectInfo.getOutputInterface().getParser("F_PHDOS", this);
            }
            this.parser.setParsed(false);
            this.parser.doParse();
        }

        @Override
        public void parseFinished() {
            this.removeAll();
            this.setLayout(new BoxLayout(this, 1));
            JPanel dataPanel = PhononPanel.this.projectInfo.getOutputInterface().getDataPanel("F_PHDOS");
            this.add(dataPanel);
        }
    }

    class PHDOSandPHBandPanel
    extends JPanel {
        PHDOSandPHBandPanel() {
            this.setLayout(new BorderLayout());
            JPanel btns = new JPanel();
            btns.setLayout(new BoxLayout(btns, 1));
            JPanel pdos = new JPanel();
            pdos.setBorder(new TitledBorder("phonon DOS"));
            JButton btnrunphdos = new JButton("run phdos.pl");
            ComboButton cbdos = new ComboButton(PhononPanel.this.projectInfo.getProjectDirectory(), PhononPanel.this.phdos_file);
            pdos.add(btnrunphdos);
            pdos.add(cbdos);
            JPanel pband = new JPanel();
            pband.setBorder(new TitledBorder("phonon band"));
            JButton btnrunphband = new JButton("run phband.pl");
            ComboButton cbband = new ComboButton(PhononPanel.this.projectInfo.getProjectDirectory(), PhononPanel.this.phband_file);
            pband.add(btnrunphband);
            pband.add(cbband);
            btns.add(pdos);
            btns.add(pband);
            btnrunphdos.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhononPanel.this.runphdos();
                }
            });
            btnrunphband.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhononPanel.this.runphband();
                }
            });
            this.add((Component)btns, "North");
            PHDOSPanel phdospanel = new PHDOSPanel();
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(phdospanel);
            this.add((Component)p, "Center");
        }
    }

    class PHFreeAndHeatPanel
    extends JPanel {
        PHFreeAndHeatPanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            JPanel pfree = new JPanel();
            pfree.setBorder(new TitledBorder("free energy"));
            JButton btnrunphfree = new JButton("run phfree.pl");
            ComboButton cbfree = new ComboButton(PhononPanel.this.projectInfo.getProjectDirectory(), PhononPanel.this.phfree_file);
            pfree.add(btnrunphfree);
            pfree.add(cbfree);
            JPanel pheat = new JPanel();
            pheat.setBorder(new TitledBorder("specific heat"));
            JButton btnrunphheat = new JButton("run phheat.pl");
            ComboButton cbheat = new ComboButton(PhononPanel.this.projectInfo.getProjectDirectory(), PhononPanel.this.phspecific_heat_file);
            pheat.add(btnrunphheat);
            pheat.add(cbheat);
            p.add(pfree);
            p.add(pheat);
            this.add((Component)p, "North");
            JTabbedPane pane = new JTabbedPane();
            PhononPanel.this.phfreePanel = new PHFreePanel();
            JPanel phf = new JPanel();
            phf.setLayout(new BorderLayout());
            phf.add((Component)PhononPanel.this.phfreePanel, "North");
            pane.addTab("free energy", phf);
            PhononPanel.this.phheatPanel = new PHHeatPanel();
            JPanel ph = new JPanel();
            ph.setLayout(new BorderLayout());
            ph.add((Component)PhononPanel.this.phheatPanel, "North");
            pane.addTab("specific heat", ph);
            JPanel pp = new JPanel();
            pp.setLayout(new BoxLayout(pp, 1));
            pp.add(pane);
            this.add((Component)pp, "Center");
            btnrunphfree.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhononPanel.this.runphfree();
                }
            });
            btnrunphheat.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhononPanel.this.runphheat();
                }
            });
        }
    }

    class PHFreePanel
    extends JPanel
    implements PerlScriptExecListener {
        private Vector data;
        private OutputData outputData;
        private String[] ident;

        PHFreePanel() {
            this.removeAll();
            if (new File(String.valueOf(PhononPanel.this.projectInfo.getProjectDirectory()) + PhononPanel.this.phfree_data_file).exists()) {
                this.genGUI();
            } else {
                this.add(new NoFilePanel("free-energy file"));
            }
        }

        /*
         * Unable to fully structure code
         */
        private void genGUI() {
            block13: {
                this.removeAll();
                reader = Utils.getReader(String.valueOf(PhononPanel.access$0(PhononPanel.this).getProjectDirectory()) + PhononPanel.access$3(PhononPanel.this));
                line = "";
                this.data = new Vector<E>();
lbl5:
                // 2 sources

                try {
                    try {
                        while ((line = reader.readLine()) != null) {
                            block14: {
                                ar = line.trim().split("\\s+");
                                if (!line.trim().startsWith("#")) break block14;
                                if (ar.length != 5) continue;
                                this.ident = new String[4];
                                i = 0;
                                while (i < 4) {
                                    this.ident[i] = ar[i + 1];
                                    ++i;
                                }
                                ** GOTO lbl5
                            }
                            this.data.add(ar);
                        }
                    }
                    catch (IOException ar) {
                        try {
                            reader.close();
                        }
                        catch (IOException var6_7) {}
                        break block13;
                    }
                }
                catch (Throwable var5_10) {
                    try {
                        reader.close();
                    }
                    catch (IOException var6_8) {
                        // empty catch block
                    }
                    throw var5_10;
                }
                try {
                    reader.close();
                }
                catch (IOException var6_9) {
                    // empty catch block
                }
            }
            d2d = new String[this.data.size()][];
            this.data.copyInto((Object[])d2d);
            this.outputData = new OutputData("free energy", "Hermholtz free energy versus temperature", this.ident, d2d, "");
            panel = new DataPanel(this.outputData);
            panel.setPreferredSize(new Dimension(525, 250));
            this.setLayout(new BoxLayout(this, 1));
            this.add(panel);
            this.revalidate();
        }

        @Override
        public void perlScriptFinished() {
            this.genGUI();
        }

        @Override
        public void perlScriptStarted() {
        }
    }

    class PHHeatPanel
    extends JPanel
    implements PerlScriptExecListener {
        private Vector data;
        private OutputData outputData;
        private String[] ident;

        PHHeatPanel() {
            if (new File(String.valueOf(PhononPanel.this.projectInfo.getProjectDirectory()) + PhononPanel.this.phheat_data_file).exists()) {
                this.genGUI();
            } else {
                this.add(new NoFilePanel("specific heat file"));
            }
        }

        private void genGUI() {
            this.removeAll();
            this.setLayout(new BoxLayout(this, 1));
            JPanel panel = this.getDataPanel();
            this.add(panel);
        }

        /*
         * Unable to fully structure code
         */
        private JPanel getDataPanel() {
            block13: {
                reader = Utils.getReader(String.valueOf(PhononPanel.access$0(PhononPanel.this).getProjectDirectory()) + PhononPanel.access$1(PhononPanel.this));
                line = "";
                this.data = new Vector<E>();
lbl4:
                // 2 sources

                try {
                    try {
                        while ((line = reader.readLine()) != null) {
                            block14: {
                                ar = line.trim().split("\\s+");
                                if (!line.trim().startsWith("#")) break block14;
                                if (ar.length != 3) continue;
                                this.ident = new String[2];
                                i = 0;
                                while (i < 2) {
                                    this.ident[i] = ar[i + 1];
                                    ++i;
                                }
                                ** GOTO lbl4
                            }
                            this.data.add(ar);
                        }
                    }
                    catch (IOException ar) {
                        try {
                            reader.close();
                        }
                        catch (IOException var6_7) {}
                        break block13;
                    }
                }
                catch (Throwable var5_10) {
                    try {
                        reader.close();
                    }
                    catch (IOException var6_8) {
                        // empty catch block
                    }
                    throw var5_10;
                }
                try {
                    reader.close();
                }
                catch (IOException var6_9) {
                    // empty catch block
                }
            }
            d2d = new String[this.data.size()][];
            this.data.copyInto((Object[])d2d);
            this.outputData = new OutputData("specific heat", "specific heat versus temperature", this.ident, d2d, "");
            panel = new DataPanel(this.outputData);
            PhononPanel.access$2(PhononPanel.this).info((Object)panel.getPreferredSize());
            panel.setPreferredSize(new Dimension(525, 250));
            return panel;
        }

        @Override
        public void perlScriptFinished() {
            this.genGUI();
        }

        @Override
        public void perlScriptStarted() {
        }
    }
}

