/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.ConstraintsEditor;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class ConstraintsPanel
extends ProjectManipulator {
    private Logger logger = Logger.getLogger((String)ConstraintsPanel.class.getName());

    public ConstraintsPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void init() {
        this.add(new ConstraintsSubPanel(this.projectInfo));
    }

    @Override
    public void initializeProject() {
    }

    class ConstraintsSubPanel
    extends PhaseInputItems {
        private JButton addButton;
        private JButton deleteButton;
        private JTabbedPane tabbedPane;
        private JComboBox combotype;

        ConstraintsSubPanel(ProjectInfo pinfo) {
            super(pinfo);
        }

        private void generateConstraintsEditorGUI(String constraintType) {
            int id = this.tabbedPane.getTabCount() + 1;
            ConstraintsEditor editor = ConstraintsEditor.getEditor(constraintType, this.projectInfo, id);
            if (editor == null) {
                return;
            }
            this.tabbedPane.addTab(editor.getNameOfConstraint(), editor);
            this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, editor.getDescriptionOfConstraint());
        }

        @Override
        public void createGUI() {
            String typ;
            this.setLayout(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setPreferredSize(new Dimension(500, 330));
            this.tabbedPane.setTabLayoutPolicy(1);
            JPanel p = new JPanel();
            p.add(this.tabbedPane);
            this.combotype = new JComboBox<String>(ConstraintsEditor.CONSTRAINTS);
            this.addButton = new JButton("add new constraint");
            this.deleteButton = new JButton("remove selected constraint");
            JPanel pbtn = new JPanel();
            pbtn.setLayout(new BoxLayout(pbtn, 0));
            pbtn.add(this.combotype);
            pbtn.add(this.addButton);
            pbtn.add(this.deleteButton);
            this.add((Component)p, "Center");
            this.add((Component)pbtn, "South");
            int i = 0;
            while ((typ = this.inputInterface.getInputInterfacePrimitiveEntry("structure.constrainable" + String.valueOf(++i) + ".type").getValue()).trim().length() != 0) {
                this.generateConstraintsEditorGUI(typ);
            }
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ConstraintsSubPanel.this.generateConstraintsEditorGUI(ConstraintsSubPanel.this.combotype.getSelectedItem().toString());
                }
            });
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int rem = ConstraintsSubPanel.this.tabbedPane.getSelectedIndex();
                    ConstraintsEditor editor = (ConstraintsEditor)ConstraintsSubPanel.this.tabbedPane.getSelectedComponent();
                    editor.removeTheCurrentConstraint();
                    ConstraintsSubPanel.this.tabbedPane.remove(editor);
                    int i = 0;
                    while (i < ConstraintsSubPanel.this.tabbedPane.getTabCount()) {
                        ((ConstraintsEditor)ConstraintsSubPanel.this.tabbedPane.getComponentAt(i)).setID(i + 1);
                        ++i;
                    }
                }
            });
        }
    }
}

