/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.AddButton;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.DeleteButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputPanelInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ProjectorEditor
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)ProjectorEditor.class.getName());
    private ProjectInfo projectInfo;
    private InputInterface inputInterface;

    public ProjectorEditor(ProjectInfo projectInfo) {
        super("configure projectors", true, true, true, true, new Dimension(450, 400));
        this.projectInfo = projectInfo;
        if (this.projectInfo == null) {
            this.logger.error((Object)"project info is null!!!!");
        }
        this.inputInterface = this.projectInfo.getInputInterface();
        JPanel p = new JPanel();
        ProjE pre = new ProjE(this.inputInterface);
        p.add(pre);
        this.getContentPane().add(p);
    }

    class ProjE
    extends PhaseInputItems {
        ProjE(InputInterface inputInterface) {
            super(inputInterface);
        }

        @Override
        public void createGUI() {
            JPanel pproj = new JPanel();
            pproj.setLayout(new BoxLayout(pproj, 1));
            String[] dummyArray = new String[]{""};
            JPanel pprojector_list = new JPanel();
            pprojector_list.setBorder(new TitledBorder("projector list"));
            pprojector_list.setLayout(new BoxLayout(pprojector_list, 1));
            String[] spec_projector_list = new String[]{"accuracy.projector_list.projectors"};
            TableForInputInterface projector_list_table = new TableForInputInterface(spec_projector_list, this.inputInterface, this);
            JScrollPane scr_projector_list = new JScrollPane();
            scr_projector_list.getViewport().setView(projector_list_table.getPanel());
            scr_projector_list.setPreferredSize(new Dimension(400, 100));
            pprojector_list.add(scr_projector_list);
            InputPanelPhase ippgroup = new InputPanelPhase(dummyArray, this.inputInterface, "group", 0, 5);
            InputPanelPhase ippradius = new InputPanelPhase(dummyArray, this.inputInterface, "radius", 0, 5);
            ChoicePanelPhase cppl = new ChoicePanelPhase(dummyArray, this.inputInterface, "l (0: s, 1:p, 2:d, 3: f)", new String[]{"0", "1", "2", "3"});
            ChoicePanelPhase cppt = new ChoicePanelPhase(dummyArray, this.inputInterface, "t (1 or 2)", new String[]{"1", "2"});
            JPanel p_new_projector1 = new JPanel();
            p_new_projector1.setBorder(new TitledBorder("new projector"));
            p_new_projector1.setLayout(new GridLayout(1, 3));
            p_new_projector1.add(ippgroup);
            p_new_projector1.add(ippradius);
            p_new_projector1.add(cppl);
            p_new_projector1.add(cppt);
            PhaseInputPanelInterface[] phaseInputPanelInterfaceArray = new PhaseInputPanelInterface[5];
            phaseInputPanelInterfaceArray[1] = ippgroup;
            phaseInputPanelInterfaceArray[2] = ippradius;
            phaseInputPanelInterfaceArray[3] = cppl;
            phaseInputPanelInterfaceArray[4] = cppt;
            PhaseInputPanelInterface[] projector_list_guis = phaseInputPanelInterfaceArray;
            AddButton add_projector_list = new AddButton(projector_list_table, projector_list_guis, this);
            DeleteButton delete_projector_list = new DeleteButton(projector_list_table, this);
            JButton projector_list_from_file = new JButton("from file");
            projector_list_from_file.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ProjE.this.fromFile("accuracy.projector_list", "projectors");
                }
            });
            JPanel p_new_projector = new JPanel();
            p_new_projector.setLayout(new BoxLayout(p_new_projector, 0));
            p_new_projector.add(add_projector_list);
            p_new_projector.add(delete_projector_list);
            p_new_projector.add(projector_list_from_file);
            JPanel p_assign = new JPanel();
            p_assign.setLayout(new BoxLayout(p_assign, 1));
            p_assign.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.gridwidth = 0;
            gc.weightx = 1.0;
            p_assign.setBorder(new TitledBorder("assign projector"));
            this.inputInterface.selectRoot();
            this.inputInterface.selectBlock("accuracy.projector_list.projectors");
            InputInterfaceTable tableproj = this.inputInterface.getTable();
            Vector projData = tableproj.getTableData();
            int grind = tableproj.getIndexFor("group");
            Vector distinctGroups = new Vector();
            int[] gr = this.getDistinctGroups();
            String[] ele = this.getElements();
            int i = 0;
            while (i < ele.length) {
                PA pa = new PA(ele[i], gr);
                this.inputInterface.addInputInterfaceEntryChangeListener(pa);
                gc.gridx = 0;
                gc.gridy = i++;
                p_assign.add((Component)pa, gc);
            }
            this.inputInterface.selectRoot();
            JScrollPane scp = new JScrollPane(p_assign);
            scp.setPreferredSize(new Dimension(400, 100));
            pproj.add(pprojector_list);
            pproj.add(p_new_projector1);
            pproj.add(p_new_projector);
            pproj.add(scp);
            JButton dismiss = new JButton("dismiss");
            dismiss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectorEditor.this.dispose();
                }
            });
            pproj.add(dismiss);
            this.add(pproj);
        }

        private int[] getDistinctGroups() {
            this.inputInterface.selectRoot();
            this.inputInterface.selectBlock("accuracy.projector_list.projectors");
            InputInterfaceTable tableproj = this.inputInterface.getTable();
            Vector projData = tableproj.getTableData();
            int grind = tableproj.getIndexFor("group");
            Vector<Integer> distinctGroups = new Vector<Integer>();
            int i = 0;
            while (i < projData.size()) {
                try {
                    Integer inte = new Integer(Integer.parseInt(((String[])projData.get(i))[grind]));
                    if (distinctGroups.indexOf(inte) < 0) {
                        distinctGroups.add(inte);
                    }
                }
                catch (Exception inte) {
                    // empty catch block
                }
                ++i;
            }
            int[] gr = new int[distinctGroups.size() + 1];
            gr[0] = 0;
            int i2 = 0;
            while (i2 < distinctGroups.size()) {
                gr[i2 + 1] = (Integer)distinctGroups.get(i2);
                ++i2;
            }
            this.inputInterface.selectRoot();
            return gr;
        }

        private String[] getElements() {
            this.inputInterface.selectRoot();
            this.inputInterface.selectBlock("structure.element_list");
            InputInterfaceTable tableelem = this.inputInterface.getTable();
            Vector eleData = tableelem.getTableData();
            int grind = tableelem.getIndexFor("element");
            String[] ret = new String[eleData.size()];
            int i = 0;
            while (i < ret.length) {
                ret[i] = ((String[])eleData.get(i))[grind];
                ++i;
            }
            this.inputInterface.selectRoot();
            return ret;
        }

        class PA
        extends JPanel
        implements InputInterfaceEntryChangeListener {
            private JLabel element;
            private JComboBox projGroup;
            private String elemName;

            PA(String elemName, int[] groupCandidate) {
                this.setLayout(new GridLayout(1, 2));
                this.element = new JLabel(elemName);
                this.elemName = elemName;
                String[] groups = new String[groupCandidate.length];
                int i = 0;
                while (i < groups.length) {
                    groups[i] = String.valueOf(groupCandidate[i]);
                    ++i;
                }
                JPanel jg = new JPanel();
                this.projGroup = new JComboBox<String>(groups);
                jg.add(this.projGroup);
                this.add(this.element);
                this.add(this.projGroup);
                int proj = this.getProjGroup(elemName);
                this.projGroup.setSelectedItem(String.valueOf(proj));
                this.projGroup.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PA.this.applyProj();
                    }
                });
            }

            private int getProjGroup(String elementName) {
                int ret = 0;
                ProjE.this.inputInterface.selectRoot();
                ProjE.this.inputInterface.selectBlock("structure.atom_list.atoms");
                InputInterfaceTable tableatom = ProjE.this.inputInterface.getTable();
                Vector atdata = tableatom.getTableData();
                int ind = tableatom.getIndexFor("element");
                int ind_proj = tableatom.getIndexFor("proj_group");
                if (ind_proj >= 0) {
                    int i = 0;
                    while (i < atdata.size()) {
                        String[] dat = (String[])atdata.get(i);
                        if (dat[ind].equalsIgnoreCase(elementName)) {
                            try {
                                ret = Integer.parseInt(dat[ind_proj]);
                                break;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                }
                ProjE.this.inputInterface.selectRoot();
                return ret;
            }

            private void applyProj() {
                if (this.projGroup.getSelectedItem() == null) {
                    return;
                }
                ProjE.this.inputInterface.selectRoot();
                ProjE.this.inputInterface.selectBlock("structure.atom_list.atoms");
                InputInterfaceTable tableatom = ProjE.this.inputInterface.getTable();
                Vector atdata = tableatom.getTableData();
                int ind = tableatom.getIndexFor("element");
                int ind_proj = tableatom.getIndexFor("proj_group");
                String[] idents = tableatom.getColumnIdentifiers();
                int numcol = idents.length;
                int i = 0;
                while (i < atdata.size()) {
                    String[] data = (String[])atdata.get(i);
                    if (data[ind].equalsIgnoreCase(this.elemName)) {
                        String[] foo = new String[data.length];
                        int j = 0;
                        while (j < data.length) {
                            foo[j] = data[j];
                            ++j;
                        }
                        foo[ind_proj] = this.projGroup.getSelectedItem().toString();
                        tableatom.replaceTableDataRow(foo, i);
                    }
                    ++i;
                }
                ProjE.this.inputInterface.selectRoot();
            }

            @Override
            public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
                if (e.getSource() == this || e.getEntry().getEntryType() != 1 || !e.getTag().equalsIgnoreCase("accuracy.projector_list.projectors")) {
                    return;
                }
                ActionListener[] al = this.projGroup.getActionListeners();
                Object o = this.projGroup.getSelectedItem();
                int i = 0;
                while (i < al.length) {
                    this.projGroup.removeActionListener(al[i]);
                    ++i;
                }
                int[] gr = ProjE.this.getDistinctGroups();
                this.projGroup.removeAllItems();
                String[] groups = new String[gr.length];
                int i2 = 0;
                while (i2 < groups.length) {
                    groups[i2] = String.valueOf(gr[i2]);
                    this.projGroup.addItem(groups[i2]);
                    ++i2;
                }
                this.projGroup.setSelectedItem(o);
                i2 = 0;
                while (i2 < al.length) {
                    this.projGroup.addActionListener(al[i2]);
                    ++i2;
                }
            }

            @Override
            public void inputInterfaceInitializing() {
            }

            @Override
            public void inputInterfaceInitialized() {
            }
        }
    }
}

