/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.AddButton;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.DeleteButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputPanelInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;

public class MDConfig
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)MDConfig.class.getName());
    private ProjectInfo projectInfo;
    private InputInterface inputInterface;
    private MDPanel pan;

    public MDConfig(ProjectInfo projectInfo) {
        super("MD config", true, true, true, true, new Dimension(550, 480));
        try {
            this.projectInfo = projectInfo;
            this.inputInterface = projectInfo.getInputInterface();
            JPanel p = new JPanel();
            this.pan = new MDPanel(this.inputInterface);
            p.add(this.pan);
            this.getContentPane().add(p);
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    MDConfig.this.pan.exit();
                }
            });
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    class MDPanel
    extends PhaseInputItems {
        private TableForInputInterface tfii;

        MDPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        @Override
        public void createGUI() {
            JPanel panel = new JPanel();
            String[] initvel = new String[]{"structure_evolution.temperature_control.set_initial_velocity"};
            ChoicePanelPhase cppinitvel = new ChoicePanelPhase(initvel, this.inputInterface, "set initial velocity", this.ON_OFF, this.ON_OFF_DUPLI, this);
            panel.add(cppinitvel);
            panel.setLayout(new BoxLayout(panel, 1));
            String[] thermo_spec = new String[]{"structure_evolution.temperature_control.thermostat"};
            String[] dummyArray = new String[]{""};
            TableForInputInterface thermostat_table = new TableForInputInterface(thermo_spec, this.inputInterface, this);
            JScrollPane scr_thermo = new JScrollPane();
            scr_thermo.getViewport().setView(thermostat_table.getPanel());
            scr_thermo.setPreferredSize(new Dimension(500, 75));
            JPanel pscrthermo = new JPanel();
            pscrthermo.setBorder(new TitledBorder("registered thermostats"));
            pscrthermo.add(scr_thermo);
            panel.add(pscrthermo);
            JPanel p_new_thermo = new JPanel();
            p_new_thermo.setLayout(new BoxLayout(p_new_thermo, 1));
            p_new_thermo.setBorder(new TitledBorder("new thermostat"));
            InputPanelPhase ipp_temp = new InputPanelPhase(dummyArray, this.inputInterface, "temp", 0, 10);
            InputPanelPhase ipp_qmass = new InputPanelPhase(dummyArray, this.inputInterface, "qmass", 0, 10);
            JPanel new_thermo = new JPanel();
            new_thermo.setLayout(new BoxLayout(new_thermo, 0));
            new_thermo.add(ipp_temp);
            new_thermo.add(ipp_qmass);
            p_new_thermo.add(new_thermo);
            PhaseInputPanelInterface[] phaseInputPanelInterfaceArray = new PhaseInputPanelInterface[3];
            phaseInputPanelInterfaceArray[1] = ipp_temp;
            phaseInputPanelInterfaceArray[2] = ipp_qmass;
            PhaseInputPanelInterface[] thermo_guis = phaseInputPanelInterfaceArray;
            AddButton add_hubbard = new AddButton(thermostat_table, thermo_guis, this);
            DeleteButton delete_hubbard = new DeleteButton(thermostat_table, this);
            JButton thermo_from_file = new JButton("from file");
            thermo_from_file.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MDPanel.this.fromFile("structure_evolution.temperature_control", "thermostat");
                }
            });
            JPanel thermo_btn = new JPanel();
            thermo_btn.setLayout(new BoxLayout(thermo_btn, 0));
            thermo_btn.add(add_hubbard);
            thermo_btn.add(delete_hubbard);
            thermo_btn.add(thermo_from_file);
            p_new_thermo.add(thermo_btn);
            panel.add(p_new_thermo);
            JScrollPane scr = new JScrollPane();
            String[] atmtable = new String[]{"structure.atom_list.atoms"};
            int[] nArray = new int[6];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArray[5] = 9;
            int[] map = nArray;
            this.tfii = new TableForInputInterface(atmtable, this.inputInterface, map, this);
            scr.getViewport().setView(this.tfii.getPanel());
            scr.setPreferredSize(new Dimension(500, 150));
            panel.add(scr);
            JPanel btn = new JPanel();
            JButton dismiss = new JButton("dismiss");
            dismiss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MDConfig.this.dispose();
                }
            });
            btn.add(dismiss);
            panel.add(btn);
            this.add(panel);
        }

        void exit() {
            this.inputInterface.removeInputInterfaceEntryChangeListener((InputInterfaceEntryChangeListener)((Object)this.tfii.getModel()));
        }
    }
}

