/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.input.InputWizard;
import ciss.phase_viewer.input.InputWizardController;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class BasicWizPh
extends PhaseInputItems
implements InputWizard {
    private Logger logger = Logger.getLogger((String)BasicWizPh.class.getName());
    private JPanel panel;
    protected InputInterface input;
    protected boolean isMetallic = false;
    protected boolean spin = false;
    protected AtomCoords coords;
    protected String optMethod = "cg";
    protected double defaultDeltaForce = 5.0E-4;
    protected int defaultNumBands = 0;
    protected int[] defaultKmesh = new int[]{1, 1, 1};
    protected double defaultDE = 1.0E-10;
    protected String defaultInitWF = "random_numbers";
    protected double defaultCutoffWF = 10.0;
    protected double defaultCutoffCD = 40.0;
    private JCheckBox optimize;
    private JCheckBox stress;
    private InputPanelPhase ippforce;

    @Override
    public String process() {
        InputInterfacePrimitiveEntry cond = this.input.getInputInterfacePrimitiveEntry("control.condition");
        cond.setValue("initial");
        InputInterfacePrimitiveEntry printout_basic = this.input.getInputInterfacePrimitiveEntry("printoutlevel.base");
        printout_basic.setValue("1");
        InputInterfacePrimitiveEntry printout_para = this.input.getInputInterfacePrimitiveEntry("printoutlevel.parallel_debug");
        printout_para.setValue("0");
        this.input.getInputInterfacePrimitiveEntry("phonon.sw_phonon").setValue("on");
        this.input.getInputInterfacePrimitiveEntry("phonon.sw_calc_force").setValue("on");
        this.input.getInputInterfacePrimitiveEntry("phonon.displacement").setValue("0.1");
        this.input.getInputInterfacePrimitiveEntry("phonon.sw_vibrational_modes").setValue("on");
        return "processed phonon input";
    }

    @Override
    public void setInput(Input input) {
        this.input = (InputInterface)input;
        this.setInputInterface(this.input);
    }

    @Override
    public boolean hasPrevious() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public boolean hasFinished() {
        return true;
    }

    @Override
    public String getName() {
        return "basic configuration";
    }

    @Override
    public JPanel getGUI() {
        this.createGUI();
        return this;
    }

    @Override
    public void createGUI() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.setBorder(new TitledBorder("num. bands and kmesh"));
        String[] specband = new String[]{"accuracy.num_bands"};
        InputPanelPhase numbands = new InputPanelPhase(specband, this.inputInterface, "num. bands", 0, 8, this);
        JPanel pb = new JPanel();
        pb.add(numbands);
        String[] kmeshSpec = new String[]{"accuracy.ksampling.mesh"};
        TableForInputInterface kmeshTable = new TableForInputInterface(kmeshSpec, this.inputInterface, null, this);
        kmeshTable.getModel().addTableModelListener(this);
        numbands.getTextField().setText(String.valueOf(this.defaultNumBands));
        kmeshTable.setValueAt(String.valueOf(this.defaultKmesh[0]), 0, 1);
        kmeshTable.setValueAt(String.valueOf(this.defaultKmesh[1]), 0, 2);
        kmeshTable.setValueAt(String.valueOf(this.defaultKmesh[2]), 0, 3);
        String[] kmethodSpec = new String[]{"accuracy.ksampling.method"};
        String[] kmethodChoice = new String[]{"monk", "mesh", "gamma"};
        ChoicePanelPhase cppkmethod = new ChoicePanelPhase(kmethodSpec, this.inputInterface, "method", kmethodChoice, this);
        cppkmethod.getComboBox().setSelectedIndex(0);
        JPanel ptable = new JPanel();
        ptable.setLayout(new BoxLayout(ptable, 0));
        ptable.setBorder(new TitledBorder("kmesh"));
        ptable.add(cppkmethod);
        ptable.add(kmeshTable.getPanel());
        panel1.add(pb);
        panel1.add(ptable);
        JPanel panel2 = new JPanel();
        panel2.setBorder(new TitledBorder("cutoff and convergence"));
        panel2.setLayout(new BoxLayout(panel2, 0));
        String[] wfspec = new String[]{"accuracy.cutoff_wf"};
        String[] cdspec = new String[]{"accuracy.cutoff_cd"};
        String[] convspec = new String[]{"accuracy.scf_convergence.delta_total_energy"};
        InputPanelPhase ippwf = new InputPanelPhase(wfspec, this.inputInterface, "wave function cutoff", 4, 6, this);
        InputPanelPhase ippcd = new InputPanelPhase(cdspec, this.inputInterface, "charge density cutoff", 4, 6, this);
        InputPanelPhase ippconv = new InputPanelPhase(convspec, this.inputInterface, "SCF convergence", 4, 6, this);
        ippwf.getTextField().setText(String.valueOf(this.defaultCutoffWF));
        ippcd.getTextField().setText(String.valueOf(this.defaultCutoffCD));
        ippconv.getTextField().setText(String.valueOf(this.defaultDE));
        JPanel pwf = new JPanel();
        JPanel pcd = new JPanel();
        JPanel pconv = new JPanel();
        pwf.add(ippwf);
        pcd.add(ippcd);
        pconv.add(ippconv);
        panel2.add(pwf);
        panel2.add(pcd);
        panel2.add(pconv);
        this.add(panel1);
        this.add(panel2);
    }

    @Override
    public String getDescription() {
        return "edit basic configuration";
    }

    @Override
    public void setProperties(HashMap properties) {
        try {
            this.isMetallic = new Boolean(properties.get("metallic").toString());
            this.spin = new Boolean(properties.get("spin").toString());
            this.coords = (AtomCoords)properties.get("atomcoords");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.debug((Object)("coords: " + this.coords));
        this.defaultNumBands = PhaseUtils.getDefaultNumBands(this.coords, this.isMetallic, this.spin);
        this.logger.debug((Object)("default num. bands: " + this.defaultNumBands));
        Cell newcell = null;
        if (!this.inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell_type").getValue().equalsIgnoreCase("primitive")) {
            Cell cell = this.coords.getCell(1);
            if (cell == null) {
                this.coords.convertCell(1);
            }
            cell = this.coords.getCell(1);
            double[][] dcell = cell.getDouble();
            double[][] aa = BravaisLattice.getBravaisLattice(dcell[0][0], dcell[0][1], dcell[0][2], dcell[1][0], dcell[1][1], dcell[1][2], BravaisLattice.getLatticeSystemFrom(this.inputInterface)).getPrimitiveLatticeVector();
            newcell = new Cell(aa[0], aa[1], aa[2]);
        } else {
            newcell = this.coords.getCell(0);
        }
        this.defaultKmesh = PhaseUtils.getDefaultKmesh(newcell, this.isMetallic);
        this.logger.debug((Object)("default kmesh: " + this.defaultKmesh[0] + ", " + this.defaultKmesh[1] + ", " + this.defaultKmesh[2]));
        boolean hasUSPP = PhaseUtils.hasUSPP(this.coords);
        this.defaultCutoffCD = hasUSPP ? this.defaultCutoffWF * 9.0 : this.defaultCutoffWF * 4.0;
        this.logger.debug((Object)("default cutoff, wf: " + this.defaultCutoffWF + ", cd: " + this.defaultCutoffCD));
    }

    @Override
    public void setParent(InputWizardController parent) {
    }
}

