/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.ekcal.resultsviewerpanel.parsers;

import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BandParser
extends OutputParser
implements ProgressInfo {
    private Logger logger = Logger.getLogger((String)BandParser.class.getName());
    private OutputData outDataUP;
    private OutputData outDataDOWN;
    private final String BANDKPTIN = "bandkpt.in";
    private boolean bbandkptin = false;
    private double[] b1 = new double[3];
    private double[] b2 = new double[3];
    private double[] b3 = new double[3];
    private Vector bandVectorUP = new Vector();
    private Vector bandVectorDOWN = new Vector();
    private int num_kpoints = -1;
    private int num_bands = -1;
    private int nspin = -1;
    private int numeig;
    private String fermi = "(not available)";
    private String[] idents;
    private final String K_START = "ik =";
    private final String NUM_KPOINTS = "num_kpoints";
    private final String NUM_BANDS = "num_bands";
    private final String NUM_SPIN = "nspin";
    private final String FERMI = "Fermi";
    private final String VALENCE = "Valence";
    private final String DATA_START_TAG = "=== energy_eigen_values ===";
    private boolean init_done = false;
    private String description = "";
    private double dk = 0.0;
    private double[] prev_k = new double[]{0.0, 0.0, 0.0};
    private double[] korigin = null;
    private Double dkorigin = null;
    private double dkp = 0.0;
    private boolean inData = false;

    public BandParser(String fileName) {
        super(fileName);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean parse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 24[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getCurrentMessage() {
        return null;
    }

    private void init() {
        this.bandVectorUP = new Vector();
        this.bandVectorDOWN = new Vector();
        this.description = "";
        this.prev_k = new double[]{0.0, 0.0, 0.0};
        this.korigin = null;
        this.dkorigin = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseLine(String line) {
        String[] strfermi;
        if (this.num_bands > 0 && this.nspin > 0 && !this.init_done) {
            this.idents = new String[this.num_bands + 5];
            this.idents[0] = "ik";
            this.idents[1] = "kx";
            this.idents[2] = "ky";
            this.idents[3] = "kz";
            this.idents[4] = "|k|";
            int i = 0;
            while (i < this.num_bands) {
                this.idents[5 + i] = "eig" + String.valueOf(i + 1);
                ++i;
            }
            this.init_done = true;
        }
        if ((line.startsWith("Fermi") || line.startsWith("Valence")) && (strfermi = line.split("=")) != null && strfermi.length >= 2) {
            this.fermi = strfermi[1].trim();
            this.description = String.valueOf(this.description) + line + System.getProperty("line.separator");
        }
        if (line.startsWith("num_kpoints")) {
            String[] kpts = line.split("=");
            if (kpts == null) return false;
            if (kpts.length < 2) {
                return false;
            }
            try {
                this.num_kpoints = Integer.parseInt(kpts[1].trim());
            }
            catch (Exception exc) {
                return false;
            }
            this.description = String.valueOf(this.description) + line + System.getProperty("line.separator");
        }
        if (line.startsWith("num_bands")) {
            String[] nbands = line.split("=");
            if (nbands == null) return false;
            if (nbands.length < 2) {
                return false;
            }
            try {
                this.num_bands = Integer.parseInt(nbands[1].trim());
            }
            catch (Exception exc) {
                return false;
            }
            this.description = String.valueOf(this.description) + line + System.getProperty("line.separator");
        }
        if (line.startsWith("nspin")) {
            String[] nsp = line.split("=");
            if (nsp == null) return false;
            if (nsp.length < 2) {
                return false;
            }
            try {
                this.nspin = Integer.parseInt(nsp[1].trim());
            }
            catch (Exception exc) {
                return false;
            }
            this.description = String.valueOf(this.description) + line + System.getProperty("line.separator");
        }
        if (line.startsWith("=== energy_eigen_values ===") && !this.inData) {
            this.inData = true;
            return true;
        }
        if (!this.inData) return true;
        String[] data = new String[this.num_bands + 5];
        if (!this.init_done) {
            this.logger.error((Object)"header unparsed... can't proceed");
            return false;
        }
        String[] array = line.split("\\s+");
        if (array == null) return false;
        if (array.length < 7) {
            return false;
        }
        data[0] = array[2];
        data[1] = array[4];
        data[2] = array[5];
        data[3] = array[6];
        if (this.nspin == 2) {
            data[3] = array[6].substring(0, array[6].length() - 2);
        }
        if (this.bbandkptin) {
            try {
                double dkx = Double.parseDouble(data[1].trim());
                double dky = Double.parseDouble(data[2].trim());
                double dkz = Double.parseDouble(data[3].trim());
                if (this.korigin == null) {
                    this.korigin = new double[3];
                    this.korigin[0] = dkx;
                    this.korigin[1] = dky;
                    this.korigin[2] = dkz;
                }
                double[] dkc = new double[]{this.b1[0] * (this.prev_k[0] - dkx) + this.b1[1] * (this.prev_k[1] - dky) + this.b1[2] * (this.prev_k[2] - dkz), this.b2[0] * (this.prev_k[0] - dkx) + this.b2[1] * (this.prev_k[1] - dky) + this.b2[2] * (this.prev_k[2] - dkz), this.b3[0] * (this.prev_k[0] - dkx) + this.b3[1] * (this.prev_k[1] - dky) + this.b3[2] * (this.prev_k[2] - dkz)};
                this.dk = this.dkp + Math.sqrt(Math.pow(dkc[0], 2.0) + Math.pow(dkc[1], 2.0) + Math.pow(dkc[2], 2.0));
                if (this.dkorigin == null) {
                    this.dkorigin = new Double(this.dk);
                }
                this.logger.debug((Object)("dk, dkorigin: " + this.dk + " " + this.dkorigin));
                double dkk = this.dk - this.dkorigin;
                data[4] = String.valueOf(dkk);
                this.prev_k[0] = Double.parseDouble(data[1].trim());
                this.prev_k[1] = Double.parseDouble(data[2].trim());
                this.prev_k[2] = Double.parseDouble(data[3].trim());
                this.dkp = this.dk;
            }
            catch (Exception exc) {
                this.logger.error((Object)"one of the k-points was not a number");
                exc.printStackTrace();
            }
        } else {
            data[4] = "(bvec not available)";
        }
        int count = 0;
        String eig = "";
        boolean isUp = true;
        if (array.length >= 8 && this.nspin == 2) {
            isUp = array[7].trim().equals("UP");
        }
        try {
            while ((eig = this.reader.readLine()) != null) {
                String[] eigs = eig.trim().split("\\s+");
                int i = 0;
                while (i < eigs.length) {
                    data[5 + count] = eigs[i].trim();
                    if (++count == this.num_bands) {
                        if (isUp) {
                            this.logger.debug((Object)"adding 'up'");
                            this.bandVectorUP.addElement(data);
                        } else {
                            this.logger.debug((Object)"adding 'down'");
                            this.bandVectorDOWN.addElement(data);
                        }
                        this.inData = false;
                        return true;
                    }
                    ++i;
                }
            }
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public String[] getGenericData(String key) {
        if (key.toLowerCase().startsWith("fermi")) {
            return new String[]{this.fermi};
        }
        if (key.toLowerCase().startsWith("banddata")) {
            return new String[]{String.valueOf(this.bbandkptin)};
        }
        return null;
    }
}

