/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.ekcal;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.scripting.ScriptUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class EkcalUtils {
    private static Logger logger = Logger.getLogger((String)EkcalUtils.class.getName());
    public static String BAND = "band";
    public static String DOS = "dos";
    public static String EPSILON = "uvsor-epsilon";
    public static String EKCAL = "ekcal";

    private EkcalUtils() {
    }

    public static String getScriptPath(String dir, String mode) {
        if (mode.equals(BAND)) {
            return String.valueOf(dir) + System.getProperty("file.separator") + "band_init.bsh";
        }
        if (mode.equals(DOS)) {
            return String.valueOf(dir) + System.getProperty("file.separator") + "dos_init.bsh";
        }
        if (mode.equals(EPSILON)) {
            return String.valueOf(dir) + System.getProperty("file.separator") + "eps_init.bsh";
        }
        return null;
    }

    public static void initScript(String dir, String projtype) {
        if (projtype.equals(EKCAL)) {
            URL bsh = EkcalUtils.class.getResource("/ciss/phase_viewer/plugins/projectmanipulator/ekcal/bsh/dos_init.bsh");
            File scriptFile = new File(bsh.getFile());
            String script = String.valueOf(dir) + System.getProperty("file.separator") + scriptFile.getName();
            try {
                ExternalProgramExecuter.copyBinary(scriptFile.getAbsolutePath(), script);
            }
            catch (Exception exc) {
                logger.error((Object)("failed to copy " + scriptFile.getAbsolutePath() + " to " + script));
            }
            URL bshband = EkcalUtils.class.getResource("/ciss/phase_viewer/plugins/projectmanipulator/ekcal/bsh/band_init.bsh");
            File scriptFileband = new File(bshband.getFile());
            String scriptband = String.valueOf(dir) + System.getProperty("file.separator") + scriptFileband.getName();
            try {
                ExternalProgramExecuter.copyBinary(scriptFileband.getAbsolutePath(), scriptband);
            }
            catch (Exception exc) {
                logger.error((Object)("failed to copy " + scriptFileband.getAbsolutePath() + " to " + scriptband));
            }
            new File(script).deleteOnExit();
            new File(scriptband).deleteOnExit();
        } else if (projtype.equals(EPSILON)) {
            URL bsh = EkcalUtils.class.getResource("/ciss/phase_viewer/plugins/projectmanipulator/uvsorepsilon/bsh/eps_init.bsh");
            File scriptFile = new File(bsh.getFile());
            String script = String.valueOf(dir) + System.getProperty("file.separator") + scriptFile.getName();
            try {
                ExternalProgramExecuter.copyBinary(scriptFile.getAbsolutePath(), script);
            }
            catch (Exception exc) {
                logger.error((Object)("failed to copy " + scriptFile.getAbsolutePath() + " to " + script));
            }
            new File(script).deleteOnExit();
        }
    }

    public static void runInitScript(String dir, String phaseDir, InputInterface inputInterface, String mode) {
        String scriptPath = EkcalUtils.getScriptPath(dir, mode);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("inputInterface", inputInterface);
        props.put("scriptPath", scriptPath);
        props.put("baseDir", dir);
        props.put("phaseDir", phaseDir);
        ScriptUtils.runScript(scriptPath, props);
    }

    public static void inheritHostInfo(String parentdir, Document doc) {
        Document orgDoc = XMLUtils.getDocumentFromFile(new File(String.valueOf(parentdir) + System.getProperty("file.separator") + "phase-viewer.xml"));
        if (orgDoc == null) {
            return;
        }
        try {
            Element targ;
            Element jobcont;
            Element rootElem = orgDoc.getRootElement();
            if (rootElem != null && (jobcont = rootElem.getChild("jobcontrol")) != null && (targ = jobcont.getChild("targethost")) != null) {
                Element root = doc.getRootElement();
                Element jobcontrol = new Element("jobcontrol");
                root.addContent((Content)jobcontrol);
                Element targetHost = new Element("targethost");
                List children = targ.cloneContent();
                int i = 0;
                while (i < children.size()) {
                    targetHost.addContent((Content)children.get(i));
                    ++i;
                }
                jobcontrol.addContent((Content)targetHost);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static String initializeFileNamesData(ProjectInfo projectInfo, String parent) {
        String projdir = projectInfo.getProjectDirectory();
        String relativeDir = Utils.getRelativePath(projdir, parent);
        if (!parent.endsWith(System.getProperty("file.separator"))) {
            parent = String.valueOf(parent) + System.getProperty("file.separator");
        }
        if (!relativeDir.endsWith(System.getProperty("file.separator"))) {
            relativeDir = String.valueOf(relativeDir) + System.getProperty("file.separator");
        }
        String parentfdata = String.valueOf(parent) + "file_names.data";
        String F_INP = "nfinp.data";
        if (!new File(parentfdata).exists()) {
            logger.error((Object)"parent directory does not have file_names.data");
            return F_INP;
        }
        String thisfdata = String.valueOf(projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "file_names.data";
        BufferedReader rd = null;
        PrintWriter wr = null;
        boolean foundCHGT = false;
        boolean foundOCC = false;
        boolean foundPAWcont = false;
        try {
            try {
                rd = new BufferedReader(new FileReader(parentfdata));
                wr = new PrintWriter(new BufferedWriter(new FileWriter(thisfdata)));
                String line = "";
                while ((line = rd.readLine()) != null) {
                    String fname;
                    String[] foo;
                    if (line.equals("/")) continue;
                    if (line.trim().startsWith("F_CHGT")) {
                        foundCHGT = true;
                        foo = line.split("=");
                        fname = "nfchgt.data";
                        if (foo != null && foo.length >= 2) {
                            fname = new File(foo[1].replace('\'', ' ').trim()).getName();
                        }
                        relativeDir = relativeDir.replaceAll("\\\\", "/");
                        line = "F_CHGT = '" + relativeDir + fname + "'";
                    }
                    if (line.trim().startsWith("F_OCC")) {
                        foundOCC = true;
                        foo = line.split("=");
                        fname = "occmat.data";
                        if (foo != null && foo.length >= 2) {
                            fname = new File(foo[1].replace('\'', ' ').trim()).getName();
                        }
                        relativeDir = relativeDir.replaceAll("\\\\", "/");
                        line = "F_OCCMAT = '" + relativeDir + fname + "'";
                    }
                    if (line.trim().startsWith("F_CNTN_BIN_PAW")) {
                        foundPAWcont = true;
                        foo = line.split("=");
                        fname = "continue_bin_paw.data";
                        if (foo != null && foo.length >= 2) {
                            fname = new File(foo[1].replace('\'', ' ').trim()).getName();
                        }
                        relativeDir = relativeDir.replaceAll("\\\\", "/");
                        line = "F_CNTN_BIN_PAW = '" + relativeDir + fname + "'";
                    }
                    if (line.trim().startsWith("F_POT")) {
                        foo = line.split("=");
                        fname = "";
                        String dir = "";
                        if (foo != null && foo.length >= 2) {
                            fname = new File(foo[1].replace('\'', ' ').trim()).getName();
                            dir = new File(foo[1].replace('\'', ' ').trim()).getParent();
                        }
                        String pdir = new File(String.valueOf(parent) + "/" + dir).getAbsolutePath();
                        String reldir = Utils.getRelativePath(projdir, pdir, true);
                        line = String.valueOf(foo[0]) + " = '" + reldir + System.getProperty("file.separator") + fname + "'";
                    }
                    if (line.trim().startsWith("F_INP") && (foo = line.split("=")) != null && foo.length >= 2) {
                        fname = foo[1].replace('\'', ' ').trim();
                        F_INP = new File(fname).getName();
                    }
                    wr.println(line);
                }
                if (!foundCHGT) {
                    relativeDir = relativeDir.replaceAll("\\\\", "/");
                    wr.println("F_CHGT = '" + relativeDir + "nfchgt.data'");
                }
                if (!foundOCC) {
                    relativeDir = relativeDir.replaceAll("\\\\", "/");
                    wr.println("F_OCCMAT = '" + relativeDir + "occmat.data'");
                }
                if (!foundPAWcont) {
                    relativeDir = relativeDir.replaceAll("\\\\", "/");
                    wr.println("F_CNTN_BIN_PAW = '" + relativeDir + "continue_bin_paw.data'");
                }
                wr.println("/");
            }
            catch (Exception exc) {
                exc.printStackTrace();
                try {
                    rd.close();
                    wr.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                rd.close();
                wr.close();
            }
            catch (Exception exception) {}
        }
        return F_INP;
    }

    public static boolean isPhaseDir(ProjectInfo projectInfo) {
        return projectInfo.getProjectType().equals("phase");
    }
}

