/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.ekcal;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.projectmanipulator.ekcal.EkcalUtils;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeEvent;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNodeChangeListener;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorCaller;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class EkcalInitializer
extends InternalFrameChase
implements ProjectDirBrowserNodeChangeListener,
ScriptEditorCaller {
    private Logger logger = Logger.getLogger((String)EkcalInitializer.class.getName());
    private ProjectInfo projectInfo;
    private ProjectManipulator parent;
    private ProjectDirBrowserNode node;
    private JTextField tfPath;
    private JComboBox comboType;
    private String[] types = new String[]{"dos", "band"};
    private boolean rem = true;
    private JButton ok;
    private JButton btninit;
    private JLabel msg;
    private String parentdir;
    private String F_INP = "nfinp.data";
    private InputInterface inputInterface;

    public EkcalInitializer(ProjectInfo projectInfo, ProjectManipulator parent, ProjectDirBrowserNode node) {
        super("set initial condition for ekcal", true, true, true, true, new Dimension(350, 350));
        this.projectInfo = projectInfo;
        this.parent = parent;
        this.node = node;
        this.init();
    }

    private void init() {
        EkcalUtils.initScript(this.projectInfo.getProjectDirectory(), EkcalUtils.EKCAL);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        this.tfPath = new JTextField(40);
        JPanel ppath = new JPanel();
        ppath.setBorder(new TitledBorder("parent directory"));
        ppath.setLayout(new BoxLayout(ppath, 0));
        ppath.add(this.tfPath);
        JPanel pbtns = new JPanel();
        pbtns.setLayout(new BoxLayout(pbtns, 0));
        this.msg = new JLabel("select a valid phase dir");
        this.msg.setForeground(Color.red);
        this.ok = new JButton("ok");
        this.ok.setEnabled(false);
        JPanel ppp = new JPanel();
        ppp.setLayout(new BorderLayout());
        ppp.add((Component)this.msg, "Center");
        ppp.add((Component)this.ok, "East");
        JButton cancel = new JButton("cancel");
        pbtns.add(ppp);
        pbtns.add(cancel);
        JPanel pcombo = new JPanel();
        pcombo.setBorder(new TitledBorder("initial condition"));
        this.comboType = new JComboBox<String>(this.types);
        pcombo.add(this.comboType);
        this.btninit = new JButton("edit");
        this.btninit.setEnabled(false);
        pcombo.add(this.btninit);
        ProjectDirBrowser browser = new ProjectDirBrowser("projects", new ProjectDirBrowserNodeChangeListener[]{this});
        ProjectInfo info = browser.getSelectedProject();
        if (info != null && info.getInfoType() == 2) {
            this.tfPath.setText(info.getProjectDirectory());
        }
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EkcalInitializer.this.rem = false;
                EkcalInitializer.this.dispose();
                EkcalInitializer.this.createProject();
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EkcalInitializer.this.dispose();
            }
        });
        this.btninit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EkcalInitializer.this.bootScrEditor();
            }
        });
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                if (EkcalInitializer.this.rem) {
                    ProjectBrowserUtils.remove(EkcalInitializer.this.node);
                }
            }
        });
        container.add(browser);
        container.add(ppath);
        container.add(pcombo);
        container.add(pbtns);
    }

    private void bootScrEditor() {
        ScriptEditorGUI editor = new ScriptEditorGUI(this);
    }

    @Override
    public String getScriptPath() {
        return EkcalUtils.getScriptPath(this.projectInfo.getProjectDirectory(), this.comboType.getSelectedItem().toString());
    }

    private void createProject() {
        String projdir = this.projectInfo.getProjectDirectory();
        this.parentdir = this.tfPath.getText();
        this.logger.debug((Object)("relative dir from " + projdir + " to " + this.parentdir + ":"));
        String relativeDir = Utils.getRelativePath(projdir, this.parentdir);
        if (relativeDir == null) {
            this.logger.error((Object)("invalid dir: " + this.parentdir));
        }
        this.logger.debug((Object)relativeDir);
        this.projectInfo.setParentDir(relativeDir);
        Element elem = this.projectInfo.getProjectElement();
        Element element = new Element("associated_directory");
        element.setAttribute(new Attribute("type", "parent"));
        element.setText(MyElement.encode(relativeDir));
        elem.addContent((Content)element);
        this.F_INP = EkcalUtils.initializeFileNamesData(this.projectInfo, this.parentdir);
        this.initializeInput(this.parentdir);
        this.initializeChaseXML();
        ProjectDirBrowser.saveMyProjectsDocument();
        this.node.selectMe();
        this.projectInfo.getInputDataManager().registerToFileStateObserver();
    }

    private void initializeInput(String phaseDir) {
        String curnfinp = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.F_INP;
        String phaseinp = String.valueOf(phaseDir) + System.getProperty("file.separator") + this.F_INP;
        if (!new File(phaseinp).exists()) {
            this.logger.error((Object)"input file for PHASE doesn't exist.");
            return;
        }
        try {
            ExternalProgramExecuter.copyBinary(phaseinp, curnfinp);
        }
        catch (Exception exc) {
            this.logger.error((Object)("failed to copy input file: " + phaseinp + " to " + curnfinp));
            exc.printStackTrace();
            return;
        }
        URL url = PhaseConstants.TABLESPEC;
        DataManager dm = new DataManager(curnfinp, url, false);
        dm.parse();
        this.inputInterface = dm.getInputInterface();
        EkcalUtils.runInitScript(this.projectInfo.getProjectDirectory(), phaseDir, this.inputInterface, this.comboType.getSelectedItem().toString());
    }

    private void initializeChaseXML() {
        this.logger.debug((Object)"initializing phase-viewer.xml");
        URL defchaseXML = this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/phase/phase-viewer.xml");
        Document doc = XMLUtils.getDocumentFromURL(defchaseXML);
        String projchaseXML = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "phase-viewer.xml";
        this.logger.debug((Object)("xml: " + projchaseXML));
        EkcalUtils.inheritHostInfo(this.parentdir, doc);
        XMLUtils.saveDocumentTo(doc, new File(projchaseXML));
    }

    @Override
    public void nodeSelected(ProjectDirBrowserNodeChangeEvent e) {
        if (e == null || e.getSource() == null) {
            return;
        }
        ProjectDirBrowserNode node = (ProjectDirBrowserNode)e.getSource();
        ProjectInfo proj = node.getProjectInfo();
        this.tfPath.setText(proj.getProjectDirectory());
        boolean isphase = EkcalUtils.isPhaseDir(proj);
        this.ok.setEnabled(isphase);
        this.btninit.setEnabled(isphase);
        if (isphase) {
            this.msg.setText("");
        } else {
            this.msg.setText("select a valid phase dir");
        }
    }

    @Override
    public HashMap getObjects() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String parDir = this.tfPath.getText();
        if (!parDir.endsWith(System.getProperty("file.separator"))) {
            parDir = String.valueOf(parDir) + System.getProperty("file.separator");
        }
        String nfinp = Utils.getFileName("F_INP", parDir);
        if (this.inputInterface == null) {
            URL url = PhaseConstants.TABLESPEC;
            DataManager dm = new DataManager(String.valueOf(parDir) + nfinp, url, false);
            dm.parse();
            this.inputInterface = dm.getInputInterface();
        }
        double[][] cell = PhaseUtils.getReciprocalLatticeFrom(this.inputInterface);
        map.put("projectInfo", this.projectInfo);
        map.put("inputInterface", this.inputInterface);
        map.put("reciprocalLattice", cell);
        return map;
    }
}

