/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator;

import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.jobcontrol.DefaultScriptCreator;
import ciss.phase_viewer.plugins.projectmanipulator.PhaseManipulator;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.ElemPanel;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.ProjectManipulatorSubSelector;
import java.io.File;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public abstract class ProjectManipulatorBase
extends ProjectManipulator
implements DefaultScriptCreator {
    private static Logger logger = Logger.getLogger((String)PhaseManipulator.class.getName());
    private JSplitPane splitpane;
    protected String baseDir;

    public ProjectManipulatorBase(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void recreate() {
        this.init();
    }

    @Override
    public void init() {
        this.removeAll();
        this.baseDir = this.projectInfo.getProjectDirectory();
        this.projectInfo.setDefaultScriptCreator(this);
        this.projectInfo.setProjectDescriptionURL(this.getProgramDescriptionURL());
        this.projectInfo.setStdoutGUIs(this.getStdoutGUIs());
        String chaseXML = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "phase-viewer.xml";
        File filechaseXML = new File(chaseXML);
        Document doc = XMLUtils.getDocumentFromFile(filechaseXML);
        if (doc == null) {
            URL defchaseXML = this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/phase/phase-viewer.xml");
            doc = XMLUtils.getDocumentFromURL(defchaseXML);
            File tmp = new File(this.projectInfo.getProjectDirectory());
            if (!tmp.exists() && !tmp.mkdirs()) {
                logger.error((Object)"failed to create project directory...");
                return;
            }
            String projchaseXML = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "phase-viewer.xml";
            String type = this.getType();
            Element typeElem = new Element("type").setText(type);
            doc.getRootElement().addContent((Content)typeElem);
            XMLUtils.saveDocumentTo(doc, new File(projchaseXML));
        }
        this.projectInfo.setProjectPropertyDocument(doc);
        ChaseFileManager chaseFileManager = this.getChaseFileManager();
        this.projectInfo.setChaseFileManager(chaseFileManager);
        this.setLayout(new BoxLayout(this, 1));
        this.splitpane = new JSplitPane();
        JPanel panel = new JPanel();
        ProjectManipulatorSubSelector subSelector = this.getProjectManipulatorSubSelector();
        panel.add(subSelector);
        if (subSelector.getLayoutPolicy() == 0) {
            this.splitpane.setOrientation(1);
            this.splitpane.setLeftComponent(panel);
        } else {
            this.splitpane.setOrientation(0);
            this.splitpane.setTopComponent(panel);
        }
        this.add(this.splitpane);
        ElemPanel ele = new ElemPanel(this.projectInfo);
        this.projectInfo.registerGUI(ele);
    }

    protected abstract URL getSubSelectorURL();

    private ProjectManipulatorSubSelector getProjectManipulatorSubSelector() {
        URL property = this.getSubSelectorURL();
        ProjectManipulatorSubSelector selector = new ProjectManipulatorSubSelector(property, this.projectInfo, this.splitpane);
        return selector;
    }

    protected abstract URL getProgramDescriptionURL();

    protected abstract ChaseFileManager getChaseFileManager();

    protected abstract String getType();

    protected abstract Class[] getStdoutGUIs();

    @Override
    public boolean postProcess() {
        if (this.projectInfo.getInputDataManager() != null) {
            DataManager dma = this.projectInfo.getInputDataManager();
            dma.unregisterFromFileStateObserver();
        }
        return super.postProcess();
    }
}

