/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class IntroPanel
extends ProjectManipulator {
    private static final long serialVersionUID = -5004359985536437617L;
    private Logger logger = Logger.getLogger((String)IntroPanel.class.getName());
    private Dimension labelSize = new Dimension(500, 40);
    private JTextArea comment;
    private JLabel parentPath;
    private JEditorPane jEditorPane1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public IntroPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    private void customComponents() {
        JPanel p = new JPanel();
        p.setBorder(new TitledBorder("project information"));
        p.setLayout(new BoxLayout(p, 1));
        JPanel plabel = new JPanel();
        String parentDir = this.projectInfo.getParentDir();
        plabel.setLayout(new GridLayout(3, 1));
        JLabel date = new JLabel(this.projectInfo.getDate());
        date.setPreferredSize(this.labelSize);
        date.setBorder(new TitledBorder("date of creation"));
        plabel.add(date);
        JLabel name = new JLabel(this.projectInfo.getProjectName());
        name.setPreferredSize(this.labelSize);
        name.setBorder(new TitledBorder("project name"));
        plabel.add(name);
        JPanel panelPath = new JPanel();
        JLabel path = new JLabel(this.projectInfo.getProjectDirectory());
        path.setToolTipText(this.projectInfo.getProjectDirectory());
        path.setPreferredSize(this.labelSize);
        path.setBorder(new TitledBorder("base directory"));
        panelPath.add(path);
        if (parentDir != null) {
            panelPath.setLayout(new GridLayout(1, 2));
            this.parentPath = new JLabel(parentDir);
            this.parentPath.setToolTipText(parentDir);
            JPanel parentPanel = new JPanel();
            parentPanel.setLayout(new BorderLayout());
            parentPanel.setBorder(new TitledBorder("parent directory"));
            parentPanel.add((Component)this.parentPath, "West");
            JButton btnchange = new JButton("select new parent");
            parentPanel.add((Component)btnchange, "East");
            panelPath.add(parentPanel);
            btnchange.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    IntroPanel.this.bootParentChanger();
                }
            });
        } else {
            panelPath.setLayout(new GridLayout(1, 1));
        }
        plabel.add(panelPath);
        JPanel pcomment = new JPanel();
        pcomment.setLayout(new GridLayout());
        pcomment.setBorder(new TitledBorder("comments"));
        this.comment = new JTextArea(1, 20);
        this.comment.setDragEnabled(true);
        this.comment.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                IntroPanel.this.postProcess();
            }
        });
        JScrollPane scr = new JScrollPane();
        scr.getViewport().setView(this.comment);
        pcomment.add(scr);
        p.add(plabel);
        p.add(pcomment);
        this.add(p);
    }

    private void bootParentChanger() {
        ChaseFileChooser fdlg = new ChaseFileChooser(true);
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("Open");
        fdlg.setFileSelectionMode(1);
        if (fdlg.showDialog(this, "open") != 0) {
            return;
        }
        String newParentDir = fdlg.getSelectedFile().getAbsolutePath();
        this.updateParent(newParentDir);
    }

    protected void updateParent(String newParentDir) {
    }

    @Override
    public boolean postProcess() {
        String scomm = MyElement.encode(this.comment.getText());
        Element projElement = this.projectInfo.getProjectElement();
        Element comm = projElement.getChild("comment");
        if (comm == null) {
            comm = new Element("comment");
            comm.setText(scomm);
            projElement.addContent((Content)comm);
        } else {
            comm.setText(scomm);
        }
        this.logger.debug((Object)"post process...");
        return true;
    }

    @Override
    public void recreate() {
        if (this.parentPath != null) {
            this.parentPath.setText(this.projectInfo.getParentDir());
            this.parentPath.setToolTipText(this.projectInfo.getParentDir());
        }
    }

    @Override
    public void init() {
        Element projElement;
        String comm;
        this.setLayout(new BoxLayout(this, 1));
        this.customComponents();
        this.initComponents();
        URL url = this.projectInfo.getProjectDescriptionURL();
        if (url != null) {
            ProjectBrowserUtils.setHtmlToEditorPane(this.jEditorPane1, url);
        }
        if ((comm = MyElement.decode((projElement = this.projectInfo.getProjectElement()).getChildTextTrim("comment"))) != null && comm.length() != 0) {
            this.comment.setText(comm);
        }
        String nfinp = String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + this.projectInfo.getChaseFileManager().getFile("F_INP").getFileName();
        this.logger.debug((Object)("nfinp: " + nfinp));
        URL urlspec = PhaseConstants.TABLESPEC;
        GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
        boolean obs = new Boolean(gp.getProperty("phaseinput_monitor_external_edit"));
        DataManager dm = new DataManager(nfinp, urlspec, obs);
        dm.parse();
        InputInterface inputInterface = dm.getInputInterface();
        this.projectInfo.setInputInterface(inputInterface);
        this.projectInfo.setInputDataManager(dm);
        this.logger.debug((Object)"creating elempanel...");
        this.logger.debug((Object)("projdir now: " + this.projectInfo.getProjectDirectory()));
    }

    @Override
    public void initializeProject() {
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.setLayout(new GridLayout(2, 0));
        this.setBorder(new TitledBorder(null, "Welcome to " + this.projectInfo.getProjectType() + "!", 0, 0, new Font("MS Sans Serif", 0, 11), new Color(0, 0, 153)));
        this.jPanel1.setLayout(new GridLayout());
        this.jPanel1.setBorder(new TitledBorder(null, "description", 0, 0, new Font("MS Sans Serif", 1, 12)));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        this.jPanel1.add(this.jScrollPane1);
        this.add(this.jPanel1);
    }
}

