/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.plugins.projectmanipulator.ProjectManipulatorBase;
import ciss.phase_viewer.plugins.projectmanipulator.ekcal.EkCalFileManager;
import ciss.phase_viewer.plugins.projectmanipulator.ekcal.EkcalInitializer;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.scripting.ScriptWrapper;
import java.io.File;
import java.net.URL;
import org.apache.log4j.Logger;

public class EkcalManipulator
extends ProjectManipulatorBase {
    private Logger logger = Logger.getLogger((String)EkcalManipulator.class.getName());
    private String scriptDir = String.valueOf(baseScriptDir) + "ekcal";
    private URL phaseSpec = PhaseConstants.FILEINFO_PHASE;
    private ChaseFileManager cfManager;

    public EkcalManipulator(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    protected URL getSubSelectorURL() {
        return this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/ekcal/manipulator_sub_selector_properties.xml");
    }

    @Override
    protected URL getProgramDescriptionURL() {
        return this.getClass().getResource("/ciss/phase_viewer/plugins/projectmanipulator/ekcal/intropanel/ekcal_intro.htm");
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void initializeProject(ProjectDirBrowserNode node) {
        EkcalInitializer initializer = new EkcalInitializer(this.projectInfo, this, node);
    }

    @Override
    public boolean createDefaultScript() {
        ScriptWrapper[] defaults = this.getDefaultScripts();
        int i = 0;
        while (i < defaults.length) {
            if (!new File(defaults[i].getPath()).exists()) {
                String name = new File(defaults[i].getPath()).getName();
                try {
                    ExternalProgramExecuter.copy(String.valueOf(this.scriptDir) + System.getProperty("file.separator") + name, defaults[i].getPath());
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public ScriptWrapper[] getDefaultScripts() {
        ScriptWrapper[] defaults = new ScriptWrapper[REGISTERED_SCRIPT_TYPE.length];
        String prefix = "submit.";
        String FS = System.getProperty("file.separator");
        int i = 0;
        while (i < REGISTERED_SCRIPT_TYPE.length) {
            defaults[i] = new ScriptWrapper(String.valueOf(this.baseDir) + FS + prefix + REGISTERED_SCRIPT_TYPE[i], REGISTERED_SCRIPT_TYPE[i]);
            ++i;
        }
        return defaults;
    }

    @Override
    protected ChaseFileManager getChaseFileManager() {
        this.logger.debug((Object)("at getChaseFileManager()... proj. dir : " + this.projectInfo.getProjectDirectory()));
        File fnamesData = new File(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + "file_names.data");
        if (this.cfManager == null) {
            this.cfManager = new EkCalFileManager(this.phaseSpec, fnamesData);
        }
        this.cfManager.setFileSpecFile(fnamesData);
        return this.cfManager;
    }

    @Override
    protected String getType() {
        this.getChaseFileManager();
        return this.cfManager.getName();
    }

    @Override
    protected Class[] getStdoutGUIs() {
        return null;
    }
}

