/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.graph.plotattributes;

import ciss.phase_viewer.graph.plotattributes.PlotAttributesEditor;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesSubEditor;
import ciss.phase_viewer.graph.plotattributes.PlotShapesAndLines;
import ciss.phase_viewer.graph.plotattributes.SeriesInfo;
import ciss.phase_viewer.graph.plotattributes.ShapeSample;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.StrokeSample;

public class PlotDataAttributes
extends PlotAttributesSubEditor {
    private Logger logger = Logger.getLogger((String)PlotDataAttributes.class.getName());
    private XYPlot xyplot;
    private SeriesInfo[] series;
    private JPanel thispanel;
    private String[] range;
    private JList list;
    private JButton btnplotlinecolor;
    private JComboBox comboplottype;
    private JComboBox comboplotlinetype;
    private JTextField tfplotlinewidth;
    private JComboBox comboplotshapetype;
    private JTextField tfplotshapesize;
    private JCheckBox cbapplytoall;
    private boolean apply_to_all = false;
    private int dsetCount;
    private int[] dsetIndex;

    public PlotDataAttributes(PlotAttributesEditor parent) {
        super(parent);
    }

    @Override
    public boolean updateChart() {
        if (this.series == null || this.series.length == 0) {
            return false;
        }
        this.seriesChanged();
        int i = 0;
        while (i < this.series.length) {
            if (!this.series[i].update(this.xyplot, this.dsetIndex[i], i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void init() {
        this.thispanel = this;
        if (this.parent == null) {
            this.logger.debug((Object)"'parent' is null.");
            return;
        }
        Plot plot = this.parent.getSelectedPlot();
        if (plot == null) {
            this.logger.debug((Object)"'plot' is null.");
            return;
        }
        if (!(plot instanceof XYPlot)) {
            return;
        }
        this.xyplot = (XYPlot)plot;
    }

    @Override
    protected void initGUI() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        JPanel prangetype = new JPanel();
        prangetype.setLayout(new BoxLayout(prangetype, 0));
        this.dsetCount = this.xyplot.getDatasetCount();
        Vector<String> rangeVector = new Vector<String>();
        int i = 0;
        while (i < this.dsetCount) {
            XYSeriesCollection collection = (XYSeriesCollection)this.xyplot.getDataset(i);
            int scount = collection.getSeriesCount();
            int j = 0;
            while (j < scount) {
                rangeVector.addElement(collection.getSeries(j).getKey().toString());
                ++j;
            }
            ++i;
        }
        if (rangeVector.size() != 0) {
            this.range = new String[rangeVector.size()];
            rangeVector.copyInto(this.range);
            this.dsetIndex = new int[rangeVector.size()];
            int count = 0;
            int i2 = 0;
            while (i2 < this.dsetCount) {
                XYSeriesCollection collection = (XYSeriesCollection)this.xyplot.getDataset(i2);
                int scount = collection.getSeriesCount();
                int j = 0;
                while (j < scount) {
                    this.dsetIndex[count] = i2;
                    ++count;
                    ++j;
                }
                ++i2;
            }
        } else {
            this.logger.error((Object)"could not obtain series!");
        }
        this.series = new SeriesInfo[this.range.length];
        i = 0;
        while (i < this.range.length) {
            this.series[i] = new SeriesInfo(this.xyplot, i);
            ++i;
        }
        this.list = new JList<String>(this.range);
        this.list.setSelectionMode(2);
        JScrollPane scrPane = new JScrollPane(this.list);
        scrPane.setBorder(new TitledBorder("series"));
        scrPane.setPreferredSize(new Dimension(200, 150));
        this.cbapplytoall = new JCheckBox("apply changes to all series");
        prangetype.add(scrPane);
        prangetype.add(this.cbapplytoall);
        p.add((Component)prangetype, constraints);
        String[] strplottype = new String[]{"lines", "shapes", "lines and shapes"};
        String[] plotnumber = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        JPanel pplottype = new JPanel();
        pplottype.setLayout(new BoxLayout(pplottype, 0));
        this.comboplottype = new JComboBox<String>(strplottype);
        JPanel pcomboplottype = new JPanel();
        pcomboplottype.setBorder(new TitledBorder("plot type"));
        pcomboplottype.add(this.comboplottype);
        this.btnplotlinecolor = new JButton("select");
        JPanel pbtnline = new JPanel();
        pbtnline.setBorder(new TitledBorder("color"));
        pbtnline.add(this.btnplotlinecolor);
        pplottype.add(pcomboplottype);
        pplottype.add(pbtnline);
        constraints.gridy = 1;
        p.add((Component)pplottype, constraints);
        PlotShapesAndLines psal = new PlotShapesAndLines();
        StrokeSample[] sample = new StrokeSample[psal.getNumLines()];
        int i3 = 0;
        while (i3 < psal.getNumLines()) {
            sample[i3] = new StrokeSample((Stroke)psal.getLine(i3, 1.0f));
            ++i3;
        }
        JPanel plineproperties = new JPanel();
        this.comboplotlinetype = new JComboBox<StrokeSample>(sample);
        this.comboplotlinetype.setRenderer(new StrokeSample((Stroke)new BasicStroke(1.0f)));
        JPanel pcomboplotlinetype = new JPanel();
        pcomboplotlinetype.setBorder(new TitledBorder("line type"));
        pcomboplotlinetype.add(this.comboplotlinetype);
        this.tfplotlinewidth = new JTextField(10);
        JPanel ptfline = new JPanel();
        ptfline.setBorder(new TitledBorder("line width"));
        ptfline.add(this.tfplotlinewidth);
        plineproperties.setLayout(new GridLayout(1, 3));
        plineproperties.setBorder(new TitledBorder("line properties"));
        plineproperties.add(pcomboplotlinetype);
        plineproperties.add(ptfline);
        constraints.gridy = 2;
        p.add((Component)plineproperties, constraints);
        JPanel pshapeproperties = new JPanel();
        ShapeSample[] shapesample = new ShapeSample[psal.getNumShapes()];
        int i4 = 0;
        while (i4 < shapesample.length) {
            shapesample[i4] = new ShapeSample(psal.getShape(i4, 49.0, 9.0, 10.0));
            ++i4;
        }
        this.comboplotshapetype = new JComboBox<ShapeSample>(shapesample);
        this.comboplotshapetype.setRenderer(new ShapeSample(psal.getShape(0, 49.0, 9.0, 10.0)));
        JPanel pcomboplotshapetype = new JPanel();
        pcomboplotshapetype.setBorder(new TitledBorder("shape type"));
        pcomboplotshapetype.add(this.comboplotshapetype);
        this.tfplotshapesize = new JTextField(10);
        JPanel ptf = new JPanel();
        ptf.setBorder(new TitledBorder("shape size"));
        ptf.add(this.tfplotshapesize);
        pshapeproperties.setLayout(new GridLayout(1, 3));
        pshapeproperties.setBorder(new TitledBorder("shape properties"));
        pshapeproperties.add(pcomboplotshapetype);
        pshapeproperties.add(ptf);
        constraints.gridy = 3;
        p.add((Component)pshapeproperties, constraints);
        this.add((Component)p, "North");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PlotDataAttributes.this.seriesChanged();
            }
        });
        this.cbapplytoall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotDataAttributes.this.apply_to_all = PlotDataAttributes.this.cbapplytoall.isSelected();
                PlotDataAttributes.this.seriesChanged();
            }
        });
        this.comboplottype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = PlotDataAttributes.this.list.getSelectedIndex();
                PlotDataAttributes.this.series[index].setPlotType(PlotDataAttributes.this.comboplottype.getSelectedIndex());
            }
        });
        this.btnplotlinecolor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = PlotDataAttributes.this.list.getSelectedIndex();
                Color color = JColorChooser.showDialog(PlotDataAttributes.this.thispanel, "Choose", PlotDataAttributes.this.btnplotlinecolor.getBackground());
                if (color != null) {
                    PlotDataAttributes.this.btnplotlinecolor.setBackground(color);
                    PlotDataAttributes.this.btnplotlinecolor.revalidate();
                    PlotDataAttributes.this.series[index].setColor(color);
                }
            }
        });
        this.comboplotlinetype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = PlotDataAttributes.this.list.getSelectedIndex();
                PlotDataAttributes.this.series[index].setLineType(PlotDataAttributes.this.comboplotlinetype.getSelectedIndex());
            }
        });
        this.tfplotlinewidth.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                float linewidth = 0.0f;
                try {
                    linewidth = Float.parseFloat(PlotDataAttributes.this.tfplotlinewidth.getText());
                }
                catch (NumberFormatException nfe) {
                    return;
                }
                PlotDataAttributes.this.series[PlotDataAttributes.this.list.getSelectedIndex()].setLineWidth(linewidth);
            }
        });
        this.comboplotshapetype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotDataAttributes.this.series[PlotDataAttributes.this.list.getSelectedIndex()].setShapeType(PlotDataAttributes.this.comboplotshapetype.getSelectedIndex());
            }
        });
        this.tfplotshapesize.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                double shapesize = 0.0;
                try {
                    shapesize = Double.parseDouble(PlotDataAttributes.this.tfplotshapesize.getText());
                }
                catch (NumberFormatException nfe) {
                    return;
                }
                PlotDataAttributes.this.series[PlotDataAttributes.this.list.getSelectedIndex()].setShapeSize(shapesize);
            }
        });
        this.list.setSelectedIndex(0);
        this.tfplotlinewidth.setText(String.valueOf(this.series[0].getLineWidth()));
        this.tfplotshapesize.setText(String.valueOf(this.series[0].getShapeSize()));
    }

    @Override
    public void plotChanged(Plot plot) {
        this.updateChart();
        this.init();
        this.initGUI();
        this.revalidate();
    }

    private void seriesChanged() {
        int index = this.list.getSelectedIndex();
        SeriesInfo info = this.series[index];
        this.btnplotlinecolor.setBackground(info.getColor());
        this.comboplottype.setSelectedIndex(info.getPlotType());
        this.comboplotlinetype.setSelectedIndex(info.getLineType());
        this.comboplotshapetype.setSelectedIndex(info.getShapeType());
        this.tfplotlinewidth.setText(String.valueOf(info.getLineWidth()));
        this.tfplotshapesize.setText(String.valueOf(info.getShapeSize()));
        this.doApplytoAll();
    }

    private void doApplytoAll() {
        if (this.apply_to_all) {
            int i = 0;
            while (i < this.series.length) {
                this.series[i].copy(this.series[this.list.getSelectedIndex()]);
                ++i;
            }
        } else {
            int[] indeces = this.list.getSelectedIndices();
            int ind = this.list.getSelectedIndex();
            if (indeces == null || indeces.length == 0) {
                return;
            }
            int i = 0;
            while (i < indeces.length) {
                if (ind != indeces[i]) {
                    this.series[indeces[i]].copy(this.series[ind]);
                }
                ++i;
            }
        }
    }
}

