/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.graph.plotattributes;

import ciss.phase_viewer.common.FontChooser;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesEditor;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesSubEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class AxisAttribute
extends PlotAttributesSubEditor {
    private Logger logger = Logger.getLogger((String)AxisAttribute.class.getName());
    private XYPlot xyplot;
    private int DOMAIN = 0;
    private int RANGE = 1;
    private int numdomain;
    private int numrange;
    private JTabbedPane tpaxis;

    public AxisAttribute(PlotAttributesEditor parent) {
        super(parent);
    }

    @Override
    public boolean updateChart() {
        int numaxis = this.tpaxis.getTabCount();
        int i = 0;
        while (i < numaxis) {
            this.logger.debug((Object)("updating axis number: " + i));
            ((AxisPanel)this.tpaxis.getComponentAt(i)).updateAxis();
            ++i;
        }
        return true;
    }

    @Override
    protected void init() {
        if (this.parent == null) {
            this.logger.debug((Object)"'parent' is null.");
            return;
        }
        Plot plot = this.parent.getSelectedPlot();
        if (plot == null) {
            this.logger.debug((Object)"'plot' is null.");
            return;
        }
        if (!(plot instanceof XYPlot)) {
            return;
        }
        this.xyplot = (XYPlot)plot;
        this.numdomain = this.xyplot.getDomainAxisCount();
        this.numrange = this.xyplot.getRangeAxisCount();
    }

    @Override
    protected void initGUI() {
        this.removeAll();
        this.tpaxis = new JTabbedPane();
        this.setLayout(new GridLayout());
        int i = 0;
        while (i < this.numdomain) {
            String xaxi = "x-axis";
            if (i > 0) {
                xaxi = String.valueOf(xaxi) + String.valueOf(i);
            }
            this.tpaxis.addTab(xaxi, new AxisPanel((NumberAxis)this.xyplot.getDomainAxis(i), this.DOMAIN, i));
            ++i;
        }
        i = 0;
        while (i < this.numrange) {
            String yaxi = "y-axis";
            if (i > 0) {
                yaxi = String.valueOf(yaxi) + String.valueOf(i);
            }
            this.tpaxis.addTab(yaxi, new AxisPanel((NumberAxis)this.xyplot.getRangeAxis(i), this.RANGE, i));
            ++i;
        }
        this.add(this.tpaxis);
    }

    @Override
    public void plotChanged(Plot plot) {
        this.updateChart();
        this.init();
        this.initGUI();
        this.revalidate();
    }

    class AxisPanel
    extends JPanel {
        private int mode;
        private int ID;
        private NumberAxis axis;
        private AxisPanel me;
        private JTextField taticunits;
        private JComboBox combotics;
        private JComboBox comborange;
        private JTextField tarangemin;
        private JTextField tarangemax;
        private JButton btnaxisfont;
        private JButton btnticfont;
        private JTextField taaxislabel;
        private JCheckBox cblog;
        private JCheckBox cbgrid;

        protected AxisPanel(NumberAxis axis, int mode, int ID) {
            this.mode = AxisAttribute.this.DOMAIN;
            this.mode = mode;
            this.ID = ID;
            this.me = this;
            this.axis = axis;
            this.setLayout(new BorderLayout());
            this.init();
        }

        void updateAxis() {
            if (this.comborange.getSelectedIndex() == 0) {
                this.axis.setAutoRange(true);
            } else {
                try {
                    this.axis.setAutoRange(false);
                    double min = Double.valueOf(this.tarangemin.getText());
                    double max = Double.valueOf(this.tarangemax.getText());
                    this.axis.setLowerBound(min);
                    this.axis.setUpperBound(max);
                }
                catch (NumberFormatException nfe) {
                    AxisAttribute.this.logger.error((Object)"invalid min/max specification.");
                }
            }
            if (this.combotics.getSelectedIndex() == 1) {
                this.axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                try {
                    int tic = Integer.parseInt(this.taticunits.getText());
                    this.axis.setTickUnit(new NumberTickUnit((double)tic));
                }
                catch (NumberFormatException exc) {
                    AxisAttribute.this.logger.error((Object)"invalid 'tic'");
                }
            } else if (this.combotics.getSelectedIndex() == 2) {
                try {
                    this.axis.setTickUnit(new NumberTickUnit(Double.parseDouble(this.taticunits.getText())));
                }
                catch (NumberFormatException e) {
                    AxisAttribute.this.logger.error((Object)"invalid 'tic'");
                }
            }
            this.axis.setTickLabelFont(this.btnticfont.getFont());
            if (this.cblog.isSelected()) {
                this.axis = new LogarithmicAxis(this.axis.getLabel());
                ((LogarithmicAxis)this.axis).setLog10TickLabelsFlag(true);
                XYSeriesCollection col = (XYSeriesCollection)AxisAttribute.this.xyplot.getDataset(this.ID);
                int numseries = col.getSeriesCount();
                int i = 0;
                while (i < numseries) {
                    XYSeries series = col.getSeries(i);
                    int j = 0;
                    while (j < series.getItemCount()) {
                        double x = series.getX(j).doubleValue();
                        double y = series.getY(j).doubleValue();
                        if (this.mode == AxisAttribute.this.DOMAIN) {
                            if (x == 0.0) {
                                x = 1.0E-15;
                            }
                            double newx = Math.abs(x);
                            series.remove(j);
                            series.add(newx, y);
                        } else if (this.mode == AxisAttribute.this.RANGE) {
                            if (y == 0.0) {
                                y = 1.0E-15;
                            }
                            double newy = Math.abs(y);
                            series.remove(j);
                            series.add(x, newy);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < series.getItemCount()) {
                        AxisAttribute.this.logger.debug((Object)("data no." + j + ": x = " + series.getX(j) + ", y = " + series.getY(j)));
                        ++j;
                    }
                    ++i;
                }
                if (this.mode == AxisAttribute.this.DOMAIN) {
                    AxisAttribute.this.xyplot.setDomainAxis((ValueAxis)this.axis);
                } else if (this.mode == AxisAttribute.this.RANGE) {
                    AxisAttribute.this.xyplot.setRangeAxis(this.ID, (ValueAxis)this.axis);
                }
            } else if (this.axis instanceof LogarithmicAxis) {
                this.axis = new NumberAxis(this.axis.getLabel());
                if (this.mode == AxisAttribute.this.DOMAIN) {
                    AxisAttribute.this.xyplot.setDomainAxis((ValueAxis)this.axis);
                } else if (this.mode == AxisAttribute.this.RANGE) {
                    AxisAttribute.this.xyplot.setRangeAxis(this.ID, (ValueAxis)this.axis);
                }
            }
            if (this.cbgrid.isSelected()) {
                if (this.mode == AxisAttribute.this.DOMAIN) {
                    AxisAttribute.this.xyplot.setDomainGridlinesVisible(false);
                } else if (this.mode == AxisAttribute.this.RANGE) {
                    AxisAttribute.this.xyplot.setRangeGridlinesVisible(false);
                }
            }
            String label = this.taaxislabel.getText();
            this.axis.setLabel(label);
            this.axis.setLabelFont(this.btnaxisfont.getFont());
        }

        private void init() {
            JPanel paxis = new JPanel();
            paxis.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            JPanel plabel = new JPanel();
            plabel.setLayout(new BoxLayout(plabel, 0));
            this.taaxislabel = new JTextField(25);
            this.taaxislabel.setText(this.axis.getLabel());
            Font labelfont = this.axis.getLabelFont();
            this.btnaxisfont = new JButton("select font");
            this.btnaxisfont.setFont(labelfont);
            plabel.setBorder(new TitledBorder("axis label"));
            plabel.add(this.taaxislabel);
            plabel.add(this.btnaxisfont);
            paxis.add((Component)plabel, constraints);
            JPanel ptics = new JPanel();
            ptics.setLayout(new BoxLayout(ptics, 0));
            String[] strtics = new String[]{"auto", "integer", "real"};
            this.combotics = new JComboBox<String>(strtics);
            JPanel pcombotics = new JPanel();
            pcombotics.setBorder(new TitledBorder("tic mode"));
            pcombotics.add(this.combotics);
            this.taticunits = new JTextField(20);
            this.taticunits.setText(String.valueOf(this.axis.getTickUnit().getSize()));
            JPanel ptftic = new JPanel();
            ptftic.setBorder(new TitledBorder("tick units"));
            ptftic.add(this.taticunits);
            Font ticfont = this.axis.getTickLabelFont();
            this.btnticfont = new JButton("select font");
            this.btnticfont.setFont(ticfont);
            ptics.setBorder(new TitledBorder("tics"));
            ptics.add(pcombotics);
            ptics.add(ptftic);
            ptics.add(this.btnticfont);
            constraints.gridy = 1;
            paxis.add((Component)ptics, constraints);
            String[] strrange = new String[]{"auto", "manual"};
            JPanel prange = new JPanel();
            prange.setLayout(new BoxLayout(prange, 0));
            this.comborange = new JComboBox<String>(strrange);
            JPanel pcomborange = new JPanel();
            pcomborange.setBorder(new TitledBorder("range mode"));
            pcomborange.add(this.comborange);
            this.tarangemin = new JTextField(15);
            this.tarangemin.setText(String.valueOf(this.axis.getRange().getLowerBound()));
            this.tarangemax = new JTextField(15);
            this.tarangemax.setText(String.valueOf(this.axis.getRange().getUpperBound()));
            JPanel ptfmin = new JPanel();
            ptfmin.setBorder(new TitledBorder("min value"));
            ptfmin.add(this.tarangemin);
            JPanel ptfmax = new JPanel();
            ptfmax.setBorder(new TitledBorder("max value"));
            ptfmax.add(this.tarangemax);
            prange.setBorder(new TitledBorder("range"));
            prange.add(pcomborange);
            prange.add(ptfmin);
            prange.add(ptfmax);
            constraints.gridy = 2;
            paxis.add((Component)prange, constraints);
            JPanel ploggrid = new JPanel();
            this.cblog = new JCheckBox("log scale");
            this.cbgrid = new JCheckBox("do not show grid");
            ploggrid.add(this.cblog);
            ploggrid.add(this.cbgrid);
            ploggrid.setBorder(new TitledBorder("other axis-related properties"));
            constraints.gridy = 3;
            paxis.add((Component)ploggrid, constraints);
            this.add((Component)paxis, "North");
            this.btnaxisfont.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Font font = FontChooser.chooseFont(AxisPanel.this.btnaxisfont.getFont(), AxisPanel.this.me);
                    AxisPanel.this.btnaxisfont.setFont(font);
                }
            });
            this.btnticfont.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Font font = FontChooser.chooseFont(AxisPanel.this.btnticfont.getFont(), AxisPanel.this.me);
                    AxisPanel.this.btnticfont.setFont(font);
                }
            });
            this.combotics.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AxisPanel.this.combotics.getSelectedIndex() == 0) {
                        AxisPanel.this.taticunits.setEnabled(false);
                    } else {
                        AxisPanel.this.taticunits.setEnabled(true);
                    }
                }
            });
            this.combotics.setSelectedIndex(0);
            this.comborange.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AxisPanel.this.comborange.getSelectedIndex() == 0) {
                        AxisPanel.this.tarangemax.setEnabled(false);
                        AxisPanel.this.tarangemin.setEnabled(false);
                    } else {
                        AxisPanel.this.tarangemax.setEnabled(true);
                        AxisPanel.this.tarangemin.setEnabled(true);
                    }
                }
            });
            this.comborange.setSelectedIndex(0);
        }
    }
}

