/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.fbz.edit;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.fbz.Kpoint;
import ciss.phase_viewer.acviewer.fbz.KpointGenerator;
import ciss.phase_viewer.acviewer.fbz.KpointsListener;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import ciss.phase_viewer.common.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class SymmKpointPanel
extends JPanel
implements KpointGenerator,
KpointsListener {
    private Logger logger = Logger.getLogger((String)SymmKpointPanel.class.getName());
    private FBZ fbz;
    private WignerSeitzCell wscell;
    private String bandkptin;
    private JTextField textdk;
    private JTable jTable;
    private KpointTableModel tableModel;
    private String[] columnNames = new String[]{"nx", "ny", "nz", "symbol"};
    private KpointGenerator kpointGenerator = null;

    public SymmKpointPanel(J3DPanel basePanel) {
        this.fbz = (FBZ)basePanel;
        this.wscell = this.fbz.getFBZ();
        this.init();
    }

    private void init() {
        String dir = this.fbz.getParentDirectory();
        this.bandkptin = String.valueOf(dir) + System.getProperty("file.separator") + "bandkpt.in";
        this.textdk = new JTextField("0.02");
        JPanel ptext = new JPanel();
        ptext.setLayout(new BoxLayout(ptext, 0));
        ptext.setBorder(new TitledBorder("enter dk"));
        ptext.add(this.textdk);
        this.wscell = this.fbz.getFBZ();
        this.wscell.addKPointListener(this);
        Kpoint[] initKpts = this.wscell.getSelectedKpoints();
        this.tableModel = new KpointTableModel(this.columnNames, 0);
        if (initKpts != null && initKpts.length != 0) {
            this.logger.debug((Object)"initial kpoints: ");
            int i = 0;
            while (i < initKpts.length) {
                this.logger.debug((Object)initKpts[i]);
                this.tableModel.addKpoint(initKpts[i]);
                ++i;
            }
        }
        this.jTable = new JTable(this.tableModel);
        JScrollPane scrpane = new JScrollPane(this.jTable);
        this.setLayout(new BorderLayout());
        this.add((Component)ptext, "North");
        this.add((Component)scrpane, "Center");
        this.kpointGenerator = this.fbz.getFBZData().kpointGenerator;
        if (this.kpointGenerator == null) {
            this.kpointGenerator = this;
        }
    }

    @Override
    public void saveInput(Kpoint[] kpoints, double deltak) {
        double dk = 0.02;
        if (this.kpointGenerator == this) {
            Utils.stop(this.jTable);
            this.logger.debug((Object)this.tableModel);
            try {
                dk = Double.parseDouble(this.textdk.getText().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            float[][] vec = this.fbz.getReciprocalLatticeVector();
            this.logger.debug((Object)("file: " + this.bandkptin));
            PrintWriter writer = null;
            try {
                try {
                    writer = new PrintWriter(new BufferedWriter(new FileWriter(this.bandkptin)));
                    writer.println(String.valueOf(dk));
                    writer.println(String.valueOf(String.valueOf(vec[0][0])) + "  " + String.valueOf(vec[1][0]) + "  " + String.valueOf(vec[2][0]));
                    writer.println(String.valueOf(String.valueOf(vec[0][1])) + "  " + String.valueOf(vec[1][1]) + "  " + String.valueOf(vec[2][1]));
                    writer.println(String.valueOf(String.valueOf(vec[0][2])) + "  " + String.valueOf(vec[1][2]) + "  " + String.valueOf(vec[2][2]));
                    writer.print(this.tableModel);
                }
                catch (Exception exception) {
                    writer.flush();
                    writer.close();
                }
            }
            finally {
                writer.flush();
                writer.close();
            }
        } else {
            this.kpointGenerator.saveInput(this.wscell.getSelectedKpoints(), dk);
        }
    }

    @Override
    public void generateKpoints(Kpoint[] kpoints, double dk) {
        dk = Double.parseDouble(this.textdk.getText().trim());
        if (this.kpointGenerator == this) {
            String bandkptpl = String.valueOf(System.getProperty("pviewer.home")) + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "band_kpoint.pl";
            try {
                Runtime runtime = Runtime.getRuntime();
                Process p = runtime.exec("perl " + Utils.getPathDQ(bandkptpl) + " " + Utils.getPathDQ(this.bandkptin));
                InputStream inputStream = p.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String l = "";
                while ((l = reader.readLine()) != null) {
                    this.logger.info((Object)l);
                }
                reader.close();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            String foo = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "kpoint.data";
            String kpdata = String.valueOf(this.fbz.getParentDirectory()) + System.getProperty("file.separator") + "kpoint.data";
            new File(kpdata).delete();
            new File(foo).renameTo(new File(kpdata));
        } else {
            Kpoint[] kp = this.tableModel.getKpoints();
            this.kpointGenerator.generateKpoints(kp, dk);
        }
    }

    @Override
    public void kpointsInitialized() {
        this.logger.debug((Object)"kpoints initialized");
        int i = this.tableModel.getRowCount() - 1;
        while (i >= 0) {
            this.tableModel.removeKpoint(i);
            --i;
        }
    }

    @Override
    public void kpointRemoved(Kpoint removedKPoint) {
        this.logger.debug((Object)("removed kpoint: " + removedKPoint));
        this.tableModel.removeKpoint(this.tableModel.getRowCount() - 1);
    }

    @Override
    public void kpointAdded(Kpoint addedKpoint) {
        this.logger.debug((Object)("added kpoint: " + addedKpoint));
        this.tableModel.addKpoint(addedKpoint);
    }

    @Override
    public Kpoint[] getKpointsFrom(String file) {
        return null;
    }

    class KpointTableModel
    extends DefaultTableModel {
        private Logger logger;
        private Vector kpoints;

        KpointTableModel(Object[] columnNames, int rowCount) {
            super(columnNames, rowCount);
            this.logger = Logger.getLogger((String)KpointTableModel.class.getName());
            this.kpoints = new Vector();
            this.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getColumn() == 3) {
                        int row = e.getFirstRow();
                        String sym = KpointTableModel.this.getValueAt(row, 3).toString();
                        ((Kpoint)KpointTableModel.this.kpoints.get(row)).setSymbol(sym);
                    }
                }
            });
        }

        Kpoint[] getKpoints() {
            Object[] ret = new Kpoint[this.kpoints.size()];
            this.kpoints.copyInto(ret);
            return ret;
        }

        void addKpoint(Kpoint kpoint) {
            String[] sphash = kpoint.toString().split("#");
            String[] data = sphash[0].toString().split("\\s+");
            if (data.length >= 3) {
                this.addRow(new String[]{data[0], data[1], data[2], kpoint.getSymbol()});
            }
            this.kpoints.addElement(kpoint);
        }

        void removeKpoint(int i) {
            this.removeRow(i);
            this.kpoints.remove(i);
        }

        public String toString() {
            String ret = "";
            int i = 0;
            while (i < this.kpoints.size()) {
                ret = String.valueOf(ret) + ((Kpoint)this.kpoints.get(i)).toString_bandkptpl();
                ret = String.valueOf(ret) + System.getProperty("line.separator");
                ++i;
            }
            return ret;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 3;
        }
    }
}

