/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.fbz.edit;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.fbz.KpointGenerator;
import ciss.phase_viewer.acviewer.fbz.KpointsListener;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.fbz.edit.KpointMeshPanel;
import ciss.phase_viewer.plugins.fbz.edit.SymmKpointPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import org.apache.log4j.Logger;

public class KPointPanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)KPointPanel.class.getName());
    private FBZ fbz;
    private WignerSeitzCell wscell;
    private JTabbedPane tabbedPane;

    public KPointPanel(J3DPanel parent) {
        super("kpoints", new Dimension(400, 300));
        parent.addDisposeOnExit(this);
        this.fbz = (FBZ)parent;
        this.wscell = this.fbz.getFBZ();
        this.init();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed() {
                KPointPanel.this.close();
            }
        });
        this.setVisible(true);
    }

    private void close() {
        this.wscell.removeKPointListener((KpointsListener)((Object)this.tabbedPane.getComponent(0)));
    }

    private void init() {
        SymmKpointPanel sympanel = new SymmKpointPanel(this.fbz);
        KpointMeshPanel meshpanel = new KpointMeshPanel(this.fbz);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("symm. kpoints", sympanel);
        this.tabbedPane.addTab("mesh", meshpanel);
        JButton btnsave = new JButton("to file");
        JButton btnbandkpt = new JButton("generate kpoints");
        JButton btninit = new JButton("clear");
        JButton btndismiss = new JButton("dismiss");
        JPanel pbtn = new JPanel();
        pbtn.add(btnsave);
        pbtn.add(btnbandkpt);
        pbtn.add(btninit);
        pbtn.add(btndismiss);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.tabbedPane, "Center");
        container.add((Component)pbtn, "South");
        btnsave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((KpointGenerator)((Object)KPointPanel.this.tabbedPane.getSelectedComponent())).saveInput(null, 0.2);
            }
        });
        btnbandkpt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ((KpointGenerator)((Object)KPointPanel.this.tabbedPane.getSelectedComponent())).saveInput(null, 0.2);
                    ((KpointGenerator)((Object)KPointPanel.this.tabbedPane.getSelectedComponent())).generateKpoints(null, 0.2);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
        btninit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KPointPanel.this.wscell.removeAllSymmetryLines();
            }
        });
        btndismiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                KPointPanel.this.dispose();
            }
        });
    }
}

