/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.outputinterface;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.graph.DataPanel;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class OutputInterface
implements Serializable {
    private Logger logger = Logger.getLogger((String)OutputInterface.class.getName());
    private ChaseFileManager cfManager;
    private OutputParser outputParser;
    private ProjectInfo projectInfo;
    private Vector loadedParsers = new Vector();

    public OutputInterface(ChaseFileManager cfManager) {
        this.cfManager = cfManager;
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public void setProjectInfo(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    public JPanel getDataPanel(String key) {
        if (this.createOutputParser(key)) {
            OutputData[] data;
            if (!this.outputParser.getParsed()) {
                this.outputParser.doParse();
            }
            if ((data = this.outputParser.getOutputData()) != null && data.length > 1) {
                DataPanel dataPanel = new DataPanel(data);
                return dataPanel;
            }
            if (data != null && data.length == 1) {
                DataPanel dataPanel = new DataPanel(data[0]);
                return dataPanel;
            }
        }
        return new JPanel();
    }

    public JPanel getDataPanel(String key, String fileName) {
        if (this.createOutputParser(key, fileName)) {
            if (!this.outputParser.getParsed()) {
                this.outputParser.doParse();
            }
            DataPanel dataPanel = new DataPanel(this.outputParser.getOutputData());
            return dataPanel;
        }
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 1));
        ret.add(new JPanel());
        return ret;
    }

    public OutputParser getParser(String key) {
        if (!this.createOutputParser(key)) {
            return null;
        }
        return this.outputParser;
    }

    public OutputParser getParser(String key, OutputParserListener listener) {
        if (!this.createOutputParser(key)) {
            return null;
        }
        this.outputParser.addParserListener(listener);
        return this.outputParser;
    }

    public OutputParser getParser(String key, String fname) {
        if (!this.createOutputParser(key, fname)) {
            return null;
        }
        return this.outputParser;
    }

    public OutputParser getParser(String key, String fname, OutputParserListener listener) {
        if (!this.createOutputParser(key, fname)) {
            return null;
        }
        this.outputParser.addParserListener(listener);
        return this.outputParser;
    }

    public void initCache() {
        this.loadedParsers = new Vector();
    }

    private boolean createOutputParser(String key, String fileName) {
        ChaseFile cf = this.cfManager.getFile(key);
        return this.loadParser(cf.getOutputParserPath(), fileName);
    }

    private boolean createOutputParser(String key) {
        ChaseFile cf = this.cfManager.getFile(key);
        String fname = cf.getFileName();
        String relpath = cf.getRelativePath();
        String dir = this.projectInfo.getProjectDirectory();
        String fileName = String.valueOf(dir) + System.getProperty("file.separator") + relpath + System.getProperty("file.separator") + fname;
        return this.loadParser(cf.getOutputParserPath(), fileName);
    }

    private boolean loadParser(String parserPath, String fileName) {
        int i = 0;
        while (i < this.loadedParsers.size()) {
            OutputParser parser = (OutputParser)this.loadedParsers.get(i);
            if (fileName.equals(parser.getFileName())) {
                this.logger.debug((Object)"found cached parser...");
                this.outputParser = parser;
                return true;
            }
            ++i;
        }
        this.logger.debug((Object)("loading parser: " + parserPath + "... file name is: " + fileName));
        if (parserPath == null || parserPath.length() == 0) {
            return false;
        }
        this.outputParser = (OutputParser)PluginLoader.instantiate(parserPath, new Object[]{fileName});
        if (this.outputParser == null) {
            return false;
        }
        this.outputParser.setParent(this);
        this.loadedParsers.addElement(this.outputParser);
        return true;
    }

    private boolean doParse() {
        if (this.outputParser == null) {
            return false;
        }
        new Thread(new Parse()).start();
        return true;
    }

    class Parse
    implements Runnable {
        Parse() {
        }

        @Override
        public void run() {
            OutputInterface.this.outputParser.doParse();
        }
    }
}

