/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.install;

import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.install.Installer;
import ciss.phase_viewer.settings.PropertyPanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

class InstallerPanel
extends JFrame {
    private final int FILE = 0;
    private final int DIRECTORY = 1;
    private int[] x;
    private int[] y;
    private int count;
    private String FS;
    private String osName;
    private String javapath;
    private String chaseiniini;
    private Installer installer;
    private Container container;
    private MyMessageBox mbox;
    private PropertyPanel propertyPanel;
    private Properties prop;
    private JTextField tfeditor;
    private JTextField tfgs;
    private JTextField tfemacs;
    private JTextField tfmpi;
    private JTextField tfbrowser;
    private JTextField tfBSV;
    private JButton btneditor;
    private JButton btngs;
    private JButton btnemacs;
    private JButton btnmpi;
    private JButton btnbrowser;
    private JButton btnBSV;
    private boolean mpiEnable;
    private JButton btnrc;
    private JButton btnjava;
    private JButton btnjavaopt;
    private JTextField tfrc;
    private JTextField tfjava;
    private JTextField tfjavaopt;
    private JButton btnprev;
    private JButton btnnext;
    private JButton btncancel;
    private boolean guiEnabled;
    private String chaseDir;
    private String editor;
    private String gs;
    private String browser;
    private String mpirunpath;
    private String BSV;
    private String chasedir;

    protected InstallerPanel() {
        super("Welcome to chase-3pt installer application");
        int[] nArray = new int[3];
        nArray[0] = 380;
        nArray[1] = 380;
        this.x = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 280;
        nArray2[1] = 330;
        this.y = nArray2;
        this.count = 0;
        this.FS = System.getProperty("file.separator");
        this.osName = System.getProperty("os.name");
        this.javapath = String.valueOf(System.getProperty("java.home")) + this.FS + "bin" + this.FS + "java";
        this.chaseiniini = String.valueOf(System.getProperty("user.dir")) + this.FS + "install_files" + this.FS;
        this.mbox = new MyMessageBox();
        this.prop = new Properties();
        this.tfeditor = new JTextField(20);
        this.tfgs = new JTextField(20);
        this.tfemacs = new JTextField(20);
        this.tfmpi = new JTextField(20);
        this.tfbrowser = new JTextField(20);
        this.tfBSV = new JTextField(20);
        this.btneditor = new JButton("choose...");
        this.btngs = new JButton("choose...");
        this.btnemacs = new JButton("choose...");
        this.btnmpi = new JButton("choose...");
        this.btnbrowser = new JButton("choose...");
        this.btnBSV = new JButton("chooser...");
        this.mpiEnable = true;
        this.btnrc = new JButton("choose...");
        this.btnjava = new JButton("choose...");
        this.btnjavaopt = new JButton("choose...");
        this.tfrc = new JTextField(20);
        this.tfjava = new JTextField(20);
        this.tfjavaopt = new JTextField(20);
        this.btnprev = new JButton("previous");
        this.btnnext = new JButton("next");
        this.btncancel = new JButton("cancel");
        this.guiEnabled = false;
        this.chaseDir = new File(System.getProperty("user.dir")).getParent();
        this.editor = new String();
        this.gs = new String();
        this.browser = new String();
        this.mpirunpath = new String();
        this.BSV = new String();
        this.chasedir = this.chaseDir;
        this.createInstallerGUI();
    }

    protected InstallerPanel(Installer installer) {
        super("Welcome to chase-3pt installer application");
        int[] nArray = new int[3];
        nArray[0] = 380;
        nArray[1] = 380;
        this.x = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 280;
        nArray2[1] = 330;
        this.y = nArray2;
        this.count = 0;
        this.FS = System.getProperty("file.separator");
        this.osName = System.getProperty("os.name");
        this.javapath = String.valueOf(System.getProperty("java.home")) + this.FS + "bin" + this.FS + "java";
        this.chaseiniini = String.valueOf(System.getProperty("user.dir")) + this.FS + "install_files" + this.FS;
        this.mbox = new MyMessageBox();
        this.prop = new Properties();
        this.tfeditor = new JTextField(20);
        this.tfgs = new JTextField(20);
        this.tfemacs = new JTextField(20);
        this.tfmpi = new JTextField(20);
        this.tfbrowser = new JTextField(20);
        this.tfBSV = new JTextField(20);
        this.btneditor = new JButton("choose...");
        this.btngs = new JButton("choose...");
        this.btnemacs = new JButton("choose...");
        this.btnmpi = new JButton("choose...");
        this.btnbrowser = new JButton("choose...");
        this.btnBSV = new JButton("chooser...");
        this.mpiEnable = true;
        this.btnrc = new JButton("choose...");
        this.btnjava = new JButton("choose...");
        this.btnjavaopt = new JButton("choose...");
        this.tfrc = new JTextField(20);
        this.tfjava = new JTextField(20);
        this.tfjavaopt = new JTextField(20);
        this.btnprev = new JButton("previous");
        this.btnnext = new JButton("next");
        this.btncancel = new JButton("cancel");
        this.guiEnabled = false;
        this.chaseDir = new File(System.getProperty("user.dir")).getParent();
        this.editor = new String();
        this.gs = new String();
        this.browser = new String();
        this.mpirunpath = new String();
        this.BSV = new String();
        this.chasedir = this.chaseDir;
        this.installer = installer;
        System.out.println("system: " + this.osName);
        if (this.osName.toLowerCase().trim().startsWith("windows")) {
            this.javapath = String.valueOf(this.javapath) + ".exe";
        }
        this.createInstallerGUI();
    }

    protected InstallerPanel(Installer installer, boolean guiEnabled) {
        super("Welcome to chase-3pt installer application");
        int[] nArray = new int[3];
        nArray[0] = 380;
        nArray[1] = 380;
        this.x = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 280;
        nArray2[1] = 330;
        this.y = nArray2;
        this.count = 0;
        this.FS = System.getProperty("file.separator");
        this.osName = System.getProperty("os.name");
        this.javapath = String.valueOf(System.getProperty("java.home")) + this.FS + "bin" + this.FS + "java";
        this.chaseiniini = String.valueOf(System.getProperty("user.dir")) + this.FS + "install_files" + this.FS;
        this.mbox = new MyMessageBox();
        this.prop = new Properties();
        this.tfeditor = new JTextField(20);
        this.tfgs = new JTextField(20);
        this.tfemacs = new JTextField(20);
        this.tfmpi = new JTextField(20);
        this.tfbrowser = new JTextField(20);
        this.tfBSV = new JTextField(20);
        this.btneditor = new JButton("choose...");
        this.btngs = new JButton("choose...");
        this.btnemacs = new JButton("choose...");
        this.btnmpi = new JButton("choose...");
        this.btnbrowser = new JButton("choose...");
        this.btnBSV = new JButton("chooser...");
        this.mpiEnable = true;
        this.btnrc = new JButton("choose...");
        this.btnjava = new JButton("choose...");
        this.btnjavaopt = new JButton("choose...");
        this.tfrc = new JTextField(20);
        this.tfjava = new JTextField(20);
        this.tfjavaopt = new JTextField(20);
        this.btnprev = new JButton("previous");
        this.btnnext = new JButton("next");
        this.btncancel = new JButton("cancel");
        this.guiEnabled = false;
        this.chaseDir = new File(System.getProperty("user.dir")).getParent();
        this.editor = new String();
        this.gs = new String();
        this.browser = new String();
        this.mpirunpath = new String();
        this.BSV = new String();
        this.chasedir = this.chaseDir;
        this.installer = installer;
        this.guiEnabled = guiEnabled;
        System.out.println("system: " + this.osName);
        if (this.osName.toLowerCase().trim().startsWith("windows")) {
            this.javapath = String.valueOf(this.javapath) + ".exe";
        }
        this.createInstallerGUI();
    }

    private void createInstallerGUI() {
        this.propertyPanel = new PropertyPanel();
        this.container = this.getContentPane();
        this.container.setLayout(new FlowLayout());
        this.container.add(this.createInstallOptionsPanel());
        this.container.add(this.createButtonPanel());
        this.osName = this.osName.toLowerCase().trim();
        this.chaseiniini = this.osName.startsWith("windows") ? String.valueOf(this.chaseiniini) + "phase-viewer_win32.ini" : (this.osName.startsWith("mac") ? String.valueOf(this.chaseiniini) + "phase-viewer_OSX.ini" : (this.osName.startsWith("linux") ? String.valueOf(this.chaseiniini) + "phase-viewer_linux.ini" : String.valueOf(this.chaseiniini) + "phase-viewer_generic.ini"));
        try {
            System.out.println("load property file: " + this.chaseiniini);
            this.prop.load(new FileInputStream(this.chaseiniini));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.mbox.setText("couldn't find phase-viewer.ini", !this.guiEnabled);
            this.mbox.setText("installation failed", !this.guiEnabled);
            System.exit(0);
        }
        if (this.guiEnabled) {
            this.addActionListeners();
            this.setSize(this.x[0], this.y[0]);
            this.setInitialText();
            this.setVisible(true);
            this.setDefaultCloseOperation(3);
        } else {
            this.setInitialText();
            this.count = 2;
            this.redraw();
        }
    }

    private void setInitialText() {
        this.editor = this.prop.getProperty("editor");
        if (this.editor != null) {
            this.tfeditor.setText(this.editor);
        }
        this.gs = this.prop.getProperty("gs");
        if (this.gs != null) {
            this.tfgs.setText(this.gs);
        }
        this.mpirunpath = this.prop.getProperty("mpirunpath");
        if (this.mpirunpath != null) {
            this.tfmpi.setText(this.mpirunpath);
        }
        this.browser = this.prop.getProperty("browser");
        if (this.browser != null) {
            this.tfbrowser.setText(this.browser);
        }
        this.BSV = this.prop.getProperty("BioStationViewer");
        if (this.BSV != null) {
            this.tfBSV.setText(this.BSV);
        }
        this.tfrc.setText(String.valueOf(this.chaseDir) + this.FS + "bin");
        this.tfjava.setText(this.javapath);
        this.mpiEnable = Boolean.valueOf(this.prop.getProperty("mpienable").trim());
    }

    private JPanel createInstallOptionsPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("install options"));
        p.add(this.propertyPanel.createTF(this.tfrc, this.btnrc, "rc path"));
        p.add(this.propertyPanel.createTF(this.tfjava, this.btnjava, "java path"));
        this.tfjavaopt.setPreferredSize(new Dimension(100, 27));
        p.add(this.propertyPanel.createTFonly(this.tfjavaopt, "java options (e.g. -Xmx256m)"));
        return p;
    }

    private JPanel createPanelExternal() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("external program path (you may set these later)"));
        p.add(this.propertyPanel.createTF(this.tfeditor, this.btneditor, "editor"));
        p.add(this.propertyPanel.createTF(this.tfgs, this.btngs, "gs"));
        p.add(this.propertyPanel.createTF(this.tfmpi, this.btnmpi, "mpirun"));
        if (!this.mpiEnable) {
            this.tfmpi.setEnabled(false);
            this.btnmpi.setEnabled(false);
        }
        p.add(this.propertyPanel.createTF(this.tfbrowser, this.btnbrowser, "browser"));
        return p;
    }

    private void addActionListeners() {
        this.btnnext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerPanel installerPanel = InstallerPanel.this;
                installerPanel.count = installerPanel.count + 1;
                InstallerPanel.this.redraw();
            }
        });
        this.btnprev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerPanel installerPanel = InstallerPanel.this;
                installerPanel.count = installerPanel.count - 1;
                InstallerPanel.this.redraw();
            }
        });
        this.btncancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.setVisible(false);
                InstallerPanel.this.mbox.setText("installation canceled", !InstallerPanel.this.guiEnabled);
                System.exit(0);
            }
        });
        this.btnrc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfrc, 1);
            }
        });
        this.btnjava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfjava, 0);
            }
        });
        this.btneditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfeditor, 0);
            }
        });
        this.btngs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfgs, 0);
            }
        });
        this.btnmpi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfmpi, 0);
            }
        });
        this.btnbrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfbrowser, 0);
            }
        });
        this.btnBSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfBSV, 0);
            }
        });
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        if (this.count == 0) {
            this.btnprev.setEnabled(false);
        } else {
            this.btnprev.setEnabled(true);
        }
        if (this.count == 1) {
            this.btnnext.setText("Install");
        } else {
            this.btnnext.setText("next");
        }
        p.add(this.btnprev);
        p.add(this.btnnext);
        p.add(this.btncancel);
        return p;
    }

    private void redraw() {
        this.container.removeAll();
        this.setVisible(false);
        this.setSize(this.x[this.count], this.y[this.count]);
        if (this.count == 0) {
            this.container.add(this.createInstallOptionsPanel());
            this.container.add(this.createButtonPanel());
            this.setVisible(true);
        } else if (this.count == 1) {
            this.container.add(this.createPanelExternal());
            this.container.add(this.createButtonPanel());
            this.setVisible(true);
        } else if (this.count == 2) {
            this.installer.setRC(this.tfrc.getText().trim());
            this.installer.setJava(this.tfjava.getText().trim());
            this.installer.setJavaOpts(this.tfjavaopt.getText().trim());
            this.createProp();
            this.installer.setProperties(this.prop);
            this.installer.startInstall();
        }
        if (this.count <= 0) {
            this.btnprev.setEnabled(false);
            this.count = 0;
        } else if (this.count >= 1) {
            this.btnprev.setEnabled(true);
        }
    }

    private void createProp() {
        if (this.guiEnabled) {
            this.prop.setProperty("editor", this.tfeditor.getText().trim());
            this.prop.setProperty("gs", this.tfgs.getText().trim());
            this.prop.setProperty("java", this.tfjava.getText().trim());
            this.prop.setProperty("browser", this.tfbrowser.getText().trim());
            this.prop.setProperty("mpirunpath", this.tfmpi.getText().trim());
            this.prop.setProperty("BioStationViewer", this.tfBSV.getText().trim());
            this.prop.setProperty("chasedir", this.chaseDir);
        } else {
            this.prop.setProperty("editor", this.editor);
            this.prop.setProperty("gs", this.gs);
            this.prop.setProperty("java", this.javapath);
            this.prop.setProperty("browser", this.browser);
            this.prop.setProperty("mpirunpath", this.mpirunpath);
            this.prop.setProperty("BioStationViewer", this.BSV);
            this.prop.setProperty("chasedir", this.chaseDir);
        }
        if (this.osName.toLowerCase().trim().startsWith("windows")) {
            this.prop.setProperty("taskmgr", "TASKMGR.EXE");
        }
    }

    private void bootFileChooser(JTextField tf, int mode) {
        JFileChooser fdlg = new JFileChooser();
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("choose");
        fdlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
        if (mode == 0) {
            fdlg.setFileSelectionMode(0);
        } else if (mode == 1) {
            fdlg.setFileSelectionMode(1);
        } else {
            System.out.println("wrong specification of mode");
            return;
        }
        if (fdlg.showDialog(this.container, "Select") != 0) {
            return;
        }
        tf.setText(fdlg.getSelectedFile().getAbsolutePath());
    }

    public static void main(String[] args) {
        InstallerPanel panel = new InstallerPanel();
    }
}

