/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.install;

import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.install.InstallerPanel;
import ciss.phase_viewer.install.ProgressBar;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;

public class Installer {
    private String FS = System.getProperty("file.separator");
    private String LS = System.getProperty("line.separator");
    private String PS = System.getProperty("path.separator");
    private String whiteSpace = " ";
    private String chaseRoot = new File(System.getProperty("user.dir")).getParent();
    private String chaseInstDir = String.valueOf(this.chaseRoot) + this.FS + "install" + this.FS + "install_files";
    private String binDir = String.valueOf(this.chaseRoot) + this.FS + "bin";
    private String libDir = String.valueOf(this.chaseRoot) + this.FS + "lib";
    private String progDir = String.valueOf(this.chaseRoot) + this.FS + "programs";
    private String acvOrig = String.valueOf(this.chaseInstDir) + this.FS + "acvconfig";
    private String chaseiniOrig = String.valueOf(this.chaseInstDir) + this.FS + "phase-viewer.ini";
    private String elementinfoOrig = String.valueOf(this.chaseInstDir) + this.FS + "elementinfo";
    private String sizeinfoOrig = String.valueOf(this.chaseInstDir) + this.FS + "sizeinfo";
    private String homeDir = System.getProperty("user.home");
    private String chaseDir = String.valueOf(this.homeDir) + this.FS + ".phase-viewer";
    private String templateDir = String.valueOf(this.chaseDir) + this.FS + "templates";
    private String kpointsDir = String.valueOf(this.templateDir) + this.FS + "kpoints";
    private String inputDir = String.valueOf(this.templateDir) + this.FS + "inputfiles";
    private String ppDir = String.valueOf(this.templateDir) + this.FS + "pp";
    private String templateDirOrig = String.valueOf(this.chaseInstDir) + this.FS + "templates";
    private String kpointsDirOrig = String.valueOf(this.templateDirOrig) + this.FS + "kpoints";
    private String inputDirOrig = String.valueOf(this.templateDirOrig) + this.FS + "inputfiles";
    private String ppDirOrig = String.valueOf(this.templateDirOrig) + this.FS + "pp";
    private String[] args;
    private String mode = "reinstall";
    private String scriptPath;
    private String rc;
    private Vector optVect = new Vector();
    private InstallerPanel panel;
    private MyMessageBox mbox = new MyMessageBox();
    private boolean win = false;
    private String javapath;
    private int numTasks = 0;
    private int currentTask = 0;
    private String message = new String();
    private ProgressBar progressbar;
    private JFrame frame;
    private Properties prop;
    private boolean guiEnabled = false;

    public void Installer() {
    }

    protected void initiateProgressBar() {
    }

    protected void bootGUI() {
        this.panel = new InstallerPanel(this);
    }

    protected void bootGUI(boolean guiEnabled) {
        this.guiEnabled = guiEnabled;
        this.panel = new InstallerPanel(this, guiEnabled);
    }

    protected void setArgs(String[] args) {
        this.args = args;
    }

    protected void parseArgs() {
        int i = 0;
        while (i < this.args.length) {
            StringTokenizer st = new StringTokenizer(this.args[i], "=");
            if (st.countTokens() == 2) {
                String argsi = st.nextToken().trim();
                String value = st.nextToken().trim();
                if (argsi.equalsIgnoreCase("mode") || argsi.equalsIgnoreCase("-mode")) {
                    this.mode = value;
                }
                if (argsi.equalsIgnoreCase("rc") || argsi.equalsIgnoreCase("-rc")) {
                    this.rc = value;
                }
                if (argsi.equalsIgnoreCase("java_options") || argsi.equalsIgnoreCase("-java_options")) {
                    StringTokenizer stj = new StringTokenizer(value, ",");
                    while (stj.hasMoreElements()) {
                        this.optVect.addElement(stj.nextToken());
                    }
                }
            }
            ++i;
        }
    }

    protected void setRC(String rc) {
        this.rc = rc;
        this.checkRC();
    }

    protected void setJava(String javapath) {
        this.javapath = javapath;
    }

    protected void setProperties(Properties prop) {
        this.prop = prop;
    }

    protected void setJavaOpts(String value) {
        StringTokenizer stj = new StringTokenizer(value, ",");
        while (stj.hasMoreElements()) {
            this.optVect.addElement(stj.nextToken().trim());
        }
    }

    protected String getMode() {
        return this.mode;
    }

    protected boolean checkRC() {
        boolean bret = true;
        this.scriptPath = new String();
        String scriptName = new String();
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().startsWith("windows")) {
            scriptName = "chase.bat";
            this.win = true;
        } else {
            scriptName = "chase";
        }
        this.scriptPath = this.rc != null ? String.valueOf(this.rc) + this.FS + scriptName : String.valueOf(this.binDir) + this.FS + scriptName;
        File file = new File(this.scriptPath);
        bret = file.exists();
        return bret;
    }

    protected boolean runInstaller() {
        System.out.println("*********** creating run command ***********");
        String setPath = new String();
        if (System.getProperty("os.name").toLowerCase().trim().startsWith("windows")) {
            this.progDir = this.prop.getProperty("gnuplotpath");
            setPath = "set path=" + this.prop.getProperty("chasedir") + this.FS + this.prop.getProperty("gnuplotpath") + this.FS + this.PS + this.prop.getProperty("chasedir") + this.FS + this.prop.getProperty("perlpath") + this.FS + this.PS + "%path%" + this.LS;
        } else {
            setPath = "";
        }
        this.javapath = String.valueOf(setPath) + Utils.getPathDQ(this.javapath) + this.whiteSpace;
        int i = 0;
        while (i < this.optVect.size()) {
            this.javapath = String.valueOf(this.javapath) + (String)this.optVect.get(i) + this.whiteSpace;
            ++i;
        }
        String optD = " -Djava.library.path=" + Utils.getPathDQ(this.libDir);
        this.javapath = String.valueOf(this.javapath) + optD;
        String chaseHome = " -Dpviewer.home=" + Utils.getPathDQ(this.chaseRoot);
        this.javapath = String.valueOf(this.javapath) + chaseHome;
        this.javapath = String.valueOf(this.javapath) + " -jar ";
        String binPath = Utils.getPathDQ(new File(String.valueOf(this.binDir) + this.FS + "phase-viewer.jar").getAbsolutePath());
        this.javapath = String.valueOf(this.javapath) + binPath;
        try {
            FileWriter fwriter = new FileWriter(this.scriptPath);
            BufferedWriter bwriter = new BufferedWriter(fwriter);
            bwriter.write(this.javapath, 0, this.javapath.length());
            bwriter.flush();
            fwriter.close();
            System.out.println("created " + this.scriptPath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("failed to create run command");
            return false;
        }
        if (!this.win) {
            try {
                Process process = Runtime.getRuntime().exec("chmod 744 " + Utils.getPathDQ(this.scriptPath));
                System.out.println("changed permission of: " + Utils.getPathDQ(this.scriptPath));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("failed to change permission");
            }
        }
        System.out.println("*********** saving template phase-viewer.ini ***********");
        try {
            this.prop.store(new FileOutputStream(this.chaseiniOrig), "last modification:");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mbox.setText("failed to modify " + this.chaseiniOrig, !this.guiEnabled);
            System.exit(0);
        }
        return true;
    }

    protected int getNumTasks() {
        return this.numTasks;
    }

    protected int getCurrent() {
        return this.currentTask;
    }

    protected String getMessage() {
        return this.message;
    }

    protected boolean isDone() {
        return this.currentTask == this.numTasks;
    }

    protected void startInstall() {
        if (!this.runInstaller()) {
            this.mbox.setText("failed installation ... check permission.", !this.guiEnabled);
            System.exit(0);
        } else {
            System.out.println("installation finished");
            this.mbox.setText("finished installation of chase-3pt", !this.guiEnabled);
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        Locale.setDefault(new Locale("en", "US"));
        Installer installer = new Installer();
        if (args.length == 0) {
            installer.bootGUI();
        } else if (args[0].trim().equalsIgnoreCase("-with_gui")) {
            installer.bootGUI(true);
        } else {
            installer.bootGUI();
        }
    }
}

