/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface.inputinterfacetable;

import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InputInterfaceTable
extends InputInterfaceEntry {
    private Logger logger = Logger.getLogger((String)InputInterfaceTable.class.getName());
    private String[] tableIdentifiers;
    private String[] columnIdentifiers;
    private Vector tableData = new Vector();
    private int numRows = 0;
    private int numColumns = 0;
    private Vector listeners = new Vector();
    private InputInterfaceTableColumns[] columns;
    public static int REPLACE = 0;
    public static int REMOVE = 1;
    private int lastChangeScheme = REPLACE;
    private int[] lastChangeRow = new int[]{-1};
    private Stack undoStack = new Stack();
    private int chrow = -1;
    private int changeState = REPLACE;

    public InputInterfaceTable() {
    }

    public InputInterfaceTable(String name, String[] tableIdentifiers, Vector tableData) {
        super(name);
        this.tableIdentifiers = tableIdentifiers;
        this.tableData = tableData;
    }

    public InputInterfaceTable(String name, String[] tableIdentifiers, InputInterfaceTableColumns[] columns, Vector tableData) {
        super(name);
        this.tableIdentifiers = tableIdentifiers;
        this.columns = columns;
        this.tableData = tableData;
        this.createColumnIdentifiers();
        this.fitTableDatatoSpec(tableIdentifiers);
    }

    public int lastChangedScheme() {
        return this.lastChangeScheme;
    }

    public int[] lastChangedRow() {
        return this.lastChangeRow;
    }

    public int getIndexFor(String identName) {
        String[] idents = this.getColumnIdentifiers();
        if (idents == null) {
            return -1;
        }
        int i = 0;
        while (i < idents.length) {
            if (idents[i].equalsIgnoreCase(identName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setInputInterfaceTableColumns(InputInterfaceTableColumns[] columns) {
        this.columns = columns;
        this.createColumnIdentifiers();
        this.fitTableDatatoSpec(this.tableIdentifiers);
    }

    public InputInterfaceTableColumns[] getInputInterfaceTableColumns() {
        return this.columns;
    }

    private void fitTableDatatoSpec(String[] idents) {
        if (this.columnIdentifiers == null || idents == null) {
            return;
        }
        int[] map = this.getIndexArrays(idents);
        int row = this.tableData.size();
        Vector<String[]> tmpVec = new Vector<String[]>();
        int j = 0;
        while (j < this.columnIdentifiers.length) {
            this.logger.debug((Object)(" " + this.columnIdentifiers[j]));
            ++j;
        }
        int i = 0;
        while (i < row) {
            String[] tmpString = (String[])this.tableData.elementAt(i);
            String[] fullString = new String[this.columnIdentifiers.length];
            int j2 = 0;
            while (j2 < this.columnIdentifiers.length) {
                fullString[j2] = map[j2] == -1 ? "" : tmpString[map[j2]];
                this.logger.debug((Object)(" " + fullString[j2] + " "));
                ++j2;
            }
            tmpVec.addElement(fullString);
            ++i;
        }
        this.tableData = tmpVec;
    }

    private void createColumnIdentifiers() {
        if (this.columns == null) {
            return;
        }
        Vector<String> tmpVec = new Vector<String>();
        int i = 0;
        while (i < this.columns.length) {
            if (!this.columns[i].ignoreOnSave()) {
                tmpVec.addElement(this.columns[i].getInputSpecifications());
            }
            ++i;
        }
        this.columnIdentifiers = new String[tmpVec.size()];
        i = 0;
        while (i < tmpVec.size()) {
            this.columnIdentifiers[i] = (String)tmpVec.elementAt(i);
            ++i;
        }
    }

    public String[] getColumnIdentifiers() {
        if (this.columnIdentifiers == null) {
            return this.tableIdentifiers;
        }
        return this.columnIdentifiers;
    }

    private int[] getIndexArrays(String[] ident) {
        int[] map = new int[this.columnIdentifiers.length];
        int i = 0;
        while (i < this.columnIdentifiers.length) {
            map[i] = -1;
            int j = 0;
            while (j < ident.length) {
                if (this.columnIdentifiers[i].equalsIgnoreCase(ident[j])) {
                    map[i] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return map;
    }

    @Override
    public int getEntryType() {
        return 1;
    }

    public void setTableIdentifiers(String[] tableIdentifiers) {
        if (tableIdentifiers == null) {
            return;
        }
        this.tableIdentifiers = tableIdentifiers;
        this.setNumColumns(tableIdentifiers.length);
    }

    public void removeTableDataRow(int indexfrom, int indexto) {
        if (indexto < indexfrom) {
            return;
        }
        this.lastChangeRow = new int[indexto - indexfrom];
        int i = indexfrom;
        while (i < indexto + 1) {
            try {
                this.tableData.remove(i);
                this.tableData.trimToSize();
                this.lastChangeRow[i] = i;
                this.lastChangeScheme = REMOVE;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void removeAll() {
        this.tableData = new Vector();
    }

    public void replaceTableDataRow(String[] idents, String[] rowData, int rowIndex) {
        if (this.columnIdentifiers == null || idents == null || rowData == null) {
            return;
        }
        int[] map = this.getIndexArrays(idents);
        String[] fulldat = new String[this.columnIdentifiers.length];
        String[] orig = null;
        if (rowIndex < this.tableData.size()) {
            orig = (String[])this.tableData.elementAt(rowIndex);
        }
        int j = 0;
        while (j < this.columnIdentifiers.length) {
            fulldat[j] = map[j] == -1 ? (orig == null ? "" : orig[j]) : rowData[map[j]];
            ++j;
        }
        this.replaceTableDataRow(fulldat, rowIndex);
    }

    public void replaceTableDataRow(String[] rowData, int rowIndex) {
        this.logger.debug((Object)"at replaceTableDataRow");
        this.logger.debug((Object)("size of tableData: " + this.tableData.size()));
        if (rowIndex + 1 > this.tableData.size()) {
            this.tableData.add(rowData);
        } else {
            this.tableData.set(rowIndex, rowData);
        }
        this.lastChangeRow = new int[1];
        this.lastChangeRow[0] = rowIndex;
        this.lastChangeScheme = REPLACE;
        this.logger.debug((Object)("last changed row is: " + this.tableData.size()));
    }

    public void insertTableDataRow(String[] idents, String[] rowData, int rowIndex) {
        if (this.columnIdentifiers == null || idents == null || rowData == null) {
            return;
        }
        int[] map = this.getIndexArrays(idents);
        String[] fulldat = new String[this.columnIdentifiers.length];
        String[] orig = null;
        if (rowIndex < this.tableData.size()) {
            orig = (String[])this.tableData.elementAt(rowIndex);
        }
        int j = 0;
        while (j < this.columnIdentifiers.length) {
            fulldat[j] = map[j] == -1 ? (orig == null ? "" : orig[j]) : rowData[map[j]];
            ++j;
        }
        this.insertTableDataRow(fulldat, rowIndex);
    }

    public void insertTableDataRow(String[] rowData, int rowIndex) {
        if (rowIndex + 1 > this.tableData.size()) {
            this.tableData.add(rowData);
        } else {
            this.tableData.add(rowIndex, rowData);
        }
    }

    public String[] getTableIdentifiers() {
        return this.tableIdentifiers;
    }

    public Vector getTableData() {
        return this.tableData;
    }

    private void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    private void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public boolean[] getValidColumns() {
        String[] testidents = this.columnIdentifiers;
        if (this.columnIdentifiers == null || this.columnIdentifiers.length == 0) {
            testidents = this.tableIdentifiers;
        }
        boolean[] test2 = new boolean[testidents.length];
        int i = 0;
        while (i < testidents.length) {
            test2[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.tableData.size()) {
            String[] foo = (String[])this.tableData.elementAt(i);
            if (foo != null) {
                int j = 0;
                while (j < foo.length) {
                    if (foo[j] != null && foo[j].trim().length() != 0 && j <= test2.length - 1) {
                        test2[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return test2;
    }

    public void initializeData() {
        this.tableData = new Vector();
    }

    @Override
    public boolean equals(InputInterfaceEntry entry) {
        return false;
    }

    public void setWillChangeRow(int ind, int changeState) {
        this.chrow = ind;
        this.changeState = changeState;
    }

    private void pushDummyRow(int chrow) {
        String[] dummy = new String[this.columnIdentifiers.length];
        int i = 0;
        while (i < dummy.length) {
            dummy[i] = "";
            ++i;
        }
        RowState rowState = new RowState(dummy, this.columnIdentifiers, chrow);
        this.undoStack.push(rowState);
        this.replaceTableDataRow(this.columnIdentifiers, dummy, chrow);
    }

    @Override
    public void saveState() {
        if (this.chrow < 0) {
            return;
        }
        this.logger.debug((Object)("row no. " + this.chrow));
        if (this.chrow >= this.tableData.size()) {
            this.pushDummyRow(this.chrow);
            return;
        }
        String[] rowdata = (String[])this.tableData.elementAt(this.chrow);
        if (rowdata == null) {
            this.pushDummyRow(this.chrow);
            return;
        }
        String[] browdata = new String[rowdata.length];
        int j = 0;
        while (j < rowdata.length) {
            this.logger.debug((Object)("saving state...: " + rowdata[j]));
            if (rowdata[j] != null) {
                browdata[j] = new String(rowdata[j]);
            }
            ++j;
        }
        RowState rowState = new RowState(browdata, this.columnIdentifiers, this.chrow, this.changeState);
        this.undoStack.push(rowState);
    }

    public boolean undoEachColumns() {
        if (this.columns == null || this.columns[0] == null || this.columns[0].getTableSpec() == null) {
            return true;
        }
        return this.columns[0].getTableSpec().undoEachColumns();
    }

    @Override
    public void undo() {
        RowState st;
        if (this.undoStack.empty()) {
            this.logger.info((Object)"stack empty.");
            return;
        }
        this.logger.debug((Object)"at InputInterfaceTable.undo()");
        RowState state = (RowState)this.undoStack.pop();
        int ind = state.getIndex();
        String[] row = state.getRowData();
        String[] iden = state.getIdentifer();
        int i = 0;
        while (i < row.length) {
            this.logger.debug((Object)("at undo: " + row[i]));
            ++i;
        }
        if (ind >= this.tableData.size()) {
            ind = this.tableData.size() - 1;
        }
        this.redoStack.push(state);
        if (state.getState() == REMOVE) {
            this.insertTableDataRow(iden, row, ind);
        } else {
            this.replaceTableDataRow(iden, row, ind);
        }
        if (!this.undoStack.empty() && this.columns != null && !this.undoEachColumns() && (st = (RowState)this.undoStack.peek()).getIndex() == ind) {
            this.undo();
        }
    }

    @Override
    public void redo() {
        RowState st;
        if (this.redoStack.empty()) {
            this.logger.info((Object)"stack empty.");
            return;
        }
        this.logger.debug((Object)"at InputInterfaceTable.redo()");
        RowState state = (RowState)this.redoStack.pop();
        int ind = state.getIndex();
        String[] row = state.getRowData();
        String[] iden = state.getIdentifer();
        int i = 0;
        while (i < row.length) {
            this.logger.debug((Object)("at redo: " + row[i]));
            ++i;
        }
        if (ind >= this.tableData.size()) {
            ind = this.tableData.size() - 1;
        }
        this.undoStack.push(state);
        this.replaceTableDataRow(iden, row, ind);
        if (!this.redoStack.empty() && !this.columns[0].getTableSpec().undoEachColumns() && (st = (RowState)this.redoStack.peek()).getIndex() == ind) {
            this.redo();
        }
    }

    public static boolean isValidRow(String[] foo) {
        if (foo == null) {
            return false;
        }
        int i = 0;
        while (i < foo.length) {
            if (foo[i] != null && foo[i].trim().length() != 0 && !foo[i].trim().equals("*")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class RowState {
        private String[] row;
        private String[] idents;
        private int index;
        private int state = REPLACE;

        RowState(String[] row, String[] idents, int index) {
            this.row = row;
            this.idents = idents;
            this.index = index;
        }

        RowState(String[] row, String[] idents, int index, int state) {
            this.row = row;
            this.idents = idents;
            this.index = index;
            this.state = state;
        }

        int getIndex() {
            return this.index;
        }

        String[] getRowData() {
            return this.row;
        }

        String[] getIdentifer() {
            return this.idents;
        }

        int getState() {
            return this.state;
        }
    }
}

