/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface;

import ciss.phase_viewer.inputinterface.InputInterfaceData;
import java.io.Serializable;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class InputInterfaceBlock
extends LinkedList
implements InputInterfaceData,
Serializable {
    private Logger logger = Logger.getLogger((String)InputInterfaceBlock.class.getName());
    private String name = new String();
    private boolean table = false;
    private boolean defaultUnits = false;
    private boolean defaultValues = false;
    private String fullName;

    public InputInterfaceBlock() {
    }

    public InputInterfaceBlock(String name) {
        this.name = name;
    }

    public InputInterfaceBlock(String name, String fullName) {
        this.name = name;
        this.fullName = fullName;
    }

    protected void init(String name) {
        this.clear();
        this.add(null);
        this.setName(name);
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    public boolean hasTable() {
        return this.table;
    }

    public boolean hasDefaults() {
        return this.defaultValues;
    }

    public boolean hasUnits() {
        return this.defaultUnits;
    }

    protected void setHasTable(boolean table) {
        this.table = table;
    }

    protected void setHasDefaults(boolean defaultValues) {
        this.defaultValues = defaultValues;
    }

    protected void setHasUnits(boolean defaultUnits) {
        this.defaultUnits = defaultUnits;
    }

    @Override
    public String toString() {
        return "blockName: " + this.name + " fullname: " + this.getFullName();
    }

    public void scan() {
        int i = 1;
        while (i < this.size()) {
            InputInterfaceData data = (InputInterfaceData)this.get(i);
            this.logger.info((Object)data);
            if (data.isBlock()) {
                ((InputInterfaceBlock)data).scan();
            }
            ++i;
        }
    }
}

