/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.imageviewer;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.imageviewer.MainPanel;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.io.BufferedReader;
import java.io.File;
import org.apache.log4j.Logger;

public class ImageViewerBooter
implements Runnable {
    private Logger logger = Logger.getLogger((String)ImageViewerBooter.class.getName());
    private int res = 150;
    private int pageNum;
    private String[] files;

    public ImageViewerBooter(String file) {
        this.files = new String[]{file};
    }

    public ImageViewerBooter(String[] files) {
        this.files = files;
    }

    public ImageViewerBooter(int res, String[] files) {
        this.res = res;
        this.files = files;
    }

    @Override
    public void run() {
        if (this.files == null || this.files.length == 0) {
            this.logger.info((Object)"no files selected");
            return;
        }
        GlobalProperties gp = PropertiesManager.getGlobalProperties(0);
        try {
            this.res = Integer.parseInt(gp.getProperty("image_viewer_default_resolution"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int i = 0;
            while (i < this.files.length) {
                String infileName = this.files[i];
                String[] pageArray = null;
                String originalName = infileName;
                if (infileName.toLowerCase().trim().endsWith(".eps") || infileName.toLowerCase().trim().endsWith(".ps") || infileName.toLowerCase().trim().endsWith(".pdf")) {
                    pageArray = this.getTemporaryImageFile(infileName);
                    if (pageArray != null && pageArray.length != 0) {
                        infileName = pageArray[0];
                    } else {
                        this.logger.error((Object)"invalid ps/eps/pdf file");
                        return;
                    }
                }
                if (!new File(infileName).exists()) {
                    this.logger.error((Object)"file does not exist!");
                } else {
                    MainPanel mp = new MainPanel(infileName, originalName);
                    if (mp.getStatus()) {
                        mp.setPageNum(this.pageNum);
                        this.pageNum = 0;
                        if (pageArray != null) {
                            mp.setPageArray(pageArray);
                        }
                        mp.display();
                        mp.requestFocus();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"failed to boot image viewer");
        }
    }

    public String[] getTemporaryImageFile(String infileName) {
        String FS = System.getProperty("file.separator");
        File infileFile = new File(infileName);
        String fileName = infileFile.getName();
        String tmpDir = String.valueOf(System.getProperty("user.home")) + FS + ".phase-viewer";
        String imageFile = String.valueOf(tmpDir) + FS + fileName;
        String imageFileIn = Utils.getPathDQ(String.valueOf(imageFile) + "%d.png");
        infileName = Utils.getPathDQ(infileName);
        String epsCrop = "";
        if (fileName.trim().toLowerCase().endsWith(".eps")) {
            epsCrop = "-dEPSCrop";
        }
        String gs = PropertiesManager.getGlobalProperties(0).getProperty("gs");
        String gsExe = String.valueOf(Utils.getPathDQ(gs)) + " -q -dNOPROMPT -dBATCH -sDEVICE=png16m -r" + this.res + " " + epsCrop + " -dNOPAUSE -sOutputFile=" + imageFileIn + " " + infileName;
        this.logger.info((Object)("gsexe: " + gsExe));
        BufferedReader[] br = new BufferedReader[2];
        try {
            br = ExternalProgramExecuter.executeGetBR(gsExe, true);
            br[0].close();
            br[1].close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (true) {
            ++this.pageNum;
            File pageFile = new File(String.valueOf(imageFile) + this.pageNum + ".png");
            if (!pageFile.exists()) break;
            pageFile.deleteOnExit();
        }
        --this.pageNum;
        this.logger.info((Object)("number of pages: " + this.pageNum));
        String[] tmpImageFiles = new String[this.pageNum];
        int i = 0;
        while (i < this.pageNum) {
            int ii = i + 1;
            tmpImageFiles[i] = String.valueOf(imageFile) + ii + ".png";
            ++i;
        }
        return tmpImageFiles;
    }

    public static boolean isImageFile(String name) {
        String lower = name.toLowerCase();
        return lower.endsWith(".jpg") || lower.endsWith(".jpeg") || lower.endsWith(".png") || lower.endsWith(".eps") || lower.endsWith(".ps") || lower.endsWith(".pdf") || lower.endsWith(".gif") || lower.endsWith(".tif") || lower.endsWith(".tiff") || lower.endsWith(".bmp");
    }
}

