/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.dataset;

import ciss.phase_viewer.graph.dataset.DataSet;
import ciss.phase_viewer.graph.dataset.DataSetElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DataSetImporter {
    private Logger logger = Logger.getLogger((String)DataSetImporter.class.getName());
    private DataSet dset;
    private String fileName;
    private String HASH = "#";
    private Vector dataVector = new Vector();

    public DataSetImporter(String fileName) {
        this.fileName = fileName;
        this.dset = new DataSet(new File(fileName).getName());
        this.dset.setFileName(fileName);
        this.doImport();
    }

    private void doImport() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.fileName));
            String firstLine = reader.readLine().trim();
            String[] idents = null;
            if (firstLine.startsWith(this.HASH) && firstLine.length() > 1) {
                String hoge = firstLine.trim().substring(1, firstLine.length());
                String[] foo = firstLine.split(this.HASH);
                if (foo != null && foo.length != 0) {
                    idents = hoge.trim().split("\\s+");
                }
            }
            if (idents == null) {
                this.logger.debug((Object)"null identifier");
                reader = new BufferedReader(new FileReader(this.fileName));
            }
            String line = "";
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                this.parseLine(line);
            }
            if (this.dataVector.size() == 0) {
                return;
            }
            try {
                if (idents == null) {
                    int ncol = ((String[])this.dataVector.elementAt(0)).length;
                    idents = new String[ncol];
                    String elem = "element";
                    int i = 0;
                    while (i < ncol) {
                        idents[i] = String.valueOf(elem) + String.valueOf(i);
                        ++i;
                    }
                }
                String[][] data = new String[idents.length][this.dataVector.size()];
                int i = 0;
                while (i < this.dataVector.size()) {
                    String[] row = (String[])this.dataVector.elementAt(i);
                    int numcol = row.length;
                    if (numcol > idents.length) {
                        numcol = idents.length;
                    }
                    int j = 0;
                    while (j < numcol) {
                        data[j][i] = row[j];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < idents.length) {
                    DataSetElement dse = new DataSetElement(data[i], idents[i], this.dset);
                    this.dset.addData(dse);
                    ++i;
                }
                this.logger.info((Object)("finishied import of dataset from file: " + this.fileName));
            }
            catch (IOException ioe) {
                this.logger.error((Object)("encountered error during import of file: " + this.fileName));
                ioe.printStackTrace();
                this.dset = null;
                return;
            }
            catch (ArrayIndexOutOfBoundsException aoi) {
                this.dset = null;
                this.logger.error((Object)"inconsistent data");
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void parseLine(String line) {
        String[] array = line.split("\\s+");
        if (array == null || array.length == 0) {
            array = line.split(",");
        }
        if (array == null || array.length == 0) {
            return;
        }
        int i = 0;
        while (i < array.length) {
            try {
                Double.parseDouble(array[i]);
            }
            catch (NumberFormatException nfe) {
                return;
            }
            ++i;
        }
        this.dataVector.addElement(array);
    }

    public DataSet getDataSet() {
        return this.dset;
    }
}

