/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.graph.GraphPanel;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

public class MainPanel
extends InternalFrameChase {
    public static final int FILE_MANUAL = 0;
    public static final int FILE_AUTOMATIC = 1;
    public static final String SHARP = "#";
    public static final String SHARP_BIKKURI = "#!";
    private final int MANUAL = 0;
    private final int AUTO = 1;
    private Container cont;
    private JDesktopPane desktop = Desk.getDesktop();
    private JTable table_for_data;
    private JPanel pprojdir;
    private JPanel pheader;
    private JPanel pdata;
    private JPanel pbutton;
    private JButton btndel;
    private JButton btnload;
    private JButton btntoggle;
    private JButton btnplot;
    private JButton btnsavedata;
    private JButton btnclose;
    private JComboBox comboplottypes;
    private JTextArea taprojdir;
    private JTextArea taheader;
    private JScrollPane spheader;
    private JScrollPane spdata;
    private int width = 500;
    private int height = 670;
    private int mode = 0;
    private int dataLabel = 0;
    private DefaultTableModel dtm;
    private JTabbedPane tpdata = new JTabbedPane();
    private String[] plottypes = new String[]{"xy", "pie"};
    private Vector vdirectory = new Vector();
    private Vector vfilename = new Vector();
    private Vector vnumRows = new Vector();
    private Vector vnumCols = new Vector();
    private Vector vnumIdent = new Vector();
    private Vector vtabs = new Vector();
    private Vector vtable = new Vector();
    private Vector vtableMod = new Vector();
    private Vector vcolName = new Vector();
    private Vector vheader = new Vector();
    private Vector vdata = new Vector();
    private Vector vtable_for_data = new Vector();
    private String[] strusing = new String[]{"ignore", "x", "y"};
    private String[] filename;
    private GraphPanel graphpanel;
    private String projdir;
    private boolean selectionMode = false;

    public MainPanel() {
        super("graph tool", true, true, true, true);
        this.createMainPanel();
    }

    public void display() {
        this.setVisible(true);
    }

    private void createMainPanel() {
        this.setSize(this.width, this.height);
        this.setVisible(false);
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.cont.add(this.createProjDirTextArea());
        this.cont.add(this.createHeaderPanel());
        this.cont.add(this.createDataPanel());
        this.cont.add(this.createButtonPanel());
    }

    private JPanel createProjDirTextArea() {
        JPanel p = new JPanel();
        this.taprojdir = new JTextArea();
        this.taprojdir.setPreferredSize(new Dimension((int)((double)this.width * 0.9), 20));
        p.add(this.taprojdir);
        p.setBorder(new TitledBorder("directory"));
        return p;
    }

    private JScrollPane createHeaderPanel() {
        JPanel p = new JPanel();
        this.taheader = new JTextArea();
        this.taheader.setEditable(false);
        this.spheader = new JScrollPane(this.taheader);
        this.spheader.setPreferredSize(new Dimension((int)((double)this.width * 0.9), 80));
        this.spheader.setBorder(new TitledBorder("header"));
        return this.spheader;
    }

    private JScrollPane createDataPanel() {
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension((int)((double)this.width * 0.9), 350));
        p.setLayout(new BoxLayout(p, 0));
        if (this.dataLabel == 0) {
            this.tpdata.setVisible(false);
        } else {
            this.tpdata.setVisible(true);
        }
        this.tpdata.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainPanel.this.setHeaderInfo();
            }
        });
        p.add(this.tpdata);
        this.spdata = new JScrollPane(p);
        this.spdata.setBorder(new TitledBorder("data"));
        return this.spdata;
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setPreferredSize(new Dimension((int)((double)this.width * 0.9), 50));
        this.btnplot = new JButton("plot");
        this.comboplottypes = new JComboBox<String>(this.plottypes);
        this.btnload = new JButton("load data");
        this.btntoggle = new JButton("toggle selection mode");
        this.btndel = new JButton("delete data");
        this.btnsavedata = new JButton("save data");
        this.btnclose = new JButton("close");
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new BoxLayout(pbtn, 1));
        JPanel pplot = new JPanel();
        pplot.setLayout(new BoxLayout(pplot, 0));
        pplot.add(this.btntoggle);
        pplot.add(this.btnplot);
        pplot.add(this.comboplottypes);
        pbtn.add(pplot);
        JPanel pfile = new JPanel();
        pfile.setLayout(new BoxLayout(pfile, 0));
        pfile.add(this.btnload);
        pfile.add(this.btndel);
        pfile.add(this.btnsavedata);
        pfile.add(this.btnclose);
        pbtn.add(pfile);
        p.add(pbtn);
        this.btnplot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainPanel.this.plotData() == -1) {
                    System.out.println("plot failed.");
                }
            }
        });
        this.btntoggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable jtable = (JTable)MainPanel.this.vtable.get(MainPanel.this.tpdata.getSelectedIndex());
                MainPanel.this.selectionMode = !jtable.getRowSelectionAllowed();
                jtable.setRowSelectionAllowed(MainPanel.this.selectionMode);
            }
        });
        this.btnload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.loadData(0);
            }
        });
        this.btndel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.deleteData();
            }
        });
        this.btnsavedata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.saveData();
            }
        });
        this.btnclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel.this.dispose();
            }
        });
        return p;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setvFileName(Vector vfilename) {
        this.vfilename = vfilename;
    }

    public void setvDirectory(Vector vdirectory) {
        this.vdirectory = vdirectory;
    }

    public void setvNumRows(Vector vnumRows) {
        this.vnumRows = vnumRows;
    }

    public void setvNumCols(Vector vnumCols) {
        this.vnumCols = vnumCols;
    }

    public void setvNumIdent(Vector vnumIdent) {
        this.vnumIdent = vnumIdent;
    }

    public void setvColName(Vector vcolName) {
        this.vcolName = vcolName;
    }

    public void setvData(Vector vdata) {
        this.vdata = vdata;
    }

    public void setvHeader(Vector vheader) {
        this.vheader = vheader;
    }

    public void loadData_AUTO() {
        if (this.mode == 0) {
            System.out.println("error: mode must be FILE_AUTOMATIC");
        }
        try {
            int numFiles = this.vfilename.size();
            int i = 0;
            while (i < numFiles) {
                this.loadData(1);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("invalid filename(s)");
            System.out.println(e);
        }
    }

    private void setHeaderInfo() {
        if (this.tpdata.getSelectedIndex() >= 0) {
            this.taheader.setText((String)this.vheader.get(this.tpdata.getSelectedIndex()));
            this.taprojdir.setText((String)this.vdirectory.get(this.tpdata.getSelectedIndex()));
        } else {
            this.taheader.setText(null);
            this.taprojdir.setText(null);
        }
    }

    private void loadData(int readmode) {
        if (readmode == 0) {
            ChaseFileChooser fdlg = new ChaseFileChooser("graph");
            fdlg.setDialogType(2);
            fdlg.setDialogTitle("Open");
            fdlg.setFileSelectionMode(0);
            if (fdlg.showDialog(this.cont, "open") != 0) {
                return;
            }
            String datafile = fdlg.getSelectedFile().getAbsolutePath();
            File file = new File(datafile);
            this.vdirectory.addElement(file.getParent());
            this.vfilename.addElement(file.getName());
            this.readData(file);
            this.loadDataBase();
        } else if (readmode == 1) {
            this.loadDataBase();
        }
    }

    private void loadDataBase() {
        ++this.dataLabel;
        int numCols = (Integer)this.vnumCols.get(this.dataLabel - 1);
        int numRows = (Integer)this.vnumRows.get(this.dataLabel - 1);
        int numIdent = (Integer)this.vnumIdent.get(this.dataLabel - 1);
        Vector veccol = (Vector)this.vcolName.get(this.dataLabel - 1);
        String[] colName = new String[numCols];
        int i = 0;
        while (i < numCols) {
            colName[i] = i < numIdent ? (String)veccol.get(i) : "";
            ++i;
        }
        Vector vectab = (Vector)this.vdata.get(this.dataLabel - 1);
        String[][] data = new String[numRows][numCols];
        i = 0;
        while (i < numRows) {
            Vector vcol = (Vector)vectab.get(i);
            int j = 0;
            while (j < numCols) {
                data[i][j] = (String)vcol.get(j);
                ++j;
            }
            ++i;
        }
        this.vtable.addElement(this.createDataTable(data, colName));
        JScrollPane jscrp = new JScrollPane((JTable)this.vtable.get(this.dataLabel - 1));
        this.tpdata.add((String)this.vfilename.get(this.dataLabel - 1), jscrp);
        this.tpdata.setSelectedIndex(this.dataLabel - 1);
        if (this.dataLabel == 0) {
            this.tpdata.setVisible(false);
        } else {
            this.tpdata.setVisible(true);
        }
    }

    private void readData(File file) {
        boolean i = false;
        int numident = 0;
        int numrow = 0;
        int numcol = 0;
        int numhead = 0;
        String strheader = new String();
        Vector<String> vcolNameColumn = new Vector<String>();
        Vector<Object> vdataTable = new Vector<Object>();
        Vector<String> vdataColumn = new Vector<String>();
        try {
            String str;
            FileReader freader = new FileReader(file);
            BufferedReader breader = new BufferedReader(freader);
            vdataTable.clear();
            while ((str = breader.readLine()) != null) {
                StringTokenizer st;
                if (str.trim().startsWith(SHARP_BIKKURI)) {
                    st = new StringTokenizer(str);
                    st.nextToken();
                    vcolNameColumn.clear();
                    numident = 0;
                    try {
                        while (true) {
                            String data = st.nextToken();
                            ++numident;
                            vcolNameColumn.addElement(data);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!str.trim().startsWith(SHARP) && str.trim().length() != 0) {
                    st = new StringTokenizer(str);
                    ++numrow;
                    numcol = 0;
                    try {
                        while (true) {
                            String data = st.nextToken();
                            ++numcol;
                            vdataColumn.addElement(data);
                        }
                    }
                    catch (Exception exception) {
                        vdataTable.addElement(vdataColumn.clone());
                        vdataColumn.clear();
                        continue;
                    }
                }
                char[] dst = new char[str.length()];
                str.getChars(1, str.length(), dst, 0);
                strheader = String.valueOf(strheader) + String.copyValueOf(dst).trim() + System.getProperty("line.separator");
                ++numhead;
            }
            freader.close();
            breader.close();
        }
        catch (Exception e) {
            System.out.println("failed read from " + file);
            System.out.println("error " + e);
        }
        this.vcolName.addElement(vcolNameColumn.clone());
        this.vdata.addElement(vdataTable.clone());
        this.vnumCols.addElement(new Integer(numcol));
        this.vnumRows.addElement(new Integer(numrow));
        this.vnumIdent.addElement(new Integer(numident));
        this.vheader.addElement(strheader);
    }

    private JTable createDataTable(int numRows, int numCols) {
        DefaultTableModel tableModel = new DefaultTableModel(numRows, numCols);
        JTable table = this.createTable(tableModel);
        return table;
    }

    private JTable createDataTable(String[] colName, int numRows) {
        DefaultTableModel tableModel = new DefaultTableModel(colName, numRows);
        JTable table = this.createTable(tableModel);
        return table;
    }

    private JTable createDataTable(String[][] data, String[] colName) {
        DefaultTableModel tableModel = new DefaultTableModel(data, colName);
        JTable table = this.createTable(tableModel);
        return table;
    }

    private JTable createTable(DefaultTableModel tableModel) {
        this.table_for_data = new JTable(tableModel);
        this.table_for_data.setColumnSelectionAllowed(true);
        this.table_for_data.setRowSelectionAllowed(this.selectionMode);
        this.table_for_data.setAutoResizeMode(0);
        return this.table_for_data;
    }

    private void deleteData() {
        if (this.dataLabel > 0) {
            int deleteLabel = this.tpdata.getSelectedIndex();
            this.vdirectory.remove(deleteLabel);
            this.vfilename.remove(deleteLabel);
            this.vcolName.remove(deleteLabel);
            this.vdata.remove(deleteLabel);
            this.vnumCols.remove(deleteLabel);
            this.vnumRows.remove(deleteLabel);
            this.vnumIdent.remove(deleteLabel);
            this.vheader.remove(deleteLabel);
            this.vtable.remove(deleteLabel);
            --this.dataLabel;
            this.tpdata.remove(deleteLabel);
            this.setHeaderInfo();
        } else {
            System.out.println("no data to remove");
        }
    }

    private void saveData() {
        ChaseFileChooser fdlg = new ChaseFileChooser("graph");
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("save");
        fdlg.setFileSelectionMode(0);
        if (fdlg.showDialog(this.cont, "open") != 0) {
            return;
        }
        String datafile = ((JFileChooser)fdlg).getSelectedFile().getAbsolutePath();
        File file = new File(datafile);
        try {
            int i;
            PrintWriter fout = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            int tabnum = this.tpdata.getSelectedIndex();
            char cr = System.getProperty("line.separator").charAt(0);
            String str = (String)this.vheader.get(tabnum);
            if (str.trim().length() != 0) {
                char[] chara = str.trim().toCharArray();
                fout.print(SHARP);
                i = 0;
                while (i < chara.length) {
                    if (chara[i] == cr) {
                        fout.print(chara[i]);
                        fout.print(SHARP);
                    } else {
                        fout.print(chara[i]);
                    }
                    ++i;
                }
            }
            Vector vcolNameColumn = (Vector)this.vcolName.get(tabnum);
            fout.print(cr);
            fout.print("#!  ");
            int j = 0;
            while (j < vcolNameColumn.size()) {
                fout.print(vcolNameColumn.get(j) + "  ");
                ++j;
            }
            fout.print(cr);
            int numCols = (Integer)this.vnumCols.get(tabnum);
            int numRows = (Integer)this.vnumRows.get(tabnum);
            Vector vdataTable = (Vector)this.vdata.get(tabnum);
            i = 0;
            while (i < numRows) {
                Vector vcol = (Vector)vdataTable.get(i);
                j = 0;
                while (j < numCols) {
                    fout.print(vcol.get(j) + "  ");
                    ++j;
                }
                fout.print(cr);
                ++i;
            }
            fout.close();
        }
        catch (Exception exception) {
            System.out.println("failed write to " + file);
        }
    }

    private int plotData() {
        int i;
        int numSelected_rows;
        int[] index_selected_rows;
        int tabnum = this.tpdata.getSelectedIndex();
        int type = this.comboplottypes.getSelectedIndex();
        if (tabnum < 0) {
            return -1;
        }
        JTable table = (JTable)this.vtable.get(tabnum);
        int numCols = (Integer)this.vnumCols.get(tabnum);
        int numRows = (Integer)this.vnumRows.get(tabnum);
        int numIdent = (Integer)this.vnumIdent.get(tabnum);
        int[] index_selected = table.getSelectedColumns();
        int numSelected = index_selected.length;
        if (table.getRowSelectionAllowed()) {
            index_selected_rows = table.getSelectedRows();
            numSelected_rows = index_selected_rows.length;
        } else {
            index_selected_rows = new int[numRows];
            i = 0;
            while (i < numRows) {
                index_selected_rows[i] = i;
                ++i;
            }
            numSelected_rows = numRows;
        }
        if (numSelected <= 1) {
            System.out.println("select at least two columns!");
            return -1;
        }
        if (numSelected_rows <= 0) {
            System.out.println("select at least one row!");
            return -1;
        }
        String[][] data_out = new String[numSelected][numSelected_rows];
        i = 0;
        while (i < numSelected) {
            int j = 0;
            while (j < numSelected_rows) {
                data_out[i][j] = (String)table.getModel().getValueAt(index_selected_rows[j], index_selected[i]);
                ++j;
            }
            ++i;
        }
        String xlabel = new String();
        String ylabel = new String();
        Vector veccol = (Vector)this.vcolName.get(tabnum);
        String[] legendtext = new String[]{};
        if (type == 0) {
            legendtext = new String[numSelected];
            i = 0;
            while (i < numSelected) {
                try {
                    legendtext[i] = (String)veccol.get(index_selected[i]);
                }
                catch (Exception e) {
                    legendtext[i] = i == 0 ? "x" : "y" + Integer.toString(i);
                }
                ++i;
            }
            i = 0;
            while (i < numSelected) {
                try {
                    if (i == 0) {
                        xlabel = (String)veccol.get(index_selected[i]);
                    } else {
                        ylabel = String.valueOf(ylabel) + " " + (String)veccol.get(index_selected[i]);
                    }
                }
                catch (Exception e) {
                    xlabel = "x";
                    ylabel = "y";
                }
                ++i;
            }
        } else if (type == 1) {
            legendtext = new String[numSelected_rows];
            i = 0;
            while (i < numSelected_rows) {
                legendtext[i] = data_out[0][i];
                ++i;
            }
        }
        String strfilename = (String)this.vfilename.get(tabnum);
        return 0;
    }

    public void setProjDir(String projdir) {
        this.projdir = projdir;
    }

    public GraphPanel getGraphPanel() {
        return this.graphpanel;
    }
}

