/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.file.FileNameEditPanel;
import ciss.phase_viewer.file.FileTransferPanel;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class ManipTest
extends ProjectManipulator {
    private Logger logger = Logger.getLogger((String)ManipTest.class.getName());
    private ChaseFileManager fileManager;
    private DefaultListModel listModel;
    private JList pplist;
    private String ppDir = Utils.getDefaultPPDir();

    public ManipTest(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    @Override
    public void initializeProject() {
    }

    @Override
    public void init() {
        this.fileManager = this.projectInfo.getChaseFileManager();
        this.setLayout(new BorderLayout());
        JPanel pppanel = this.getPPPanel();
        FileTransferPanel ftpanel = new FileTransferPanel(this.projectInfo);
        JButton btnedit = new JButton("edit");
        this.add((Component)ftpanel, "North");
        this.add((Component)pppanel, "Center");
        this.add((Component)btnedit, "South");
        btnedit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FileNameEditPanel editPanel = new FileNameEditPanel(ManipTest.this.fileManager);
            }
        });
        this.updateProject();
    }

    private JPanel getPPPanel() {
        JPanel pan = new JPanel();
        pan.setLayout(new BoxLayout(pan, 1));
        this.listModel = new DefaultListModel();
        this.pplist = new JList(this.listModel);
        JScrollPane pane = new JScrollPane(this.pplist);
        pane.setSize(new Dimension(500, 300));
        JPanel btnpane = new JPanel();
        btnpane.setLayout(new BoxLayout(btnpane, 0));
        JButton ppadd = new JButton("add");
        JButton ppdel = new JButton("del");
        btnpane.add(ppadd);
        btnpane.add(ppdel);
        pan.add(pane);
        pan.add(btnpane);
        ppadd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ManipTest.this.addPP();
            }
        });
        ppdel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ManipTest.this.delPP();
            }
        });
        return pan;
    }

    private void updateProject() {
        this.logger.debug((Object)"updating project...");
        DefaultListModel listModel = (DefaultListModel)this.pplist.getModel();
        listModel.removeAllElements();
        ChaseFile[] pot = this.fileManager.getFiles("F_POT(.+)");
        if (pot != null && pot.length != 0) {
            this.logger.debug((Object)("num. pp files: " + pot.length));
            int i = 0;
            while (i < pot.length) {
                this.logger.debug((Object)pot[i]);
                listModel.addElement(pot[i]);
                ++i;
            }
        } else {
            this.logger.debug((Object)"no ppfiles");
        }
    }

    private void addPP() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(this.ppDir));
        if (chooser.showOpenDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            String projdir = this.projectInfo.getProjectDirectory();
            String dir = Utils.getRelativePath(projdir, this.ppDir);
            ChaseFile cf = this.fileManager.addFile(dir, "F_POT(.+)", file.getName());
            this.fileManager.save();
            this.listModel.addElement(cf);
        }
    }

    private void delPP() {
        int sele = this.pplist.getSelectedIndex();
        if (sele >= 0) {
            this.fileManager.removeFile(this.listModel.remove(sele));
            this.fileManager.save();
        }
    }
}

