/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.ChaseFileInfoSpec;
import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.file.FileTransferSchemeTable;
import ciss.phase_viewer.file.FileTransferSchemeTableModel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class FileTransferInfoEditorPanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)FileTransferInfoEditorPanel.class.getName());
    private ChaseFileManager fileManager;
    private DefaultTableModel tableModel;
    private FileTransferSchemeTable table;
    private ChaseFileInfoSpec[] specs;
    private ChaseFile[] chaseFiles;

    public FileTransferInfoEditorPanel(ChaseFileManager fileManager) {
        super("edit file-transfer info", true, true, true, true, new Dimension(700, 420));
        this.fileManager = fileManager;
        this.init();
    }

    private void init() {
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        cont.add((Component)this.createPathViewers(), "North");
        JPanel paa = this.createTable();
        cont.add((Component)paa, "Center");
        cont.add((Component)this.createButtons(), "South");
    }

    private JPanel createPathViewers() {
        this.logger.debug((Object)"at createPathViewers()");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        InputPanel target = new InputPanel("target dir for " + this.fileManager.getHostInfo().getName(), 0, 10);
        target.setValue(this.fileManager.getProjectInfo().getTargetDirectory());
        target.getTextField().setEditable(false);
        panel.add(target);
        return panel;
    }

    private JPanel createTable() {
        this.logger.debug((Object)"at createtable");
        JPanel panel = new JPanel();
        this.chaseFiles = this.fileManager.getFiles();
        if (this.chaseFiles == null || this.chaseFiles.length == 0) {
            this.logger.error((Object)"invalid ChaseFile's");
            return new JPanel();
        }
        ChaseFileInfoSpec[] tmpspec = this.fileManager.getFileInfoSpecs();
        Vector<ChaseFileInfoSpec> vec = new Vector<ChaseFileInfoSpec>();
        int i = 0;
        while (i < tmpspec.length) {
            if (!tmpspec[i].getEditor().equals("null")) {
                vec.addElement(tmpspec[i]);
            }
            ++i;
        }
        this.specs = new ChaseFileInfoSpec[vec.size()];
        vec.copyInto(this.specs);
        int numfiles = this.chaseFiles.length;
        Object[] colnames = new String[this.specs.length];
        int i2 = 0;
        while (i2 < this.specs.length) {
            colnames[i2] = this.specs[i2].getName();
            this.logger.debug((Object)("column name: " + (String)colnames[i2]));
            ++i2;
        }
        this.tableModel = new FileTransferSchemeTableModel(colnames, numfiles);
        this.table = new FileTransferSchemeTable(this.tableModel, this.specs);
        i2 = 0;
        while (i2 < this.chaseFiles.length) {
            int j = 0;
            while (j < this.table.getColumnCount()) {
                String cname = this.table.getColumnName(j);
                Object val = this.chaseFiles[i2].getValue(cname);
                if (val != null) {
                    this.table.setValueAt(val, i2, j);
                }
                ++j;
            }
            ++i2;
        }
        JPanel ptab = new JPanel();
        ptab.setLayout(new BoxLayout(ptab, 1));
        ptab.add(this.table.getTableHeader());
        ptab.add(this.table);
        JScrollPane scrpane = new JScrollPane(ptab);
        scrpane.setPreferredSize(new Dimension(650, 300));
        panel.add(scrpane);
        return panel;
    }

    private JPanel createButtons() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        JButton btnsave = new JButton("save to disk");
        JButton btnclose = new JButton("close");
        btnsave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransferInfoEditorPanel.this.saveToDisk();
            }
        });
        btnclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransferInfoEditorPanel.this.dispose();
            }
        });
        panel.add(btnsave);
        panel.add(btnclose);
        return panel;
    }

    private void saveToDisk() {
        this.logger.debug((Object)"saving file info...");
        if (this.specs == null || this.specs.length == 0) {
            this.logger.info((Object)"nothing to save.");
            return;
        }
        if (this.table.getRowCount() != this.chaseFiles.length) {
            this.logger.error((Object)"rowCount and filenum inconsistent !!");
            return;
        }
        int i = 0;
        while (i < this.table.getRowCount()) {
            int j = 0;
            while (j < this.table.getColumnCount()) {
                String ident = this.table.getColumnName(j);
                this.logger.debug((Object)("saving " + ident + " for: " + this.chaseFiles[i].getIdentifier().getValue()));
                Object obj = this.table.getValueAt(i, j);
                this.chaseFiles[i].update(ident, this.table.getValueAt(i, j).toString());
                ++j;
            }
            ++i;
        }
        this.fileManager.save();
    }
}

