/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import ciss.phase_viewer.file.ChaseFile;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

class FileNameEditor
extends JPanel {
    private JTextField textField;
    private ChaseFile file;
    private Logger logger = Logger.getLogger((String)FileNameEditor.class.getName());

    FileNameEditor(ChaseFile file) {
        this.file = file;
        this.setLayout(new BoxLayout(this, 1));
        String ident = file.getIdentifier().getValue();
        this.setBorder(new TitledBorder(ident));
        String name = file.getFileName();
        this.textField = new JTextField(name);
        this.add(this.textField);
        this.textField.setToolTipText(file.getFileName());
    }

    void save() {
        String newName = this.textField.getText();
        if (newName != null && newName.trim().length() != 0) {
            this.file.update("filename", newName);
            this.file.fileStateChanged();
        } else {
            this.logger.error((Object)"invalid filename!");
            this.textField.setText(this.file.getFileName());
        }
    }

    void setDefaultName() {
        this.textField.setText(this.file.getDefaultName().getDefault());
    }
}

