/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.file;

import ciss.phase_viewer.common.RegExpedString;
import ciss.phase_viewer.file.ChaseFileChangeEvent;
import ciss.phase_viewer.file.ChaseFileInfoSpec;
import ciss.phase_viewer.file.FileChangeListener;
import ciss.phase_viewer.jdom.MyElement;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class ChaseFile {
    private Logger logger = Logger.getLogger((String)ChaseFile.class.getName());
    private String identifier;
    private Element fileInfoElement;
    private File file;
    private String fileName;
    private String parentPath;
    public static final String INTENT = "intent";
    public static final String IDENT = "identifier";
    public static final String DEFAULTNAME = "defaultname";
    public static final String BASEDIR = "basedir";
    public static final String FNAME = "filename";
    public static final String TRANSFER_INFO = "transfer_info";
    public static final String FILENAME_EDITLEVEL = "filename_editlevel";
    public static final String RELATIVE_PATH = "relative_path";
    public static final String OUTPUT_PARSER = "output_parser";
    private String intent;
    private RegExpedString ident;
    private RegExpedString defName;
    private String defaultName;
    private String fileNameEditLevel;
    public static String ALWAYS = "always";
    public static String NEVER = "never";
    public static String ON_DEMAND = "on_demand";
    private String outputParser = "";
    private String monitor = "";
    private boolean monitorable = false;
    private String filename = "";
    private String relative_path = ".";
    public static String ALL = "ALL";
    public static String NEWEST_ONLY = "NEWEST_ONLY";
    private String transfer = ALL;
    private boolean upload = false;
    private boolean download = false;
    public static String OVERWRITE = "OVERWRITE";
    public static String DO_NOTHING = "DO_NOTHING";
    public static String APPEND = "APPEND";
    public static String RENAME = "RENAME";
    public static String RENAME_LOCAL = "RENAME_LOCAL";
    private String duplicate_file = OVERWRITE;
    private Element elem;
    private Vector fileChangeListeners = new Vector();
    private LinkedHashMap chaseFileInfoSpec = new LinkedHashMap();

    public ChaseFile(Element elem, LinkedHashMap chaseFileInfoSpec) {
        this.elem = elem;
        this.chaseFileInfoSpec = chaseFileInfoSpec;
        this.create();
    }

    public ChaseFile(Element elem) {
        this.elem = elem;
        this.create();
    }

    protected void recreate() {
        this.create();
    }

    public Element getElement() {
        return this.elem;
    }

    public void addFileChangeListener(FileChangeListener listener) {
        this.fileChangeListeners.addElement(listener);
    }

    public void removeFileChangeListener(FileChangeListener listener) {
        this.fileChangeListeners.remove(listener);
    }

    public void fileStateChanged() {
        int i = 0;
        while (i < this.fileChangeListeners.size()) {
            ((FileChangeListener)this.fileChangeListeners.get(i)).fileChanged(new ChaseFileChangeEvent(this));
            ++i;
        }
    }

    public void update(String key, String val) {
        Element ele;
        Object obj;
        ChaseFileInfoSpec spec = null;
        if (this.chaseFileInfoSpec != null && (obj = this.chaseFileInfoSpec.get(key)) != null) {
            spec = (ChaseFileInfoSpec)obj;
        }
        boolean isPathString = false;
        if (spec != null) {
            isPathString = spec.getType().equals(ChaseFileInfoSpec.TYPE_PATH_STR);
        }
        if ((ele = this.elem.getChild(key)) == null) {
            Element newEle = new Element(key);
            if (!isPathString) {
                newEle.setText(val);
            } else {
                newEle.setText(MyElement.encode(val));
            }
            this.elem.addContent((Content)newEle);
            return;
        }
        if (!isPathString) {
            ele.setText(val);
        } else {
            ele.setText(MyElement.encode(val));
        }
        this.create();
    }

    public void update(String key, Boolean b) {
        String val = b.toString();
        this.update(key, val);
    }

    public boolean upload_or_download(String upload_or_download) {
        if (upload_or_download.equalsIgnoreCase("upload")) {
            return this.upload();
        }
        if (upload_or_download.equalsIgnoreCase("download")) {
            return this.download();
        }
        return false;
    }

    private void create() {
        this.intent = this.elem.getChildTextTrim(INTENT);
        this.ident = new RegExpedString(this.elem.getChild(IDENT));
        this.defName = new RegExpedString(this.elem.getChild(DEFAULTNAME));
        this.filename = this.elem.getChildTextTrim(FNAME);
        this.relative_path = this.elem.getChildTextTrim(RELATIVE_PATH);
        this.fileNameEditLevel = this.elem.getChildTextTrim("filenameeditlevel");
        this.outputParser = this.elem.getChildTextTrim(OUTPUT_PARSER);
        this.monitor = this.elem.getChildTextTrim("monitor");
        if (this.monitor != null && this.monitor.trim().length() != 0) {
            this.monitorable = true;
        }
        this.transfer = this.elem.getChildTextTrim("transfer");
        this.upload = new Boolean(this.elem.getChildTextTrim("upload"));
        this.download = new Boolean(this.elem.getChildTextTrim("download"));
        this.duplicate_file = this.elem.getChildTextTrim("duplicate_file");
        this.logger.debug((Object)("ident: " + this.ident.getValue() + " filename: " + this.filename + " duplicate_file: " + this.duplicate_file + " monitor: " + this.monitor));
    }

    public String getIntent() {
        return this.intent;
    }

    public RegExpedString getIdentifier() {
        return this.ident;
    }

    public RegExpedString getDefaultName() {
        return this.defName;
    }

    public String getFileName() {
        if (this.filename == null || this.filename.trim().length() == 0) {
            return this.defaultName;
        }
        return this.filename;
    }

    public Object getValue(String ident) {
        Object obj;
        Element child = this.elem.getChild(ident);
        if (child == null) {
            return null;
        }
        String str = child.getTextTrim();
        if (str.equals("true") || str.equals("false")) {
            return new Boolean(str);
        }
        boolean type_path = false;
        if (this.chaseFileInfoSpec != null && (obj = this.chaseFileInfoSpec.get(ident)) != null) {
            type_path = ((ChaseFileInfoSpec)obj).getType().equals(ChaseFileInfoSpec.TYPE_PATH_STR);
        }
        String ret = str;
        if (type_path) {
            ret = MyElement.decode(str);
        }
        this.logger.debug((Object)("ChaseFile.getValue: type: path? " + type_path + " returning: " + ret));
        return ret;
    }

    public String getFileNameEditLevel() {
        return this.fileNameEditLevel;
    }

    public String getOutputParserPath() {
        return this.outputParser;
    }

    public String getTransfer() {
        return this.transfer;
    }

    public boolean upload() {
        return this.upload;
    }

    public boolean download() {
        return this.download;
    }

    public String getDuplicateFile() {
        return this.duplicate_file;
    }

    public String getRelativePath() {
        return MyElement.decode(this.relative_path);
    }

    public boolean isMonitorable() {
        return this.monitorable;
    }

    public String getMonitorPath() {
        return this.monitor;
    }

    public String toString() {
        return this.getFileName();
    }
}

