/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.OldOutputParser;
import java.util.StringTokenizer;
import java.util.Vector;

public class Output000Parser
extends OldOutputParser {
    private int numColumns = 2;
    private int numRows;
    private boolean totalEnergy = false;
    private boolean ki = false;
    private boolean ha = false;
    private boolean xc = false;
    private boolean lo = false;
    private boolean nl = false;
    private boolean ew = false;
    private boolean pc = false;
    private boolean edeltb = false;
    private int iter_elec = 0;
    private int iter_ionic = 1;
    public static final int TYPE_ENERGY = 0;
    public static final int TYPE_CPU = 1;
    public static final int TYPE_CHARGE = 2;
    private int type;
    private String identTOTAL = "TOTAL ENERGY FOR";
    private String identKI = "KI=";
    private String identHA = "HA=";
    private String identXC = "XC=";
    private String identLO = "LO=";
    private String identNL = "NL=";
    private String identEW = "EW=";
    private String identPC = "PC=";
    private String identIter = "ITER=";
    private String identIterIon = "! iteration_ionic";
    private String identEdeltb = "! edeltb =";
    private String identCPU = "<< CPU Time Consumption";
    private int readingBlock = 0;
    private int readingCPU = 0;
    private int readingCharge = 0;
    private String cpuIterCount;
    private int chargeIterCount;
    private String identCharge = "!NEW total charge";

    public Output000Parser(String filename, int type) {
        super(filename);
        this.type = type;
        String cr = OldOutputParser.CR;
        if (type == 0) {
            this.addHeader("# energy_stdout" + OldOutputParser.CR);
            this.addColumnName("iter_ionic");
            this.addColumnName("iter_electronic");
        } else if (type == 1) {
            this.addHeader("# CPU_statistics_stdout" + OldOutputParser.CR);
        } else if (type == 2) {
            this.addHeader("# charge_data_stdout" + OldOutputParser.CR);
        }
    }

    public void setTotalEnergy(boolean totalEnergy) {
        this.totalEnergy = totalEnergy;
    }

    public boolean getTotalEnergy() {
        return this.totalEnergy;
    }

    public void setKI(boolean ki) {
        this.ki = ki;
    }

    public boolean getKI() {
        return this.ki;
    }

    public void setHA(boolean ha) {
        this.ha = ha;
    }

    public boolean getHA() {
        return this.ha;
    }

    public void setXC(boolean xc) {
        this.xc = xc;
    }

    public boolean getXC() {
        return this.xc;
    }

    public void setLO(boolean lo) {
        this.lo = lo;
    }

    public boolean getLO() {
        return this.lo;
    }

    public void setNL(boolean nl) {
        this.nl = nl;
    }

    public boolean getNL() {
        return this.nl;
    }

    public void setEW(boolean ew) {
        this.ew = ew;
    }

    public boolean getEW() {
        return this.ew;
    }

    public void setPC(boolean pc) {
        this.pc = pc;
    }

    public boolean getPC() {
        return this.pc;
    }

    public void setEdeltb(boolean edeltb) {
        this.edeltb = edeltb;
    }

    public boolean getEdeltb() {
        return this.edeltb;
    }

    public void calculateNumColumns() {
        if (this.type == 0) {
            if (this.totalEnergy) {
                ++this.numColumns;
                this.addColumnName("total_enery");
            }
            if (this.ki) {
                ++this.numColumns;
                this.addColumnName("KI_energy");
            }
            if (this.ha) {
                ++this.numColumns;
                this.addColumnName("HA_energy");
            }
            if (this.xc) {
                ++this.numColumns;
                this.addColumnName("XC_energy");
            }
            if (this.lo) {
                ++this.numColumns;
                this.addColumnName("LO_energy");
            }
            if (this.nl) {
                ++this.numColumns;
                this.addColumnName("NL_energy");
            }
            if (this.ew) {
                ++this.numColumns;
                this.addColumnName("EW_energy");
            }
            if (this.pc) {
                ++this.numColumns;
                this.addColumnName("PC_energy");
            }
            if (this.edeltb) {
                ++this.numColumns;
                this.addColumnName("edeltb");
            }
            this.setNumColumns(this.numColumns);
        } else if (this.type == 1) {
            this.addColumnName("iteration");
            this.addColumnName("rank");
            this.addColumnName("name_of_subroutine");
            this.addColumnName("time(sec)");
            this.addColumnName("percentage(%)");
            this.setNumColumns(5);
        } else if (this.type == 2) {
            this.addColumnName("iteration");
            this.addColumnName("up");
            this.addColumnName("down");
            this.addColumnName("sum");
            this.setNumColumns(4);
        } else {
            System.out.println("invalid specification for argument 'type'");
        }
    }

    @Override
    public void parseString(String str) {
        if (this.type == 0) {
            this.extractEnergy(str);
        } else if (this.type == 1) {
            this.extractCPUStats(str);
        } else if (this.type == 2) {
            this.extractChargeData(str);
        } else {
            System.out.println("invalid type");
        }
    }

    private void extractEnergy(String str) {
        StringTokenizer st = new StringTokenizer(str);
        String strdata = new String();
        if (str.trim().startsWith(this.identTOTAL)) {
            ++this.iter_elec;
            this.addDataColumn(Integer.toString(this.iter_ionic));
            this.addDataColumn(Integer.toString(this.iter_elec));
            this.readingBlock = 1;
            while (st.hasMoreTokens()) {
                strdata = st.nextToken();
                if (!strdata.equals(this.identIter) || !this.totalEnergy) continue;
                this.addDataColumn(st.nextToken());
            }
        } else if (str.trim().startsWith(this.identKI) && this.readingBlock == 1) {
            while (st.hasMoreTokens()) {
                strdata = st.nextToken();
                if (strdata.equals(this.identKI) && this.ki) {
                    this.addDataColumn(st.nextToken());
                    continue;
                }
                if (strdata.equals(this.identHA) && this.ha) {
                    this.addDataColumn(st.nextToken());
                    continue;
                }
                if (strdata.equals(this.identXC) && this.xc) {
                    this.addDataColumn(st.nextToken());
                    continue;
                }
                if (!strdata.equals(this.identLO) || !this.lo) continue;
                this.addDataColumn(st.nextToken());
            }
        } else if (str.trim().startsWith(this.identNL) && this.readingBlock == 1) {
            while (st.hasMoreTokens()) {
                strdata = st.nextToken();
                if (strdata.equals(this.identNL) && this.nl) {
                    this.addDataColumn(st.nextToken());
                    continue;
                }
                if (strdata.equals(this.identEW) && this.ew) {
                    this.addDataColumn(st.nextToken());
                    continue;
                }
                if (!strdata.equals(this.identPC) || !this.pc) continue;
                this.addDataColumn(st.nextToken());
            }
        } else if (str.trim().startsWith(this.identEdeltb) && this.readingBlock == 1) {
            while (st.hasMoreTokens()) {
                strdata = st.nextToken();
                if (!strdata.startsWith("(=")) continue;
                strdata = st.nextToken();
                strdata = strdata.replace('D', 'E');
                strdata = strdata.replace('d', 'E');
                this.addDataColumn(strdata);
                break;
            }
            this.readingBlock = 2;
        } else if (str.trim().startsWith(this.identIterIon)) {
            ++this.iter_ionic;
        }
        if (this.readingBlock == 2) {
            this.addDataRow();
            this.readingBlock = 0;
        }
        if (str.trim().startsWith("EFermi")) {
            this.addHeader("#" + str + OldOutputParser.CR);
        }
    }

    private void extractCPUStats(String str) {
        if (!str.trim().startsWith("Total cpu time")) {
            char[] ch;
            StringTokenizer st = new StringTokenizer(str);
            String strdata = new String();
            String strdata1 = new String();
            String strdata2 = new String();
            if (this.readingCPU >= 1 && this.readingCPU <= 10) {
                this.addDataColumn(this.cpuIterCount);
                if (st.hasMoreTokens()) {
                    this.addDataColumn(st.nextToken());
                    st.nextToken();
                    strdata = st.nextToken();
                    strdata1 = st.nextToken();
                    if (strdata1.startsWith("xc_pot")) {
                        this.addDataColumn(String.valueOf(strdata) + "_" + strdata1);
                        strdata = st.nextToken();
                        char[] ch2 = strdata.toCharArray();
                        strdata = new String(ch2, 0, ch2.length - 6);
                        strdata1 = st.nextToken();
                        char[] ch0 = strdata1.toCharArray();
                        strdata1 = new String(ch0, 0, ch0.length - 3);
                        this.addDataColumn(strdata);
                        this.addDataColumn(strdata1);
                    } else {
                        this.addDataColumn(strdata);
                        char[] ch0 = strdata1.toCharArray();
                        strdata1 = new String(ch0, 0, ch0.length - 6);
                        strdata2 = st.nextToken();
                        ch = strdata2.toCharArray();
                        strdata2 = new String(ch, 0, ch.length - 3);
                        this.addDataColumn(strdata1);
                        this.addDataColumn(strdata2);
                    }
                }
                Vector col = this.getDataColumn();
                ++this.readingCPU;
                this.addDataRow();
            }
            if (str.trim().startsWith(this.identCPU)) {
                ++this.readingCPU;
                while (st.hasMoreTokens()) {
                    strdata = st.nextToken();
                    if (!strdata.equals("Subroutines")) continue;
                    st.nextToken();
                    String cpuIterCount_wk = st.nextToken();
                    ch = cpuIterCount_wk.toCharArray();
                    this.cpuIterCount = new String(ch, 0, ch.length - 1);
                }
            }
            if (this.readingCPU == 11) {
                this.readingCPU = 0;
            }
        } else {
            this.readingCPU = 0;
        }
    }

    private void extractChargeData(String str) {
        StringTokenizer st = new StringTokenizer(str);
        String strdata = new String();
        if (str.trim().startsWith(this.identCharge)) {
            this.readingCharge = 1;
        }
        if (this.readingCharge == 1) {
            this.addDataColumn(Integer.toString(this.chargeIterCount));
            while (st.hasMoreTokens()) {
                strdata = st.nextToken();
                if (!strdata.startsWith("=")) continue;
                this.addDataColumn(st.nextToken());
                st.nextToken();
                this.addDataColumn(st.nextToken());
                st.nextToken();
                this.addDataColumn(st.nextToken());
            }
        }
        if (str.trim().startsWith(this.identTOTAL)) {
            ++this.chargeIterCount;
        }
        if (this.readingCharge == 1) {
            this.addDataRow();
            this.readingCharge = 0;
        }
    }
}

