/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.MenuBlock;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public class MenuTree {
    private Logger logger = Logger.getLogger((String)MenuTree.class.getName());
    private MenuBlock list = new MenuBlock(null, null);

    public void addMenu(JMenu menu) {
        this.list.add(new MenuBlock(this.list, menu));
    }

    public void addMenuItem(JMenuItem menuItem) {
        this.addMenuItem(menuItem, false);
    }

    public void addMenuItem(JMenuItem menuItem, boolean hasSeparator) {
        JMenu menu = this.list.getMenu();
        if (menu != null) {
            if (hasSeparator) {
                menu.add(new JSeparator());
            }
            menu.add(menuItem);
        }
    }

    public void selectBlock(JMenu menu) {
        String name = menu.getText();
        this.logger.debug((Object)("menu: " + menu));
        this.logger.debug((Object)("size of list: " + this.list.size()));
        int i = 1;
        while (i < this.list.size()) {
            MenuBlock bl = (MenuBlock)this.list.get(i);
            this.logger.debug((Object)("block: " + bl));
            if (name.trim().equals(bl.getName())) {
                this.list = bl;
                return;
            }
            ++i;
        }
        this.list.add(new MenuBlock(this.list, menu));
        this.selectBlock(menu);
    }

    public void selectBlock(String name) {
        int i = 1;
        while (i < this.list.size()) {
            MenuBlock bl = (MenuBlock)this.list.get(i);
            this.logger.debug((Object)("block: " + bl));
            if (name.trim().equals(bl.getName())) {
                this.list = bl;
                return;
            }
            ++i;
        }
        JMenu menu = new JMenu(name);
        this.list.add(new MenuBlock(this.list, menu));
        this.selectBlock(menu);
    }

    public void selectParent() {
        this.list = (MenuBlock)this.list.get(0);
    }

    public void selectRoot() {
        while (this.list.get(0) != null) {
            this.selectParent();
        }
    }

    public JMenu[] getMenus() {
        this.selectRoot();
        Vector<JMenu> menuvec = new Vector<JMenu>();
        int i = 1;
        while (i < this.list.size()) {
            menuvec.addElement(((MenuBlock)this.list.get(i)).getMenu());
            ++i;
        }
        if (menuvec.size() == 0) {
            return null;
        }
        Object[] ret = new JMenu[menuvec.size()];
        menuvec.copyInto(ret);
        return ret;
    }
}

