/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.inputinterfacetable.ComboBoxChoices;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ComboBoxChoicesInputInterface
implements ComboBoxChoices {
    private Logger logger = Logger.getLogger((String)ComboBoxChoicesInputInterface.class.getName());
    private InputInterface inputInterface;
    private String type;
    private String tag;
    private String tagbuf;
    private String name;
    private String TABLE = "table";
    private String PRIMITIVE_ENTRY = "primitive_entry";

    public ComboBoxChoicesInputInterface(InputInterface inputInterface, String type, String tag) {
        this.inputInterface = inputInterface;
        this.type = type;
        this.tag = tag.trim();
        int last = tag.lastIndexOf(".");
        if (last > 0) {
            this.tagbuf = String.copyValueOf(tag.toCharArray(), 0, last);
            this.name = String.copyValueOf(tag.toCharArray(), last + 1, tag.length() - last - 1);
            this.logger.debug((Object)("tag & name: " + this.tagbuf + " " + this.name));
        } else {
            this.tagbuf = tag;
            this.name = tag;
        }
    }

    @Override
    public Object[] getChoices() {
        try {
            int targetIndex = 0;
            this.inputInterface.selectBlock(this.tagbuf);
            InputInterfaceTable table = this.inputInterface.getTable();
            Vector data = table.getTableData();
            InputInterfaceTableColumns[] cols = this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(this.tagbuf).getTableColumns();
            this.inputInterface.selectRoot();
            int i = 0;
            while (i < cols.length) {
                if (cols[i].getName().equals(this.name)) {
                    targetIndex = i;
                    break;
                }
                ++i;
            }
            Object[] ret = new String[data.size()];
            int i2 = 0;
            while (i2 < data.size()) {
                String[] tmp = (String[])data.elementAt(i2);
                ret[i2] = tmp[targetIndex];
                ++i2;
            }
            return ret;
        }
        catch (Exception ex) {
            this.logger.debug((Object)("failed to get choices from: " + this.tag));
            ex.printStackTrace();
            Object[] foo = new String[]{""};
            return foo;
        }
    }

    @Override
    public Object[] getChoices(int index) {
        return null;
    }

    @Override
    public Object[] getChoices(String index) {
        return null;
    }

    @Override
    public String getToolTipTexts(int index) {
        this.inputInterface.selectBlock(this.tagbuf);
        InputInterfaceTable table = this.inputInterface.getTable();
        Vector data = table.getTableData();
        InputInterfaceTableColumns[] cols = this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(this.tagbuf).getTableColumns();
        String[] vals = (String[])data.elementAt(index);
        if (vals == null || cols == null) {
            return "";
        }
        String foo = String.valueOf(cols[0].getName()) + "=" + vals[0];
        int num = cols.length;
        if (num > vals.length) {
            num = vals.length;
        }
        int i = 1;
        while (i < num) {
            foo = String.valueOf(foo) + ", " + cols[i].getName() + "=" + vals[i];
            ++i;
        }
        return foo;
    }
}

