/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.symmetry;

import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import org.apache.log4j.Logger;

public class Tetragonal
extends BravaisLattice {
    private Logger logger = Logger.getLogger((String)Tetragonal.class.getName());

    @Override
    public String getName() {
        return String.valueOf(this.latticeSystem) + " tetragonal";
    }

    @Override
    public double[][] getPrimitiveLatticeVector() {
        if (this.latticeSystem.equals("primitive")) {
            return new double[][]{{this.a, 0.0, 0.0}, {0.0, this.b, 0.0}, {0.0, 0.0, this.c}};
        }
        if (this.latticeSystem.equals("bodycentered")) {
            return new double[][]{{-0.5 * this.a, 0.5 * this.b, 0.5 * this.c}, {0.5 * this.a, -0.5 * this.b, 0.5 * this.c}, {0.5 * this.a, 0.5 * this.b, -0.5 * this.c}};
        }
        return null;
    }

    @Override
    protected boolean isThisForMe(double a, double b, double c, double alpha, double beta, double gamma) {
        boolean checkAngle;
        boolean checkLength = this.epsilonEquals(a, b) && !this.epsilonEquals(a, c) || this.epsilonEquals(a, c) && !this.epsilonEquals(a, b) || this.epsilonEquals(b, c) && !this.epsilonEquals(a, b);
        boolean bl = checkAngle = this.epsilonEquals(alpha, 90.0) && this.epsilonEquals(beta, 90.0) && this.epsilonEquals(gamma, 90.0);
        return checkLength && checkAngle;
    }

    @Override
    public String[] getLatticeSystemCandidate() {
        return new String[]{"primitive", "bodycentered"};
    }

    @Override
    protected BravaisLattice tryToCreateBravaisLattice(double[] avec, double[] bvec, double[] cvec) {
        if (this.epsilonEquals(this.a, this.b) && !this.epsilonEquals(this.a, this.c) && this.epsilonEquals(this.alpha, 90.0) && this.epsilonEquals(this.beta, 90.0) && this.epsilonEquals(this.gamma, 90.0)) {
            this.latticeSystem = "primitive";
            return this;
        }
        boolean b1 = this.epsilonEquals(-avec[0], avec[1]) && !this.epsilonEquals(avec[1], avec[2]) && this.epsilonEquals(-bvec[0], bvec[1]) && !this.epsilonEquals(bvec[0], bvec[2]) && this.epsilonEquals(cvec[0], cvec[1]) && !this.epsilonEquals(cvec[1], -cvec[2]);
        boolean b2 = this.epsilonEquals(-avec[0], bvec[0]) && this.epsilonEquals(bvec[0], cvec[0]) && this.epsilonEquals(avec[2], bvec[2]) && this.epsilonEquals(bvec[2], -cvec[2]);
        this.logger.debug((Object)("b1 and b2 " + b1 + " " + b2));
        if (b1 && b2) {
            Tetragonal tet = new Tetragonal();
            tet.b = tet.a = 2.0 * bvec[0];
            tet.c = 2.0 * bvec[2];
            tet.beta = 90.0;
            tet.gamma = 90.0;
            tet.alpha = 90.0;
            tet.latticeSystem = "bodycentered";
            return tet;
        }
        return null;
    }

    @Override
    public String getCrystalSystem() {
        return "tetragonal";
    }
}

