/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.pmodel;

import ciss.phase_viewer.atomcoord.pmodel.Atom;
import ciss.phase_viewer.atomcoord.pmodel.Fraction;

class FractionVector {
    Fraction[] element = new Fraction[3];

    public static void main(String[] args) {
        Fraction a = new Fraction(1, 3);
        Fraction b = new Fraction(1, 4);
        Fraction c = new Fraction(1, 5);
        FractionVector fv1 = new FractionVector(a, b, c);
        a = new Fraction(1, 4);
        b = new Fraction(2, 4);
        c = new Fraction(3, 4);
        FractionVector fv2 = new FractionVector(a, b, c);
        FractionVector fv3 = new FractionVector();
        fv3 = fv1.add(fv2);
        System.out.println("FracVec 1:" + fv1);
        System.out.println("FracVec 2:" + fv2);
        System.out.println("FracVec 3:" + fv3);
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[][] matrix = nArrayArray;
        fv3 = fv1.rotate(matrix);
        System.out.println("Rotation :" + fv3);
    }

    FractionVector() {
        int i = 0;
        while (i < 3) {
            this.element[i] = new Fraction();
            ++i;
        }
    }

    FractionVector(Fraction f1, Fraction f2, Fraction f3) {
        this.element[0] = f1;
        this.element[1] = f2;
        this.element[2] = f3;
    }

    public String toString() {
        String str = "[" + this.element[0] + this.element[1] + this.element[2] + "]";
        return str;
    }

    FractionVector rotate(int[][] matrix) {
        Fraction[] a = new Fraction[3];
        int[] numerator0 = new int[3];
        int denominator = Fraction.leastCommonMultiple3(this.element[0].denominator, this.element[1].denominator, this.element[2].denominator);
        int i = 0;
        while (i < 3) {
            numerator0[i] = this.element[i].numerator * denominator / this.element[i].denominator;
            ++i;
        }
        i = 0;
        while (i < 3) {
            int numerator1 = 0;
            int j = 0;
            while (j < 3) {
                numerator1 += matrix[i][j] * numerator0[j];
                ++j;
            }
            a[i] = new Fraction(numerator1, denominator);
            a[i] = a[i].reduction().normalize();
            ++i;
        }
        return new FractionVector(a[0], a[1], a[2]);
    }

    FractionVector add(FractionVector fv2) {
        int denomi1 = Fraction.leastCommonMultiple3(this.element[0].denominator, this.element[1].denominator, this.element[2].denominator);
        int denomi2 = Fraction.leastCommonMultiple3(fv2.element[0].denominator, fv2.element[1].denominator, fv2.element[2].denominator);
        int denominator = Fraction.leastCommonMultiple(denomi1, denomi2);
        FractionVector fv = new FractionVector();
        int i = 0;
        while (i < 3) {
            int numerator = this.element[i].numerator * denominator / this.element[i].denominator + fv2.element[i].numerator * denominator / fv2.element[i].denominator;
            Fraction f = new Fraction(numerator, denominator);
            fv.element[i] = f = f.reduction().normalize();
            ++i;
        }
        return fv;
    }

    Atom shift(Atom atom) {
        Atom a1 = atom.copy();
        int i = 0;
        while (i < 3) {
            int n = i;
            a1.position[n] = a1.position[n] + this.element[i].toDouble();
            ++i;
        }
        return a1;
    }
}

