/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.pmodel;

import ciss.phase_viewer.atomcoord.pmodel.PmodelRuntimeException;

class Fraction {
    int numerator;
    int denominator;

    public static void main(String[] args) {
        Fraction a = new Fraction(7, 17);
        Fraction b = new Fraction(-9, 7);
        Fraction c = new Fraction(12, 27);
        Fraction d = new Fraction(8, 2);
        System.out.println("TEST:" + a + b + c + d);
        b = b.reduction().normalize();
        c = c.reduction();
        d = d.reduction().normalize();
        System.out.println("TEST:" + a + b + c + d);
    }

    Fraction() {
        this.numerator = 0;
        this.denominator = 1;
    }

    Fraction(int n, int d) {
        if (d == 0) {
            PmodelRuntimeException ex = new PmodelRuntimeException();
            throw ex;
        }
        if (d < 0) {
            n = -n;
            d = -d;
        }
        this.numerator = n;
        this.denominator = d;
    }

    public String toString() {
        String str = "(" + this.numerator + " / " + this.denominator + ")";
        return str;
    }

    public double toDouble() {
        return (double)this.numerator / (double)this.denominator;
    }

    Fraction reduction() {
        int n = this.numerator;
        int d = this.denominator;
        if (d == 0) {
            PmodelRuntimeException ex = new PmodelRuntimeException();
            throw ex;
        }
        if (n == 0) {
            return new Fraction();
        }
        int tmp = Fraction.greatestCommonMeasure(Math.abs(n), d);
        return new Fraction(n /= tmp, d /= tmp);
    }

    Fraction normalize() {
        int n = this.numerator;
        int d = this.denominator;
        if (d == 0) {
            PmodelRuntimeException ex = new PmodelRuntimeException();
            throw ex;
        }
        if (n == 0) {
            return new Fraction();
        }
        if ((n %= d) < 0) {
            n += d;
        }
        return new Fraction(n, d);
    }

    /*
     * Unable to fully structure code
     */
    private static int greatestCommonMeasure2(int bigger, int smaller) {
        if (bigger < 0) {
            ex = new PmodelRuntimeException();
            throw ex;
        }
        if (smaller >= 0) ** GOTO lbl10
        ex = new PmodelRuntimeException();
        throw ex;
lbl-1000:
        // 1 sources

        {
            temp = bigger % smaller;
            bigger = smaller;
            smaller = temp;
lbl10:
            // 2 sources

            ** while (smaller != 0)
        }
lbl11:
        // 1 sources

        return bigger;
    }

    private static int greatestCommonMeasure(int bigger, int smaller) {
        if (bigger < 0 || smaller < 0) {
            PmodelRuntimeException ex = new PmodelRuntimeException();
            throw ex;
        }
        if (bigger < smaller) {
            return Fraction.greatestCommonMeasure(smaller, bigger);
        }
        if (smaller == 0) {
            return bigger;
        }
        return Fraction.greatestCommonMeasure(smaller, bigger % smaller);
    }

    private static int greatestCommonMeasure(int n1, int n2, int n3) {
        int temp = Fraction.greatestCommonMeasure(n1, n2);
        return Fraction.greatestCommonMeasure(temp, n3);
    }

    static int leastCommonMultiple(int n1, int n2) {
        int temp = Fraction.greatestCommonMeasure(n1, n2);
        if (temp < 0) {
            PmodelRuntimeException ex = new PmodelRuntimeException();
            throw ex;
        }
        return n1 * n2 / temp;
    }

    static int leastCommonMultiple3(int n1, int n2, int n3) {
        int temp = Fraction.greatestCommonMeasure(n1, n2, n3);
        if (temp < 0) {
            PmodelRuntimeException ex = new PmodelRuntimeException();
            throw ex;
        }
        return n1 * n2 * n3 / temp / temp;
    }
}

