/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cube2AtomCoords;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.atomcoord.io.CubeFileFilter;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CubeImporter
implements Importer {
    private Logger logger = Logger.getLogger((String)CubeImporter.class.getName());
    private int interpolationScheme = VolumetricData.LOG;
    private PropertyChangeListener listener;

    @Override
    public boolean isImportable(String fileName) {
        if (new File(fileName).isDirectory()) {
            return false;
        }
        return this.getFileFilter().accept(new File(fileName));
    }

    @Override
    public AtomCoords[] getAtomCoordsFrom(String fileName) {
        Cube2AtomCoords c2a = new Cube2AtomCoords(fileName);
        AtomCoords coords = c2a.getAtomCoords();
        coords.getChargeDensity().setInterpolationScheme(this.interpolationScheme);
        return new AtomCoords[]{coords};
    }

    @Override
    public void setOptions(HashMap options) {
    }

    @Override
    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
        this.listener = listener;
        OptPanel panel = new OptPanel();
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public String getType() {
        return "Gaussian Cube";
    }

    @Override
    public FileFilter getFileFilter() {
        return new CubeFileFilter();
    }

    class OptPanel
    extends InternalFrameChase {
        private JComboBox interp;
        private String[] interpChoices;
        private JButton ok;

        OptPanel() {
            super("options", new Dimension(180, 130));
            this.interpChoices = new String[]{"log", "linear"};
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.init();
            this.setVisible(true);
        }

        private void init() {
            this.interp = new JComboBox<String>(this.interpChoices);
            JPanel pinterp = new JPanel();
            pinterp.setBorder(new TitledBorder("select interpolation type"));
            pinterp.add(this.interp);
            JPanel pbtn = new JPanel();
            this.ok = new JButton("ok");
            pbtn.add(this.ok);
            this.getContentPane().add(pinterp);
            this.getContentPane().add(pbtn);
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (OptPanel.this.interp.getSelectedIndex() == 1) {
                            CubeImporter.this.interpolationScheme = VolumetricData.LINEAR;
                        }
                        if (OptPanel.this.interp.getSelectedIndex() == 0) {
                            CubeImporter.this.interpolationScheme = VolumetricData.LOG;
                        }
                        OptPanel.this.dispose();
                        CubeImporter.this.listener.propertyChange(null);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
        }
    }
}

